/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.MulticastSocket;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class AcuniaMulticastSocketTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.net.MulticastSocket");
        this.test_MulticastSocket();
        this.test_joinGroup();
        this.test_leaveGroup();
        this.test_send();
        this.test_TimeToLive();
        this.test_getInterface();
        this.test_setInterface();
        this.test_behaviour();
    }

    private void close(MulticastSocket ms) {
        if (ms != null) {
            ms.close();
        }
    }

    private void checkConstructFails(int port, int count) {
        try {
            new MulticastSocket(port);
            this.th.fail("constructor must fail -- " + count);
        }
        catch (IOException ioe) {
            this.th.fail("caught wrong Exception -- " + count + " --> " + ioe);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "constructor failed with correct exception " + count);
        }
    }

    public void test_MulticastSocket() {
        this.th.checkPoint("MulticastSocket()");
        MulticastSocket ms = null;
        try {
            ms = new MulticastSocket();
            this.th.check(ms.getLocalPort() >= 1024, "port should not be in the reserved area below 1024, got " + ms.getLocalPort());
            this.th.check(ms.getLocalAddress(), InetAddress.getByName("0.0.0.0"), "cheking local address");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ms);
        this.th.checkPoint("MulticastSocket(int)");
        this.checkConstructFails(-1, 1);
        this.checkConstructFails(65536, 2);
        try {
            ms = new MulticastSocket(33333);
            this.th.check(ms.getLocalPort(), 33333, "checking port number");
            this.th.check(ms.getLocalAddress(), InetAddress.getByName("0.0.0.0"), "cheking local address");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ms);
    }

    private void checkSendReceive(MulticastSocket ms, DatagramPacket dp, String msg, int count, boolean bad) {
        DatagramPacket recv = new DatagramPacket(new byte[256], 256);
        try {
            ms.send(dp);
            ms.receive(recv);
            this.th.check(recv.getLength(), msg.length(), "checking length -- " + count);
            this.th.check(new String(recv.getData(), 0, recv.getLength()), msg, "checking bytes -- " + count);
            this.th.check(ms.getLocalPort(), recv.getPort(), "checking port -- " + count);
        }
        catch (Exception e) {
            this.th.check(bad, "SendReceive " + count + " failed due to " + e);
        }
    }

    public void test_joinGroup() {
        this.th.checkPoint("joinGroup(java.net.InetAddress)void");
        MulticastSocket ms = null;
        int port = 33334;
        try {
            ms = new MulticastSocket(port);
            InetAddress multi = InetAddress.getByName("225.0.0.1");
            InetAddress multi2 = InetAddress.getByName("239.0.0.1");
            String mc = "Send to ";
            String mc2 = mc + multi2;
            mc = mc + multi;
            DatagramPacket mcdp = new DatagramPacket(mc.getBytes(), mc.length(), multi, port);
            DatagramPacket mc2dp = new DatagramPacket(mc2.getBytes(), mc2.length(), multi2, port);
            ms.joinGroup(multi);
            ms.setSoTimeout(1000);
            this.checkSendReceive(ms, mcdp, mc, 1, false);
            ms.joinGroup(multi2);
            ms.setSoTimeout(500);
            this.checkSendReceive(ms, mc2dp, mc2, 2, false);
            this.checkSendReceive(ms, mcdp, mc, 3, false);
            ms.setSoTimeout(50);
            mcdp.setPort(1 + port);
            this.checkSendReceive(ms, mcdp, mc, 4, true);
            ms.leaveGroup(multi);
            mcdp.setPort(port);
            this.checkSendReceive(ms, mcdp, mc, 5, true);
            try {
                ms.joinGroup(null);
                this.th.fail("should throw a NullPointerException");
            }
            catch (NullPointerException np) {
                this.th.check(true);
            }
            try {
                ms.joinGroup(InetAddress.getByName("223.255.255.255"));
                this.th.fail("should throw an Exception");
            }
            catch (SocketException np) {
                this.th.check(true);
            }
            try {
                ms.joinGroup(InetAddress.getByName("240.0.0.0"));
                this.th.fail("should throw an Exception");
            }
            catch (SocketException np) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ms);
    }

    public void test_leaveGroup() {
        this.th.checkPoint("leaveGroup(java.net.InetAddress)void");
        MulticastSocket ms = null;
        int port = 33336;
        try {
            ms = new MulticastSocket(port);
            try {
                ms.leaveGroup(null);
                this.th.fail("should throw a NullPointerException");
            }
            catch (NullPointerException np) {
                this.th.check(true);
            }
            try {
                ms.leaveGroup(InetAddress.getByName("223.255.255.255"));
                this.th.fail("should throw an Exception");
            }
            catch (SocketException np) {
                this.th.check(true);
            }
            try {
                ms.leaveGroup(InetAddress.getByName("240.0.0.0"));
                this.th.fail("should throw an Exception");
            }
            catch (SocketException np) {
                this.th.check(true);
            }
            try {
                ms.leaveGroup(InetAddress.getByName("234.0.0.0"));
                this.th.fail("should throw an Exception");
            }
            catch (SocketException np) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ms);
    }

    private void checkSendReceive(MulticastSocket ms, DatagramPacket dp, String msg, int count, boolean bad, byte TTL) {
        DatagramPacket recv = new DatagramPacket(new byte[256], 256);
        try {
            ms.send(dp, TTL);
            ms.receive(recv);
            this.th.check(recv.getLength(), msg.length(), "checking length -- " + count);
            this.th.check(new String(recv.getData(), 0, recv.getLength()), msg, "checking bytes -- " + count);
        }
        catch (Exception e) {
            this.th.check(bad, "SendReceive " + count + " failed due to " + e);
        }
    }

    public void test_send() {
        this.th.checkPoint("send(java.net.DatagramPacket,byte)void");
        MulticastSocket ms = null;
        int port = 33335;
        try {
            ms = new MulticastSocket(port);
            InetAddress multi = InetAddress.getByName("225.0.0.1");
            InetAddress local = ms.getLocalAddress();
            String mc = "Send to ";
            String lc = mc + local;
            mc = mc + multi;
            DatagramPacket mcdp = new DatagramPacket(mc.getBytes(), mc.length(), multi, port);
            DatagramPacket lcdp = new DatagramPacket(lc.getBytes(), lc.length(), local, port);
            ms.setSoTimeout(1000);
            ms.setTimeToLive(2);
            ms.joinGroup(multi);
            this.checkSendReceive(ms, lcdp, lc, 1, false, (byte)3);
            this.th.check(ms.getTimeToLive(), 2, "checking ttl -- 1");
            this.checkSendReceive(ms, mcdp, mc, 1, false, (byte)1);
            this.th.check(ms.getTimeToLive(), 2, "checking ttl -- 2");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ms);
    }

    public void test_TimeToLive() {
        this.th.checkPoint("getTimeToLive()int");
        MulticastSocket ms = null;
        try {
            ms = new MulticastSocket();
            this.th.check(ms.getTimeToLive(), 1, "check default value");
            this.th.checkPoint("setTimeToLive(int)void");
            ms.setTimeToLive(10);
            this.th.check(ms.getTimeToLive(), 10, "check  value -- 1");
            ms.setTimeToLive(255);
            this.th.check(ms.getTimeToLive(), 255, "check value -- 2");
            ms.setTimeToLive(1);
            this.th.check(ms.getTimeToLive(), 1, "check value -- 3");
            ms.setTTL((byte)-1);
            this.th.check(ms.getTimeToLive(), 255, "check value -- 4");
            this.th.check(ms.getTTL(), -1, "check value -- 5");
            ms.setTTL((byte)1);
            this.th.check(ms.getTimeToLive(), 1, "check value -- 6");
            this.th.check(ms.getTTL(), 1, "check value -- 7");
            try {
                ms.setTimeToLive(-1);
                this.th.fail("illegal argument passed -- 1");
            }
            catch (IllegalArgumentException iae) {
                this.th.check(true);
            }
            try {
                ms.setTimeToLive(256);
                this.th.fail("illegal argument passed -- 2");
            }
            catch (IllegalArgumentException iae) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception " + e);
        }
        this.close(ms);
    }

    public void test_getInterface() {
    }

    public void test_setInterface() {
    }

    public void test_behaviour() {
    }
}

