/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.DatagramSocket;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class AcuniaDatagramSocketTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.net.DatagramSocket");
        this.test_DatagramSocket();
        this.test_close();
        this.test_receive();
        this.test_send();
        this.test_connect();
        this.test_disconnect();
        this.test_getInetAddress();
        this.test_getPort();
        this.test_getLocalPort();
        this.test_getLocalAddress();
        this.test_behaviour();
    }

    private final void close(DatagramSocket ds) {
        if (ds != null) {
            ds.close();
        }
    }

    private final void checkConstructFails(int port, InetAddress addr, int count) {
        try {
            new DatagramSocket(port, addr);
            this.th.fail("constructor must fail -- " + count);
        }
        catch (IOException ioe) {
            this.th.fail("caught wrong Exception -- " + count + " --> " + ioe);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "constructor failed with correct exception " + count);
        }
    }

    private final void checkConstructFails(int port, int count) {
        try {
            new DatagramSocket(port);
            this.th.fail("constructor must fail -- " + count);
        }
        catch (IOException ioe) {
            this.th.fail("caught wrong Exception -- " + count + " --> " + ioe);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "constructor failed with correct exception " + count);
        }
    }

    public void test_DatagramSocket() {
        this.th.checkPoint("DatagramSocket()");
        DatagramSocket ds = null;
        try {
            ds = new DatagramSocket();
            boolean bl = false;
            if (ds.getLocalPort() >= 1024) {
                bl = true;
            }
            this.th.check(bl, "port should not be in the reserved area below 1024, got " + ds.getLocalPort());
            this.th.check(ds.getLocalAddress(), InetAddress.getByName("0.0.0.0"), "cheking local address");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
        this.th.checkPoint("DatagramSocket(int)");
        this.checkConstructFails(-1, 1);
        this.checkConstructFails(65536, 2);
        try {
            ds = new DatagramSocket(11345);
            this.th.check(ds.getLocalPort(), 11345, "test value -- 1");
            this.th.check(ds.getLocalAddress(), InetAddress.getByName("0.0.0.0"), "cheking local address");
            try {
                new DatagramSocket(11345);
                this.th.fail("should throw exception -- port already in use");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
        this.th.checkPoint("DatagramSocket(int,java.net.InetAddress)");
        try {
            InetAddress laddr = InetAddress.getLocalHost();
            this.checkConstructFails(-1, laddr, 1);
            this.checkConstructFails(65536, laddr, 2);
            ds = new DatagramSocket(11346, laddr);
            this.th.check(ds.getLocalPort(), 11346, "test value -- 1");
            try {
                new DatagramSocket(11346, laddr);
                this.th.fail("should throw exception -- port already in use");
            }
            catch (SocketException se) {
                this.th.check(true);
            }
            this.th.check(ds.getLocalAddress(), laddr, "test value -- 1");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        try {
            DatagramSocket ds = new DatagramSocket();
            ds.close();
            ds.close();
            ds.close();
            this.th.debug("local address = " + ds.getLocalAddress());
            InetAddress laddr = InetAddress.getLocalHost();
            ds.connect(laddr, 12345);
            this.th.check(ds.getPort(), 12345);
            this.th.check(ds.getInetAddress(), laddr);
            ds.disconnect();
            DatagramPacket p = new DatagramPacket(new byte[10], 10);
            try {
                ds.send(p);
                this.th.fail("exception not thrown -- 1");
            }
            catch (Exception so) {
                this.th.check(true);
            }
            try {
                ds.receive(p);
                this.th.fail("exception not thrown -- 2");
            }
            catch (Exception so) {
                this.th.check(true);
            }
            try {
                ds.getSendBufferSize();
                this.th.fail("exception not thrown -- 3");
            }
            catch (Exception so) {
                this.th.check(true);
            }
            try {
                ds.getReceiveBufferSize();
                this.th.fail("exception not thrown -- 4");
            }
            catch (Exception so) {
                this.th.check(true);
            }
            try {
                ds.getSoTimeout();
                this.th.fail("exception not thrown -- 5");
            }
            catch (Exception so) {
                this.th.check(true);
            }
            try {
                ds.setSoTimeout(4);
                this.th.fail("exception not thrown -- 6");
            }
            catch (Exception so) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
    }

    public void test_receive() {
        this.th.checkPoint("receive(java.net.DatagramPacket)void");
        DatagramSocket ds = null;
        try {
            DatagramPacket p;
            InetAddress laddr = InetAddress.getLocalHost();
            DatagramPacket recvp = new DatagramPacket(new byte[128], 20, 20);
            String s = "01234MESSAGE: HELLOWORLD! HOW ARE YOU ALL TODAY ! END12345";
            DatagramPacket sendp = new DatagramPacket(s.getBytes(), 5, s.length() - 10, laddr, 11234);
            ds = new DatagramSocket(11234, laddr);
            ds.send(sendp);
            ds.receive(recvp);
            this.th.check(new String(recvp.getData(), recvp.getOffset(), recvp.getLength()), "MESSAGE: HELLOWORLD!", "checking data -- 1");
            this.th.check(recvp.getData()[19], 0, "nothing written before offset");
            this.th.check(recvp.getAddress(), laddr);
            this.th.check(recvp.getPort(), 11234);
            ds.connect(laddr, 11234);
            try {
                p = new DatagramPacket(s.getBytes(), 0, s.length(), laddr, 11233);
                ds.send(p);
                this.th.fail("socket is connected -- 1");
            }
            catch (IllegalArgumentException se) {
                this.th.check(true);
            }
            try {
                p = new DatagramPacket(s.getBytes(), 0, s.length(), InetAddress.getByName("0.0.0.0"), 11234);
                ds.send(p);
                this.th.fail("socket is connected -- 2");
            }
            catch (IllegalArgumentException se) {
                this.th.check(true);
            }
            DatagramSocket ds1 = new DatagramSocket(11233, laddr);
            DatagramPacket p2 = new DatagramPacket(s.getBytes(), 0, s.length(), laddr, 11234);
            recvp = new DatagramPacket(new byte[128], 128);
            ds1.send(p2);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ds.send(p2);
            ds.receive(recvp);
            this.th.check(new String(recvp.getData(), recvp.getOffset(), recvp.getLength()), s, "checking data -- 2");
            this.th.check(recvp.getAddress(), laddr);
            this.th.check(recvp.getPort(), 11234);
            this.th.check(recvp.getLength(), s.length());
            try {
                this.th.debug("DEBUGGING - receiving 'null'");
                ds.receive(null);
                this.th.fail("should throw an Exception");
            }
            catch (NullPointerException np) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
    }

    public void test_send() {
        this.th.checkPoint("send(java.net.DatagramPacket)void");
        DatagramSocket ds = null;
        try {
            ds = new DatagramSocket();
            try {
                ds.send(null);
                this.th.fail("should throw an Exception");
            }
            catch (NullPointerException np) {
                this.th.check(true);
            }
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
    }

    public void test_connect() {
        this.th.checkPoint("connect(java.net.InetAddress,int)void");
        DatagramSocket ds = null;
        try {
            ds = new DatagramSocket();
            InetAddress laddr = InetAddress.getLocalHost();
            this.th.check(ds.getInetAddress(), null, "check value -- 1");
            ds.connect(laddr, 12345);
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
    }

    public void test_disconnect() {
        this.th.checkPoint("()");
    }

    public void test_getInetAddress() {
        this.th.checkPoint("getInetAddress()java.net.InetAddress");
        DatagramSocket ds = null;
        try {
            ds = new DatagramSocket();
            InetAddress laddr = InetAddress.getLocalHost();
            this.th.check(ds.getInetAddress(), null, "check value -- 1");
            ds.connect(laddr, 12345);
            this.th.check(ds.getInetAddress(), laddr, "check value -- 2");
            ds.disconnect();
            this.th.check(ds.getInetAddress(), null, "check value -- 3");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
    }

    public void test_getPort() {
        this.th.checkPoint("getPort()int");
        DatagramSocket ds = null;
        try {
            ds = new DatagramSocket();
            InetAddress laddr = InetAddress.getLocalHost();
            this.th.check(ds.getPort(), -1, "check value -- 1");
            ds.connect(laddr, 12345);
            this.th.check(ds.getPort(), 12345, "check value -- 2");
            ds.disconnect();
            this.th.check(ds.getPort(), -1, "check value -- 3");
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
    }

    public void test_getLocalAddress() {
        this.th.checkPoint("()");
    }

    public void test_getLocalPort() {
        this.th.checkPoint("()");
    }

    public void test_behaviour() {
        this.th.checkPoint("send/receive");
        this.th.debug("testing send/receive");
        DatagramSocket ds = null;
        try {
            int port = 11345;
            InetAddress laddr = InetAddress.getLocalHost();
            InetAddress loopb = InetAddress.getByName("127.0.0.1");
            InetAddress zeros = InetAddress.getByName("0.0.0.0");
            InetAddress multi = InetAddress.getByName("225.0.0.1");
            String la = "Send to ";
            String lb = la + loopb;
            String zr = la + zeros;
            String mc = la + multi;
            la = la + laddr;
            this.th.debug(laddr + ", " + loopb + ", " + zeros);
            DatagramPacket ladp = new DatagramPacket(la.getBytes(), la.length(), laddr, port);
            DatagramPacket lbdp = new DatagramPacket(lb.getBytes(), lb.length(), loopb, port);
            DatagramPacket zrdp = new DatagramPacket(zr.getBytes(), zr.length(), zeros, port);
            if (laddr.equals(loopb)) {
                this.th.debug("getLocalHost returned the loopback address !");
            }
            ds = new DatagramSocket(port++, zeros);
            ds.setSoTimeout(1000);
            this.checkSendReceive(ds, ladp, la, 1, false);
            this.checkSendReceive(ds, lbdp, lb, 2, false);
            this.checkSendReceive(ds, zrdp, zr, 3, false);
            this.close(ds);
            this.setPorts(ladp, lbdp, zrdp, port);
            ds = new DatagramSocket(port++, laddr);
            ds.setSoTimeout(1000);
            this.checkSendReceive(ds, ladp, la, 4, false);
            this.checkSendReceive(ds, lbdp, lb, 5, true);
            this.checkSendReceive(ds, zrdp, zr, 6, false);
            this.close(ds);
            this.setPorts(ladp, lbdp, zrdp, port);
            ds = new DatagramSocket(port, loopb);
            ds.setSoTimeout(1000);
            this.checkSendReceive(ds, ladp, la, 7, true);
            this.checkSendReceive(ds, lbdp, lb, 8, false);
            this.checkSendReceive(ds, zrdp, zr, 9, false);
            ds.setSoTimeout(10);
            try {
                ds.receive(new DatagramPacket(new byte[1], 1));
                this.th.fail("should have thrown an InterruptedIOException");
            }
            catch (InterruptedIOException iioe) {
                this.th.check(true);
            }
            catch (IOException ioe) {
                this.th.fail("threw wrong exception " + ioe);
            }
            ds.close();
            DatagramPacket mcdp = new DatagramPacket(mc.getBytes(), mc.length(), zeros, port);
            ds = new DatagramSocket(port, multi);
            ds.setSoTimeout(50);
            this.checkSendReceive(ds, mcdp, mc, 10, true);
            this.checkSendReceive(ds, zrdp, zr, 11, true);
        }
        catch (Exception e) {
            this.th.fail("unwanted exception caught :" + e);
        }
        this.close(ds);
    }

    private final void checkSendReceive(DatagramSocket ds, DatagramPacket dp, String msg, int count, boolean bad) {
        DatagramPacket recv = new DatagramPacket(new byte[256], 256);
        try {
            ds.send(dp);
            ds.receive(recv);
            this.th.check(recv.getLength(), msg.length(), "checking length -- " + count);
            this.th.check(new String(recv.getData(), 0, recv.getLength()), msg, "checking bytes -- " + count);
            this.th.check(recv.getPort(), ds.getLocalPort(), "checking local port " + count);
        }
        catch (Exception e) {
            this.th.check(bad, "SendReceive " + count + " failed due to " + e);
        }
    }

    private final void setPorts(DatagramPacket dp1, DatagramPacket dp2, DatagramPacket dp3, int port) {
        dp1.setPort(port);
        dp2.setPort(port);
        dp3.setPort(port);
    }
}

