/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.ref.SoftReference;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.lang.ref.Reference.Garbage;
import gnu.testlet.wonka.lang.ref.Reference.GarbageListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashSet;

public class AcuniaSoftReferenceTest
implements Testlet,
GarbageListener {
    protected TestHarness th;
    private Runtime rt = Runtime.getRuntime();
    private SoftReference sr;
    private boolean got1;
    private boolean got2;
    private boolean done;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.ref.SoftReference");
        this.test_SoftReference();
        this.test_get();
        this.test_clear();
        this.test_enqueue();
        this.test_isEnqueued();
        this.test_behaviour();
    }

    public void test_SoftReference() {
        this.th.checkPoint("SoftReference(java.lang.Object)");
        ReferenceQueue rq = new ReferenceQueue();
        try {
            new SoftReference<Object>(null, rq);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 1");
        }
        this.th.checkPoint("SoftReference(java.lang.Object,java.lang.ref.ReferenceQueue)");
        try {
            new SoftReference<Object>(null, rq);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 1");
        }
        try {
            new SoftReference<Object>(new Object(), null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException np) {
            this.th.check(true, "correct exception was thrown -- 2");
        }
    }

    public void test_get() {
        this.th.checkPoint("get()java.lang.Object");
        String msg = "check return value ";
        this.sr = new SoftReference<String>(msg, new ReferenceQueue());
        this.th.check(this.sr.get(), msg, msg + 1);
        this.sr.clear();
        this.th.check(this.sr.get(), null, msg + 2);
        ReferenceQueue rq = new ReferenceQueue();
        this.sr = new SoftReference<String>(msg, rq);
        this.sr.enqueue();
        rq.poll();
        this.th.check(this.sr.get(), msg, msg + 3);
    }

    public void test_clear() {
        int i;
        this.th.checkPoint("clear()void");
        ReferenceQueue rq = new ReferenceQueue();
        HashSet hs = new HashSet(1000);
        for (i = 0; i < 3; ++i) {
            this.makeSoft(hs, rq, 1000000);
        }
        this.th.check(rq.poll(), null, "no references should be collected");
        for (i = 0; i < 250; ++i) {
            this.makeSoft(hs, rq, 1000000);
        }
        Reference ref = rq.poll();
        this.th.check(ref != null, "some of the objects should be collected");
        hs.remove(ref);
        int count = 0;
        while (ref != null) {
            ++count;
            hs.remove(ref);
            if (ref.get() != null) {
                this.th.fail("value was not cleared ...");
            }
            ref = rq.poll();
        }
        this.th.check(count > 100, "there should be at least be 100 reference collected (got " + count + ")");
    }

    public void test_enqueue() {
        this.th.checkPoint("enqueue()boolean");
        String msg = "checking return value -- ";
        int i = 1;
        ReferenceQueue rq = new ReferenceQueue();
        this.sr = new SoftReference<String>(msg, rq);
        this.th.check(this.sr.enqueue(), msg + i++);
        this.th.check(!this.sr.enqueue(), msg + i++);
        Reference ref = rq.poll();
        this.th.check(ref, this.sr, "reference was put into the queue");
        if (ref != null) {
            this.th.check(ref.get(), msg, "Object was not collected yet");
        }
        this.th.check(!this.sr.enqueue(), msg + i++);
        this.sr.clear();
        msg = "special case -- ";
        i = 1;
        this.sr = new SoftReference<String>(msg, rq);
        this.sr.clear();
        this.th.check(!this.sr.isEnqueued(), msg + i++);
        this.th.check(this.sr.enqueue(), msg + i++);
        this.th.check(!this.sr.enqueue(), msg + i++);
        this.th.check(rq.poll(), this.sr, "reference was put into the queue");
        this.th.check(!this.sr.enqueue(), msg + i++);
        msg = "not registred to a queue -- ";
        i = 1;
        this.sr = new SoftReference<String>(msg);
        this.th.check(!this.sr.isEnqueued(), msg + i++);
        this.th.check(!this.sr.enqueue(), msg + i++);
        this.th.check(!this.sr.isEnqueued(), msg + i++);
    }

    public void test_isEnqueued() {
        this.th.checkPoint("isEnqueued()boolean");
        String msg = "checking return value -- ";
        int i = 1;
        ReferenceQueue rq = new ReferenceQueue();
        this.sr = new SoftReference<String>(msg, rq);
        this.th.check(!this.sr.isEnqueued(), msg + i++);
        this.th.check(this.sr.enqueue(), msg + i++);
        this.th.check(this.sr.isEnqueued(), msg + i++);
        this.th.check(rq.poll(), this.sr, "reference was put into the queue");
        this.th.check(!this.sr.isEnqueued(), msg + i++);
        this.sr.clear();
    }

    public void test_behaviour() {
        this.th.checkPoint("SoftReference(java.lang.Object,java.lang.ref.ReferenceQueue)");
        ReferenceQueue rq = new ReferenceQueue();
        Garbage gb = new Garbage(this, null, 1);
        gb = new Garbage(this, gb, 2);
        this.sr = new SoftReference<Garbage>(gb, rq);
        gb = null;
        Garbage gb3 = new Garbage(this, null, 3);
        this.sr = new SoftReference<Garbage>(gb3, rq);
        while (!this.got1 && !this.got2) {
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {}
        }
        this.th.check(rq.poll(), null, "SoftReference got collected --> nothing put in the queue");
        gb = new Garbage(this, null, 4);
        this.got2 = false;
        new SoftReference<Garbage>(new Garbage(this, gb, 2), rq);
        while (!this.got2) {
            System.gc();
            System.runFinalization();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {}
        }
        this.done = true;
        this.sr = null;
    }

    public void reportFinalize(int id) {
        if (id == 2 && !this.got2) {
            this.got2 = true;
            this.th.check(true, "collecting Garbage object 2");
        } else if (id == 1 && !this.got1) {
            this.got1 = true;
            this.th.check(true, "collecting Garbage object 1");
        } else if (!this.done) {
            this.th.fail("collected wrong object (id = " + id + ")");
        }
    }

    private void makeSoft(HashSet hs, ReferenceQueue rq, int size) {
        hs.add(new SoftReference<int[]>(new int[size], rq));
        long mem = this.rt.totalMemory() - this.rt.freeMemory();
    }
}

