/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Thread;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class AcuniaThreadTest
implements Testlet,
Runnable {
    protected static final int SLEEPY = 0;
    protected static final int NOOP = 1;
    protected static final int POL1 = 2;
    protected static final int POL2 = 3;
    protected static final int ALIVE = 4;
    protected static final int PRESLP = 5;
    private boolean interrupted;
    private int time;
    protected TestHarness th;

    protected void setInterruptRcv() {
        this.interrupted = true;
    }

    protected boolean getInterruptRcv() {
        return this.interrupted;
    }

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.Thread");
        this.test_interrupt();
        this.test_join();
        this.test_isAlive();
        this.test_start();
    }

    public void run() {
        if (this.time > 0) {
            Thread t = new Thread((Runnable)new AcuniaThreadTest(-1, this.th), "SLEEPER");
            t.start();
            try {
                Thread.sleep(this.time);
                t.interrupt();
                t.join();
                this.th.check(true, "thread.join succeeded");
            }
            catch (InterruptedException ie) {
                this.th.fail("Thread shouldn't have been interrupted");
            }
        } else {
            try {
                Thread.sleep(5000L);
                this.th.fail("Thread should have been interrupted");
            }
            catch (InterruptedException ie) {
                this.th.check(true, "thread was correctly interrupted");
            }
        }
    }

    public void test_interrupt() {
        this.th.checkPoint("interrupt()void");
        Thread t = new Thread((Runnable)new Runner(0, this), "Sleepy");
        this.interrupted = false;
        t.interrupt();
        t.start();
        Thread.yield();
        t.interrupt();
        while (!this.interrupted) {
            Thread.yield();
        }
        t = new Thread((Runnable)new Runner(2, this), "Pol1");
        this.interrupted = false;
        t.start();
        Thread.yield();
        t.interrupt();
        while (!this.interrupted) {
            Thread.yield();
        }
        t = new Thread((Runnable)new Runner(3, this), "Pol2");
        this.interrupted = false;
        t.start();
        Thread.yield();
        t.interrupt();
        while (!this.interrupted) {
            Thread.yield();
        }
        t = new Thread((Runnable)new Runner(5, this), "Pre-sleep");
        this.interrupted = false;
        t.start();
        while (!this.interrupted) {
            Thread.yield();
        }
        t.interrupt();
        this.interrupted = false;
        while (!this.interrupted) {
            Thread.yield();
        }
    }

    public void test_join() {
        long time;
        this.th.checkPoint("join()void");
        Thread t = new Thread((Runnable)new Runner(1, this), "No-op");
        this.interrupted = false;
        this.th.debug("joining thread which is not started");
        try {
            time = System.currentTimeMillis();
            t.join(3000L);
            boolean bl = false;
            if (System.currentTimeMillis() - time < 400L) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception");
            e.printStackTrace();
        }
        t.start();
        try {
            t.join(3000L);
            time = System.currentTimeMillis();
            t.join(3000L);
            boolean bl = false;
            if (System.currentTimeMillis() - time < 400L) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t = new Thread((Runnable)new AcuniaThreadTest(500, this.th), "KILLER");
        t.start();
        long stime = System.currentTimeMillis();
        try {
            t.join(5000L);
            boolean bl = false;
            if (System.currentTimeMillis() - stime < 4000L) {
                bl = true;
            }
            this.th.check(bl, "checking join");
        }
        catch (InterruptedException ie) {
            this.th.fail("no InterruptedException expected");
        }
    }

    public void test_isAlive() {
        this.th.checkPoint("isAlive()boolean");
        Thread t = new Thread((Runnable)new Runner(4, this), "Lively");
        this.th.check(t.isAlive() ^ true, "thread is not started");
        this.interrupted = false;
        t.start();
        this.th.check(t.isAlive(), "thread is started -- 1");
        Thread.yield();
        while (!this.interrupted) {
            Thread.yield();
        }
        this.th.check(t.isAlive(), "thread is started -- 2");
        t.interrupt();
        try {
            t.join(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.th.check(t.isAlive() ^ true, "thread has died");
    }

    public void test_start() {
        this.th.checkPoint("start()void");
        Thread t = new Thread((Runnable)new Runner(4, this), "Lively");
        t.start();
        this.interrupted = false;
        while (!this.interrupted) {
            Thread.yield();
        }
        try {
            t.start();
            this.th.fail("should throw an IllegalThreadStateException");
        }
        catch (IllegalThreadStateException bad) {
            this.th.check(true);
        }
        t.interrupt();
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            t.start();
            this.th.check(true);
        }
        catch (IllegalThreadStateException bad) {
            this.th.fail("should not throw an IllegalThreadStateException");
        }
    }

    public AcuniaThreadTest() {
    }

    private AcuniaThreadTest(int time, TestHarness th) {
        this.time = time;
        this.th = th;
    }

    public static class Runner
    implements Runnable {
        private AcuniaThreadTest att;
        private int mode;
        private Thread thd;

        public void run() {
            this.att.th.debug("running in mode " + this.mode);
            switch (this.mode) {
                case 0: {
                    this.att.th.debug("running thread in sleepy mode");
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException ie) {
                        this.att.th.check(Thread.currentThread().isInterrupted() ^ true);
                        this.att.th.check(Thread.interrupted() ^ true);
                        this.att.setInterruptRcv();
                    }
                    this.att.th.debug("ran thread in sleepy mode");
                    break;
                }
                case 2: {
                    while (!Thread.interrupted()) {
                        Thread.yield();
                    }
                    this.att.th.check(Thread.currentThread().isInterrupted() ^ true);
                    this.att.th.check(Thread.interrupted() ^ true);
                    this.att.setInterruptRcv();
                    break;
                }
                case 3: {
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.yield();
                    }
                    this.att.th.check(Thread.currentThread().isInterrupted());
                    this.att.th.check(Thread.interrupted());
                    this.att.setInterruptRcv();
                    break;
                }
                case 4: {
                    this.att.setInterruptRcv();
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException ie) {}
                    break;
                }
                case 5: {
                    this.att.setInterruptRcv();
                    while (this.att.getInterruptRcv()) {
                        Thread.yield();
                    }
                    long time = System.currentTimeMillis();
                    try {
                        Thread.sleep(6000L);
                        this.att.th.fail("should be interrupted");
                        this.att.setInterruptRcv();
                    }
                    catch (InterruptedException ie) {
                        TestHarness testHarness = this.att.th;
                        boolean bl = false;
                        if (System.currentTimeMillis() - time < 1000L) {
                            bl = true;
                        }
                        testHarness.check(bl, "took too long");
                        this.att.setInterruptRcv();
                    }
                    break;
                }
            }
        }

        public Runner(int m, AcuniaThreadTest t) {
            this.mode = m;
            this.att = t;
        }

        public Runner(int m, AcuniaThreadTest t, Thread th) {
            this.mode = m;
            this.att = t;
            this.thd = th;
        }
    }
}

