/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Number;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class PrimitiveTest
implements Testlet {
    private static final int BIGGER = 1;
    private static final int EQUALS = 0;
    private static final int SMALLER = -1;
    private static final int UNDEFINED = -2;
    protected static TestHarness harness;

    public void testBasicOps() {
        harness.checkPoint("+|- byte");
        int b = 55;
        boolean bl = false;
        if (34 + b == 89) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (34 - b == -21) {
            bl2 = true;
        }
        harness.check(bl2);
        harness.checkPoint("+|- short");
        int s = 4455;
        boolean bl3 = false;
        if (34 + s == 4489) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (4434 - s == -21) {
            bl4 = true;
        }
        harness.check(bl4, "got: " + (4434 - s));
        harness.checkPoint("+|- int");
        int i = 4455;
        boolean bl5 = false;
        if (34 + i == 4489) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if (Integer.MAX_VALUE + i == -2147479194) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (4434 - i == -21) {
            bl7 = true;
        }
        harness.check(bl7);
        harness.checkPoint("+|- long");
        long l = 4455L;
        boolean bl8 = false;
        if (34L + l == 4489L) {
            bl8 = true;
        }
        harness.check(bl8);
        boolean bl9 = false;
        if (Long.MAX_VALUE + l == -9223372036854771354L) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if (4434L - l == -21L) {
            bl10 = true;
        }
        harness.check(bl10);
        harness.checkPoint("+|- float");
        float f = Float.NaN;
        harness.check(Float.isNaN(f + 545.787f));
        harness.check(Float.isNaN(545.787f - f));
        f = Float.NEGATIVE_INFINITY;
        harness.check(Float.isNaN(Float.POSITIVE_INFINITY + f));
        harness.check(Float.isNaN(Float.NEGATIVE_INFINITY - f));
        harness.check(Float.isNaN(Float.POSITIVE_INFINITY - f) ^ true);
        harness.check(Float.isNaN(f - Float.POSITIVE_INFINITY) ^ true);
        boolean bl11 = false;
        if (Float.POSITIVE_INFINITY - f == Float.POSITIVE_INFINITY) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (f - Float.POSITIVE_INFINITY == f) {
            bl12 = true;
        }
        harness.check(bl12);
        boolean bl13 = false;
        if (f - 4.083E25f == f) {
            bl13 = true;
        }
        harness.check(bl13);
        boolean bl14 = false;
        if (f + 5.877E25f == f) {
            bl14 = true;
        }
        harness.check(bl14, "got: " + (f + 5.877E25f));
        f = Float.POSITIVE_INFINITY;
        boolean bl15 = false;
        if (f - 4.083E25f == f) {
            bl15 = true;
        }
        harness.check(bl15, "got: " + (f - 4.083E25f));
        boolean bl16 = false;
        if (f + 5.877E25f == f) {
            bl16 = true;
        }
        harness.check(bl16);
        f = 0.0f;
        boolean bl17 = false;
        if (f == f) {
            bl17 = true;
        }
        harness.check(bl17);
        boolean bl18 = false;
        if (f + 0.0f == f) {
            bl18 = true;
        }
        harness.check(bl18);
        boolean bl19 = false;
        if (-f == -0.0f) {
            bl19 = true;
        }
        harness.check(bl19);
        boolean bl20 = false;
        if (f - 4.083E25f == -4.083E25f) {
            bl20 = true;
        }
        harness.check(bl20);
        boolean bl21 = false;
        if (f + 5.877E25f == 5.877E25f) {
            bl21 = true;
        }
        harness.check(bl21);
        f = -0.0f;
        boolean bl22 = false;
        if (f - 4.083E25f == -4.083E25f) {
            bl22 = true;
        }
        harness.check(bl22);
        boolean bl23 = false;
        if (f + 5.877E25f == 5.877E25f) {
            bl23 = true;
        }
        harness.check(bl23);
        f = 23454.0f;
        boolean bl24 = false;
        if (f - f == 0.0f) {
            bl24 = true;
        }
        harness.check(bl24);
        boolean bl25 = false;
        if (f - 454.0f == 23000.0f) {
            bl25 = true;
        }
        harness.check(bl25);
        boolean bl26 = false;
        if (f + 444.0f == 23898.0f) {
            bl26 = true;
        }
        harness.check(bl26);
        f = Float.MAX_VALUE;
        boolean bl27 = false;
        if (f + 4.44E36f == Float.POSITIVE_INFINITY) {
            bl27 = true;
        }
        harness.check(bl27, "got: " + (f + 444.0f));
        boolean bl28 = false;
        if (-4.44E36f - f == Float.NEGATIVE_INFINITY) {
            bl28 = true;
        }
        harness.check(bl28, "got: " + (-444.0f - f));
        harness.checkPoint("+|- double");
        double d = Double.NaN;
        harness.check(Double.isNaN(d + 545.787));
        harness.check(Double.isNaN(545.787 - d));
        d = Double.NEGATIVE_INFINITY;
        harness.check(Double.isNaN(Double.POSITIVE_INFINITY + d));
        harness.check(Double.isNaN(Double.NEGATIVE_INFINITY - d));
        harness.check(Double.isNaN(Double.POSITIVE_INFINITY - d) ^ true);
        harness.check(Double.isNaN(d - Double.POSITIVE_INFINITY) ^ true);
        boolean bl29 = false;
        if (Double.POSITIVE_INFINITY - d == Double.POSITIVE_INFINITY) {
            bl29 = true;
        }
        harness.check(bl29);
        boolean bl30 = false;
        if (d - Double.POSITIVE_INFINITY == d) {
            bl30 = true;
        }
        harness.check(bl30);
        boolean bl31 = false;
        if (d - 4.083E56 == d) {
            bl31 = true;
        }
        harness.check(bl31);
        boolean bl32 = false;
        if (d + 5.877E56 == d) {
            bl32 = true;
        }
        harness.check(bl32);
        d = Double.POSITIVE_INFINITY;
        boolean bl33 = false;
        if (d - 4.083E56 == d) {
            bl33 = true;
        }
        harness.check(bl33);
        boolean bl34 = false;
        if (d + 5.877E56 == d) {
            bl34 = true;
        }
        harness.check(bl34);
        d = 0.0;
        boolean bl35 = false;
        if (d == d) {
            bl35 = true;
        }
        harness.check(bl35);
        boolean bl36 = false;
        if (d + 0.0 == d) {
            bl36 = true;
        }
        harness.check(bl36);
        boolean bl37 = false;
        if (-d == -0.0) {
            bl37 = true;
        }
        harness.check(bl37);
        boolean bl38 = false;
        if (d - 4.083E56 == -4.083E56) {
            bl38 = true;
        }
        harness.check(bl38);
        boolean bl39 = false;
        if (d + 5.877E56 == 5.877E56) {
            bl39 = true;
        }
        harness.check(bl39);
        d = -0.0;
        boolean bl40 = false;
        if (d - 4.083E56 == -4.083E56) {
            bl40 = true;
        }
        harness.check(bl40);
        boolean bl41 = false;
        if (d + 5.877E56 == 5.877E56) {
            bl41 = true;
        }
        harness.check(bl41);
        d = 23454.0;
        boolean bl42 = false;
        if (d - d == 0.0) {
            bl42 = true;
        }
        harness.check(bl42);
        boolean bl43 = false;
        if (d - 454.0 == 23000.0) {
            bl43 = true;
        }
        harness.check(bl43);
        boolean bl44 = false;
        if (d + 444.0 == 23898.0) {
            bl44 = true;
        }
        harness.check(bl44);
        d = Double.MAX_VALUE;
        boolean bl45 = false;
        if (d + 4.44E302 == Double.POSITIVE_INFINITY) {
            bl45 = true;
        }
        harness.check(bl45, "got: " + (d + 444.0));
        boolean bl46 = false;
        if (-4.44E302 - d == Double.NEGATIVE_INFINITY) {
            bl46 = true;
        }
        harness.check(bl46, "got: " + (-444.0 - d));
        harness.checkPoint("*|/|% int");
        i = 124;
        boolean bl47 = false;
        if (i * 10 == 1240) {
            bl47 = true;
        }
        harness.check(bl47);
        boolean bl48 = false;
        if (i / 10 == 12) {
            bl48 = true;
        }
        harness.check(bl48);
        boolean bl49 = false;
        if (i % 10 == 4) {
            bl49 = true;
        }
        harness.check(bl49);
        i = 0;
        harness.check(2, 2, "5 % 3 = 2");
        harness.check(2, 2, "5 % (-3) = 2");
        harness.check(-2, -2, "(-5) % 3 = -2");
        harness.check(-2, -2, "(-5) % (-3) = -2");
        try {
            i = 123 / i;
            harness.fail("should throw ArithmeticException");
        }
        catch (ArithmeticException ae) {
            harness.check(true);
        }
        i = Integer.MIN_VALUE;
        boolean bl50 = false;
        if (i / -1 == i) {
            bl50 = true;
        }
        harness.check(bl50);
        boolean bl51 = false;
        if (i % -1 == 0) {
            bl51 = true;
        }
        harness.check(bl51);
        boolean bl52 = false;
        if (i * -1 == i) {
            bl52 = true;
        }
        harness.check(bl52, "got: " + i * -1);
        boolean bl53 = false;
        if (i * 2 == (int)((long)i * (long)2)) {
            bl53 = true;
        }
        harness.check(bl53, "got: " + i * 2);
        int min = Integer.MIN_VALUE;
        harness.check(min / 10000, -214748, "Integer.MIN_VALUE divide");
        harness.check(min * 10000, 0, "Integer.MIN_VALUE multiply");
        harness.check(min % 10000, -3648, "Integer.MIN_VALUE remainder");
        harness.checkPoint("*|/|% long");
        l = 124L;
        boolean bl54 = false;
        if (l * 10L == 1240L) {
            bl54 = true;
        }
        harness.check(bl54);
        boolean bl55 = false;
        if (l / 10L == 12L) {
            bl55 = true;
        }
        harness.check(bl55);
        boolean bl56 = false;
        if (l % 10L == (long)4) {
            bl56 = true;
        }
        harness.check(bl56);
        l = 0L;
        try {
            l = 134L / l;
            harness.fail("should throw ArithmeticException");
        }
        catch (ArithmeticException ae) {
            harness.check(true);
        }
        l = Long.MIN_VALUE;
        boolean bl57 = false;
        if (l / (long)-1 == l) {
            bl57 = true;
        }
        harness.check(bl57);
        boolean bl58 = false;
        if (l % (long)-1 == 0L) {
            bl58 = true;
        }
        harness.check(bl58);
        boolean bl59 = false;
        if (l * (long)-1 == l) {
            bl59 = true;
        }
        harness.check(bl59, "got: " + l * (long)-1);
        boolean bl60 = false;
        if (l * (long)2 == 0L) {
            bl60 = true;
        }
        harness.check(bl60);
        long mn = Long.MIN_VALUE;
        harness.check(mn / 10000L, -922337203685477L, "Long.MIN_VALUE divide");
        harness.check(mn * 10000L, 0L, "Long.MIN_VALUE multiply");
        harness.check(mn % 10000L, -5808L, "Long.MIN_VALUE remainder");
        harness.checkPoint("* Float");
        f = 124.0f;
        boolean bl61 = false;
        if (f * 10.0f == 1240.0f) {
            bl61 = true;
        }
        harness.check(bl61);
        boolean bl62 = false;
        if (f * -10.0f == -1240.0f) {
            bl62 = true;
        }
        harness.check(bl62);
        boolean bl63 = false;
        if (-f * 10.0f == -1240.0f) {
            bl63 = true;
        }
        harness.check(bl63);
        boolean bl64 = false;
        if (-f * -10.0f == 1240.0f) {
            bl64 = true;
        }
        harness.check(bl64);
        harness.check(Float.isNaN(f * Float.NaN));
        f = Float.POSITIVE_INFINITY;
        harness.check(Float.isNaN(f * -0.0f));
        harness.check(Float.isNaN(f * 0.0f));
        boolean bl65 = false;
        if (f * 10.0f == f) {
            bl65 = true;
        }
        harness.check(bl65);
        boolean bl66 = false;
        if (f * -10.0f == Float.NEGATIVE_INFINITY) {
            bl66 = true;
        }
        harness.check(bl66);
        f = Float.NEGATIVE_INFINITY;
        harness.check(Float.isNaN(f * -0.0f));
        harness.check(Float.isNaN(f * 0.0f));
        boolean bl67 = false;
        if (f * 10.0f == f) {
            bl67 = true;
        }
        harness.check(bl67);
        boolean bl68 = false;
        if (f * -10.0f == Float.POSITIVE_INFINITY) {
            bl68 = true;
        }
        harness.check(bl68);
        harness.checkPoint("* double");
        d = 124.0;
        boolean bl69 = false;
        if (d * 10.0 == 1240.0) {
            bl69 = true;
        }
        harness.check(bl69);
        boolean bl70 = false;
        if (d * -10.0 == -1240.0) {
            bl70 = true;
        }
        harness.check(bl70);
        boolean bl71 = false;
        if (-d * 10.0 == -1240.0) {
            bl71 = true;
        }
        harness.check(bl71);
        boolean bl72 = false;
        if (-d * -10.0 == 1240.0) {
            bl72 = true;
        }
        harness.check(bl72);
        harness.check(Double.isNaN(d * Double.NaN));
        d = Double.POSITIVE_INFINITY;
        harness.check(Double.isNaN(d * -0.0));
        harness.check(Double.isNaN(d * 0.0));
        boolean bl73 = false;
        if (d * 10.0 == d) {
            bl73 = true;
        }
        harness.check(bl73);
        boolean bl74 = false;
        if (d * -10.0 == Double.NEGATIVE_INFINITY) {
            bl74 = true;
        }
        harness.check(bl74);
        d = Double.NEGATIVE_INFINITY;
        harness.check(Double.isNaN(d * -0.0));
        harness.check(Double.isNaN(d * 0.0));
        boolean bl75 = false;
        if (d * 10.0 == d) {
            bl75 = true;
        }
        harness.check(bl75);
        boolean bl76 = false;
        if (d * -10.0 == Double.POSITIVE_INFINITY) {
            bl76 = true;
        }
        harness.check(bl76);
        harness.checkPoint("/ Float");
        f = 1240.0f;
        boolean bl77 = false;
        if (f / 10.0f == 124.0f) {
            bl77 = true;
        }
        harness.check(bl77);
        boolean bl78 = false;
        if (f / -10.0f == -124.0f) {
            bl78 = true;
        }
        harness.check(bl78);
        boolean bl79 = false;
        if (-f / 10.0f == -124.0f) {
            bl79 = true;
        }
        harness.check(bl79);
        boolean bl80 = false;
        if (-f / -10.0f == 124.0f) {
            bl80 = true;
        }
        harness.check(bl80);
        harness.check(Float.isNaN(f / Float.NaN));
        harness.check(Float.isNaN(Float.NaN / f));
        f = Float.POSITIVE_INFINITY;
        harness.check(Float.isNaN(f / f));
        harness.check(Float.isNaN(f / Float.NEGATIVE_INFINITY));
        f = Float.NEGATIVE_INFINITY;
        harness.check(Float.isNaN(f / f));
        harness.check(Float.isNaN(f / Float.POSITIVE_INFINITY));
        f = Float.POSITIVE_INFINITY;
        boolean bl81 = false;
        if (10.0f / f == 0.0f) {
            bl81 = true;
        }
        harness.check(bl81);
        boolean bl82 = false;
        if (-10.0f / f == -0.0f) {
            bl82 = true;
        }
        harness.check(bl82);
        f = 0.0f;
        harness.check(Float.isNaN(f / -0.0f));
        harness.check(Float.isNaN(f / 0.0f));
        boolean bl83 = false;
        if (f / 10.0f == f) {
            bl83 = true;
        }
        harness.check(bl83);
        boolean bl84 = false;
        if (f / -10.0f == -0.0f) {
            bl84 = true;
        }
        harness.check(bl84);
        boolean bl85 = false;
        if (10.0f / f == Float.POSITIVE_INFINITY) {
            bl85 = true;
        }
        harness.check(bl85);
        boolean bl86 = false;
        if (-10.0f / f == Float.NEGATIVE_INFINITY) {
            bl86 = true;
        }
        harness.check(bl86);
        f = Float.MAX_VALUE;
        boolean bl87 = false;
        if (f % Float.MIN_VALUE == 0.0f) {
            bl87 = true;
        }
        harness.check(bl87, "overflow in division -- result should be correct GOT: " + f % Float.MIN_VALUE);
        boolean bl88 = false;
        if (f % 0.5f == 0.0f) {
            bl88 = true;
        }
        harness.check(bl88, "overflow in division -- result should be correct GOT: " + f % 0.5f);
        harness.checkPoint("/ double");
        d = 12400.0;
        boolean bl89 = false;
        if (d / 10.0 == 1240.0) {
            bl89 = true;
        }
        harness.check(bl89);
        boolean bl90 = false;
        if (d / -10.0 == -1240.0) {
            bl90 = true;
        }
        harness.check(bl90);
        boolean bl91 = false;
        if (-d / 10.0 == -1240.0) {
            bl91 = true;
        }
        harness.check(bl91);
        boolean bl92 = false;
        if (-d / -10.0 == 1240.0) {
            bl92 = true;
        }
        harness.check(bl92);
        harness.check(Double.isNaN(d / Double.NaN));
        harness.check(Double.isNaN(Double.NaN / d));
        d = Double.POSITIVE_INFINITY;
        harness.check(Double.isNaN(d / d));
        harness.check(Double.isNaN(d / Double.NEGATIVE_INFINITY));
        d = Double.NEGATIVE_INFINITY;
        harness.check(Double.isNaN(d / d));
        harness.check(Double.isNaN(d / Double.POSITIVE_INFINITY));
        d = Double.POSITIVE_INFINITY;
        boolean bl93 = false;
        if (10.0 / d == 0.0) {
            bl93 = true;
        }
        harness.check(bl93);
        boolean bl94 = false;
        if (-10.0 / d == -0.0) {
            bl94 = true;
        }
        harness.check(bl94);
        d = 0.0;
        harness.check(Double.isNaN(d / -0.0));
        harness.check(Double.isNaN(d / 0.0));
        boolean bl95 = false;
        if (d / 10.0 == d) {
            bl95 = true;
        }
        harness.check(bl95);
        boolean bl96 = false;
        if (d / -10.0 == -0.0) {
            bl96 = true;
        }
        harness.check(bl96);
        boolean bl97 = false;
        if (10.0 / d == Double.POSITIVE_INFINITY) {
            bl97 = true;
        }
        harness.check(bl97);
        boolean bl98 = false;
        if (-10.0 / d == Double.NEGATIVE_INFINITY) {
            bl98 = true;
        }
        harness.check(bl98);
        harness.checkPoint("% Float");
        f = 124.0f;
        boolean bl99 = false;
        if (f % 10.0f == (float)4) {
            bl99 = true;
        }
        harness.check(bl99);
        boolean bl100 = false;
        if (f % -10.0f == (float)4) {
            bl100 = true;
        }
        harness.check(bl100);
        boolean bl101 = false;
        if (-f % 10.0f == -4.0f) {
            bl101 = true;
        }
        harness.check(bl101);
        boolean bl102 = false;
        if (-f % -10.0f == -4.0f) {
            bl102 = true;
        }
        harness.check(bl102);
        harness.check(Float.isNaN(f % Float.NaN));
        harness.check(Float.isNaN(Float.NaN % f));
        f = Float.POSITIVE_INFINITY;
        harness.check(Float.isNaN(f % f));
        harness.check(Float.isNaN(f % Float.NEGATIVE_INFINITY));
        harness.check(Float.isNaN(f % 12.2f), "got: " + f % 12.2f);
        harness.check(Float.isNaN(f % -2.34f), "got: " + f % -2.34f);
        harness.check(Float.isNaN(f % 0.0f), "got: " + f % 0.0f);
        harness.check(Float.isNaN(f % -0.0f), "got: " + f % -0.0f);
        f = Float.NEGATIVE_INFINITY;
        harness.check(Float.isNaN(f % f), "got: " + f % f);
        harness.check(Float.isNaN(f % Float.POSITIVE_INFINITY), "got: " + f % Float.POSITIVE_INFINITY);
        harness.check(Float.isNaN(f % 23.45f), "got: " + f % 23.45f);
        harness.check(Float.isNaN(f % -3.45f), "got: " + f % -3.45f);
        harness.check(Float.isNaN(f % 0.0f), "got: " + f % 0.0f);
        harness.check(Float.isNaN(f % -0.0f), "got: " + f % -0.0f);
        f = 0.0f;
        harness.check(Float.isNaN(32.434f % f), "got: " + 32.434f % f);
        harness.check(Float.isNaN(-3.594f % f), "got: " + -3.594f % f);
        f = -0.0f;
        harness.check(Float.isNaN(32.434f % f), "got: " + 32.434f % f);
        harness.check(Float.isNaN(-3.594f % f), "got: " + -3.594f % f);
        f = Float.POSITIVE_INFINITY;
        boolean bl103 = false;
        if (10.0f % f == 10.0f) {
            bl103 = true;
        }
        harness.check(bl103, "got: " + 10.0f % f);
        boolean bl104 = false;
        if (-10.0f % f == -10.0f) {
            bl104 = true;
        }
        harness.check(bl104, "got: " + -10.0f % f);
        boolean bl105 = false;
        if (0.0f % f == 0.0f) {
            bl105 = true;
        }
        harness.check(bl105, "got: " + 0.0f % f);
        boolean bl106 = false;
        if (-0.0f % f == -0.0f) {
            bl106 = true;
        }
        harness.check(bl106, "got: " + -0.0f % f);
        f = Float.NEGATIVE_INFINITY;
        boolean bl107 = false;
        if (10.0f % f == 10.0f) {
            bl107 = true;
        }
        harness.check(bl107, "got: " + 10.0f % f);
        boolean bl108 = false;
        if (-10.0f % f == -10.0f) {
            bl108 = true;
        }
        harness.check(bl108, "got: " + -10.0f % f);
        boolean bl109 = false;
        if (0.0f % f == 0.0f) {
            bl109 = true;
        }
        harness.check(bl109, "got: " + 0.0f % f);
        boolean bl110 = false;
        if (-0.0f % f == -0.0f) {
            bl110 = true;
        }
        harness.check(bl110, "got: " + -0.0f % f);
        f = 124.0f;
        boolean bl111 = false;
        if (0.0f % f == 0.0f) {
            bl111 = true;
        }
        harness.check(bl111, "got: " + 0.0f % f);
        boolean bl112 = false;
        if (-0.0f % f == -0.0f) {
            bl112 = true;
        }
        harness.check(bl112, "got: " + -0.0f % f);
        harness.checkPoint("++ Postfix Operator");
        i = 5;
        int j = i++;
        boolean bl113 = false;
        if (j == 5 && i == 6) {
            bl113 = true;
        }
        harness.check(bl113);
        l = 5;
        long m = l++;
        boolean bl114 = false;
        if (m == (long)5 && l == 6L) {
            bl114 = true;
        }
        harness.check(bl114);
        float f2 = f = 5.5f;
        f = f2 + 1.0f;
        float g = f2;
        boolean bl115 = false;
        if (g == 5.5f && f == 6.5f) {
            bl115 = true;
        }
        harness.check(bl115);
        double d2 = d = 5.5;
        d = d2 + 1.0;
        double e = d2;
        boolean bl116 = false;
        if (e == 5.5 && d == 6.5) {
            bl116 = true;
        }
        harness.check(bl116);
        harness.checkPoint("-- Postfix Operator");
        i = 5;
        j = i--;
        boolean bl117 = false;
        if (j == 5 && i == 4) {
            bl117 = true;
        }
        harness.check(bl117);
        l = 5;
        m = l--;
        boolean bl118 = false;
        if (m == (long)5 && l == (long)4) {
            bl118 = true;
        }
        harness.check(bl118);
        float f3 = f = 5.5f;
        f = f3 - 1.0f;
        g = f3;
        boolean bl119 = false;
        if (g == 5.5f && f == 4.5f) {
            bl119 = true;
        }
        harness.check(bl119);
        double d3 = d = 5.5;
        d = d3 - 1.0;
        e = d3;
        boolean bl120 = false;
        if (e == 5.5 && d == 4.5) {
            bl120 = true;
        }
        harness.check(bl120);
        harness.checkPoint("++ Prefix Operator");
        i = 5;
        j = ++i;
        boolean bl121 = false;
        if (j == i && i == 6) {
            bl121 = true;
        }
        harness.check(bl121);
        l = 5;
        m = ++l;
        boolean bl122 = false;
        if (m == l && l == 6L) {
            bl122 = true;
        }
        harness.check(bl122);
        f = 5.5f;
        g = f += 1.0f;
        boolean bl123 = false;
        if (g == f && f == 6.5f) {
            bl123 = true;
        }
        harness.check(bl123);
        d = 5.5;
        e = d += 1.0;
        boolean bl124 = false;
        if (e == d && d == 6.5) {
            bl124 = true;
        }
        harness.check(bl124);
        harness.checkPoint("-- Prefix Operator");
        i = 5;
        j = --i;
        boolean bl125 = false;
        if (j == i && i == 4) {
            bl125 = true;
        }
        harness.check(bl125);
        l = 5;
        m = --l;
        boolean bl126 = false;
        if (m == l && l == (long)4) {
            bl126 = true;
        }
        harness.check(bl126);
        f = 5.5f;
        g = f -= 1.0f;
        boolean bl127 = false;
        if (g == f && f == 4.5f) {
            bl127 = true;
        }
        harness.check(bl127);
        d = 5.5;
        e = d -= 1.0;
        boolean bl128 = false;
        if (e == d && d == 4.5) {
            bl128 = true;
        }
        harness.check(bl128);
    }

    public void testBooleanOps() {
        boolean b = true;
        harness.checkPoint("boolean !");
        harness.check(b ^ true ^ true);
        b = false;
        harness.check(b ^ true);
        harness.checkPoint("boolean &&");
        b = true;
        harness.check(b);
        harness.check(false ^ true);
        b = false;
        harness.check(b ^ true);
        harness.check(false ^ true);
        harness.checkPoint("boolean ||");
        b = true;
        harness.check(true);
        harness.check(b);
        b = false;
        harness.check(true);
        harness.check(b ^ true);
        harness.checkPoint("boolean ^^");
        b = true;
        harness.check(b ^ true ^ true);
        harness.check(b);
        b = false;
        harness.check(b ^ true);
        harness.check(b ^ true);
    }

    public void testShiftOps() {
        int ip = Integer.MAX_VALUE;
        long lp = Long.MAX_VALUE;
        int im = Integer.MIN_VALUE;
        long lm = Long.MIN_VALUE;
        char jp = (char)-1;
        int jm = -2147418113;
        harness.checkPoint("shiftoperator >>");
        boolean bl = false;
        if (ip >> 16 == Short.MAX_VALUE) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (im >> 16 == Short.MIN_VALUE) {
            bl2 = true;
        }
        harness.check(bl2, "got: " + (im >> 16));
        boolean bl3 = false;
        if (lp >> 48 == 32767L) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (lm >> 48 == -32768L) {
            bl4 = true;
        }
        harness.check(bl4, "got: " + (lm >> 48));
        harness.checkPoint("shiftoperator <<");
        boolean bl5 = false;
        if (jp << 16 == -65536) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if (jm << 16 == -65536) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (ip << 1 == -2) {
            bl7 = true;
        }
        harness.check(bl7, "got: " + (im << 1));
        boolean bl8 = false;
        if (im << 1 == 0) {
            bl8 = true;
        }
        harness.check(bl8, "got: " + (im << 1));
        harness.checkPoint("shiftoperator >>>");
        boolean bl9 = false;
        if (ip >>> 16 == Short.MAX_VALUE) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if (im >>> 16 == 32768) {
            bl10 = true;
        }
        harness.check(bl10, "got: " + (im >>> 16));
        boolean bl11 = false;
        if (lp >>> 48 == 32767L) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (lm >>> 48 == 32768L) {
            bl12 = true;
        }
        harness.check(bl12, "got: " + (lm >>> 48));
    }

    public void testBitwiseOps() {
        int i = Integer.MAX_VALUE;
        long l = Integer.MAX_VALUE;
        harness.checkPoint("bitwise &");
        boolean bl = false;
        if ((i & 0x8000FFFF) == (char)-1) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if ((l & 0x7FFF0000L) == 0x7FFF0000L) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (!false) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (0L == 0L) {
            bl4 = true;
        }
        harness.check(bl4);
        harness.checkPoint("bitwise |");
        boolean bl5 = false;
        if ((i | 0x80010000) == -1) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if ((l | 0x7FFF0000L) == l) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (i == i) {
            bl7 = true;
        }
        harness.check(bl7);
        boolean bl8 = false;
        if (l == l) {
            bl8 = true;
        }
        harness.check(bl8);
        harness.checkPoint("bitwise ^");
        boolean bl9 = false;
        if ((i ^ 0x8000FFFF) == -65536) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if ((l ^ 0x7FFF0001L) == 65534L) {
            bl10 = true;
        }
        harness.check(bl10);
        boolean bl11 = false;
        if (i == i) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (l == l) {
            bl12 = true;
        }
        harness.check(bl12);
    }

    public void testMaximumValues() {
        harness.checkPoint("maximum byte values");
        this.compareValue((byte)127, 0, (byte)127);
        this.compareValue((byte)-128, 0, (byte)-128);
        this.compareValue((byte)-127, 0, (byte)-127);
        this.compareValue((byte)-128, 0, (byte)-128);
        this.compareValue((byte)127, 0, (byte)127);
        this.compareValue((byte)126, 0, (byte)126);
        harness.checkPoint("maximum short values");
        this.compareValue((short)Short.MAX_VALUE, 0, (short)Short.MAX_VALUE);
        this.compareValue((short)Short.MIN_VALUE, 0, (short)Short.MIN_VALUE);
        this.compareValue((short)-32767, 0, (short)-32767);
        this.compareValue((short)Short.MIN_VALUE, 0, (short)Short.MIN_VALUE);
        this.compareValue((short)Short.MAX_VALUE, 0, (short)Short.MAX_VALUE);
        this.compareValue((short)32766, 0, (short)32766);
        harness.checkPoint("maximum int values");
        this.compareValue(Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        this.compareValue(Integer.MIN_VALUE, 0, Integer.MIN_VALUE);
        this.compareValue(-2147483647, 0, -2147483647);
        this.compareValue(Integer.MIN_VALUE, 0, Integer.MIN_VALUE);
        this.compareValue(Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        this.compareValue(0x7FFFFFFE, 0, 0x7FFFFFFE);
        harness.check(Integer.toString(Integer.MAX_VALUE).equals("2147483647"), "got: " + Integer.toString(Integer.MAX_VALUE));
        harness.check(Integer.toString(Integer.MIN_VALUE).equals("-2147483648"), "got: " + Integer.toString(Integer.MIN_VALUE));
        harness.checkPoint("maximum long values");
        this.compareValue(Long.MAX_VALUE, 0, Long.MAX_VALUE);
        this.compareValue(Long.MAX_VALUE, 0, Long.MAX_VALUE);
        this.compareValue(Long.MIN_VALUE, 0, Long.MIN_VALUE);
        this.compareValue(-9223372036854775807L, 0, -9223372036854775807L);
        this.compareValue(Long.MIN_VALUE, 0, Long.MIN_VALUE);
        this.compareValue(Long.MAX_VALUE, 0, Long.MAX_VALUE);
        this.compareValue(0x7FFFFFFFFFFFFFFEL, 0, 0x7FFFFFFFFFFFFFFEL);
        harness.check(Long.toString(Long.MAX_VALUE), "9223372036854775807", "got: " + Long.toString(Long.MAX_VALUE));
        harness.check(Long.toString(Long.MIN_VALUE), "-9223372036854775808", "got: " + Long.toString(Long.MIN_VALUE));
        harness.check(Long.toString(Long.MIN_VALUE, 2), "-1000000000000000000000000000000000000000000000000000000000000000", "got: " + Long.toString(Long.MIN_VALUE));
        harness.check(Long.toString(0L), (Object)"0");
    }

    public void testBiggerSmaller() {
        harness.checkPoint("Bigger/smaller Long");
        this.compareValue(Long.MAX_VALUE, 1, 0x7FFFFFFFFFFFFFFEL);
        this.compareValue(Long.MAX_VALUE, 1, Long.MIN_VALUE);
        this.compareValue(-9223372036854775807L, 1, Long.MIN_VALUE);
        this.compareValue(23545L, 1, 9223L);
        this.compareValue(0L, 1, -9223L);
        this.compareValue(245L, 1, 0L);
        this.compareValue(-9222L, 1, -9223L);
        this.compareValue(9224L, 1, 9223L);
        harness.checkPoint("Bigger/smaller Integer");
        this.compareValue(Integer.MAX_VALUE, 1, 0x7FFFFFFE);
        this.compareValue(Integer.MAX_VALUE, 1, Integer.MIN_VALUE);
        this.compareValue(-2147483647, 1, Integer.MIN_VALUE);
        this.compareValue(23545, 1, 9223);
        this.compareValue(0, 1, -9223);
        this.compareValue(245, 1, 0);
        this.compareValue(-9222, 1, -9223);
        this.compareValue(9224, 1, 9223);
        harness.checkPoint("Bigger/smaller Short");
        this.compareValue((short)Short.MAX_VALUE, 1, (short)32766);
        this.compareValue((short)Short.MAX_VALUE, 1, (short)Short.MIN_VALUE);
        this.compareValue((short)-32767, 1, (short)Short.MIN_VALUE);
        this.compareValue(23545, 1, 9223);
        this.compareValue(0, 1, -9223);
        this.compareValue(245, 1, 0);
        this.compareValue(-9222, 1, -9223);
        this.compareValue(9224, 1, 9223);
        harness.checkPoint("Bigger/smaller Byte");
        this.compareValue(127, 1, 126);
        this.compareValue((byte)127, 1, (byte)-128);
        this.compareValue(-127L, 1, Long.MIN_VALUE);
        this.compareValue(23, 1, 22);
        this.compareValue(0, 1, -92);
        this.compareValue(45, 1, 0);
        this.compareValue(-22, 1, -23);
        this.compareValue(24, 1, 23);
        harness.checkPoint("Bigger/smaller  Floats");
        this.compareValue(100.1f, 1, 99.9f);
        this.compareValue(100.1f, 1, -100.1f);
        this.compareValue(-100.1f, -1, -99.9f);
        this.compareValue(100.1f, 1, -99.9f);
        this.compareValue(-100.1f, -1, 99.9f);
        this.compareValue(Float.MIN_VALUE, 1, 0.0f);
        this.compareValue(Float.MAX_VALUE, 1, 3.0E12f);
        this.compareValue(0.0f, 0, -0.0f);
        harness.check(true, "0.0 == -0.0 test -- 1");
        harness.check(true, "0.0 == -0.0 test -- 2");
        harness.check(true, "0.0 == -0.0 test -- 3");
        harness.check(true, "0.0 == -0.0 test -- 4");
        harness.checkPoint("Bigger/smaller doubles");
        this.compareValue(100.1, 1, 99.9);
        this.compareValue(100.1, 1, -100.1);
        this.compareValue(-100.1, -1, -99.9);
        this.compareValue(100.1, 1, -99.9);
        this.compareValue(-100.1, -1, 99.9);
        this.compareValue(Double.MIN_VALUE, 1, 0.0);
        this.compareValue(Double.MAX_VALUE, 1, 3.0E234);
        this.compareValue(0.0, 0, -0.0);
        harness.check(true, "0.0 == -0.0 test -- 1");
        harness.check(true, "0.0 == -0.0 test -- 2");
        harness.check(true, "0.0 == -0.0 test -- 3");
        harness.check(true, "0.0 == -0.0 test -- 4");
        harness.checkPoint("Bigger/smaller infinite and NaN values Float");
        this.compareValue(Float.POSITIVE_INFINITY, 1, 0.0f);
        this.compareValue(Float.NEGATIVE_INFINITY, -1, 0.0f);
        this.compareValue(Float.NEGATIVE_INFINITY, -1, -3.4028235E38f);
        this.compareValue(Float.POSITIVE_INFINITY, 1, Float.MAX_VALUE);
        this.compareValue(Float.POSITIVE_INFINITY, 1, Float.NEGATIVE_INFINITY);
        this.compareValue(Float.NaN, -2);
        this.compareValue(Float.NEGATIVE_INFINITY, -2, Float.NaN);
        this.compareValue(Float.POSITIVE_INFINITY, -2, Float.NaN);
        this.compareValue(Float.MIN_VALUE, -2, Float.NaN);
        this.compareValue(Float.MAX_VALUE, -2, Float.NaN);
        harness.check(true, "Comparing NaN should always FALSE");
        harness.check(true, "Comparing NaN should always FALSE");
        harness.check(true, "Comparing NaN should always FALSE");
        harness.check(true, "Comparing NaN should always FALSE");
        harness.checkPoint("Bigger/smaller infinite and NaN values Double");
        this.compareValue(Double.POSITIVE_INFINITY, 1, 0.0);
        this.compareValue(Double.NEGATIVE_INFINITY, -1, 0.0);
        this.compareValue(Double.NEGATIVE_INFINITY, -1, -1.7976931348623157E308);
        this.compareValue(Double.POSITIVE_INFINITY, 1, Double.MAX_VALUE);
        this.compareValue(Double.POSITIVE_INFINITY, 1, Double.NEGATIVE_INFINITY);
        this.compareValue(Double.NaN, -2);
        this.compareValue(Double.NEGATIVE_INFINITY, -2, Double.NaN);
        this.compareValue(Double.POSITIVE_INFINITY, -2, Double.NaN);
        this.compareValue(Double.MIN_VALUE, -2, Double.NaN);
        this.compareValue(Double.MAX_VALUE, -2, Double.NaN);
        harness.check(true, "Comparing NaN should always FALSE");
        harness.check(true, "Comparing NaN should always FALSE");
        harness.check(true, "Comparing NaN should always FALSE");
        harness.check(true, "Comparing NaN should always FALSE");
        harness.checkPoint("== Float");
        harness.check(true, "test == nr 1");
        harness.check(true, "test == nr 2");
        harness.check(true, "test == nr 3");
        harness.check(true, "test == nr 4");
        harness.check(true, "test == nr 5");
        harness.check(true, "test != nr 1");
        harness.check(true, "test != nr 2");
        harness.check(true, "test != nr 3");
        harness.check(true, "test != nr 4");
        harness.check(true, "test != nr 5");
        harness.check(true, "NaN != NaN is true");
        harness.checkPoint("== Double");
        harness.check(true, "test == nr 1");
        harness.check(true, "test == nr 2");
        harness.check(true, "test == nr 3");
        harness.check(true, "test == nr 4");
        harness.check(true, "test == nr 5");
        harness.check(true, "test != nr 1");
        harness.check(true, "test != nr 2");
        harness.check(true, "test != nr 3");
        harness.check(true, "test != nr 4");
        harness.check(true, "test != nr 5");
        harness.check(true, "NaN != NaN is true");
    }

    public void testConversions() {
        harness.checkPoint("conversins to floating point primitives");
        this.compareValue(100.0f, 0, 100.0f);
        this.compareValue(100.0f, 0, 100.0f);
        this.compareValue(100.0f, 0, 100.0f);
        this.compareValue(100.0f, 0, 100.0f);
        this.compareValue(-100.0f, 0, -100.0f);
        this.compareValue(-100.0f, 0, -100.0f);
        this.compareValue(-100.0f, 0, -100.0f);
        this.compareValue(-100.0, 0, -100.0);
        this.compareValue(100.0, 0, 100.0);
        this.compareValue(100.0, 0, 100.0);
        this.compareValue(100.0, 0, 100.0);
        this.compareValue(100.0, 0, 100.0);
        this.compareValue(-100.0, 0, -100.0);
        this.compareValue(-100.0, 0, -100.0);
        this.compareValue(-100.0, 0, -100.0);
        this.compareValue(-100.0, 0, -100.0);
        this.compareValue((byte)100, 0, (byte)100);
        this.compareValue((short)100, 0, (short)100);
        this.compareValue(100, 0, 100);
        this.compareValue(100L, 0, 100L);
        this.compareValue((byte)-100, 0, (byte)-100);
        this.compareValue((short)-100, 0, (short)-100);
        this.compareValue(-100, 0, -100);
        this.compareValue(-100L, 0, -100L);
        this.compareValue((byte)100, 0, (byte)100);
        this.compareValue((short)100, 0, (short)100);
        this.compareValue(100, 0, 100);
        this.compareValue(100L, 0, 100L);
        this.compareValue((byte)-100, 0, (byte)-100);
        this.compareValue((short)-100, 0, (short)-100);
        this.compareValue(-100, 0, -100);
        this.compareValue(-100L, 0, -100L);
        harness.checkPoint("conversions infinite and NaN values");
        this.compareValue(Float.POSITIVE_INFINITY, 0, Float.POSITIVE_INFINITY);
        this.compareValue(Float.NEGATIVE_INFINITY, 0, Float.NEGATIVE_INFINITY);
        harness.check(Float.isNaN(Float.NaN));
        harness.check(Float.toString(Float.NaN).equals("NaN"));
        this.compareValue(0.0f, 0, 0.0f);
        this.compareValue(0.0f, 0, 0.0f);
        this.compareValue(-0.0f, 0, -0.0f);
        this.compareValue(-0.0f, 0, -0.0f);
        this.compareValue(Double.POSITIVE_INFINITY, 0, Double.POSITIVE_INFINITY);
        this.compareValue(Double.NEGATIVE_INFINITY, 0, Double.NEGATIVE_INFINITY);
        harness.check(Double.isNaN(Double.NaN));
        harness.check(Double.toString(Double.NaN).equals("NaN"));
        this.compareValue(0.0, 0, 0.0);
        this.compareValue(0.0, 0, 0.0);
        this.compareValue(-0.0, 0, -0.0);
        this.compareValue(-0.0, 0, -0.0);
    }

    public void testInfiniteNanOperators() {
        harness.checkPoint("Float infinity and NaN definitions");
        harness.check(Float.toString(Float.NaN).equals("NaN"));
        harness.check(Float.toString(Float.NaN).equals("NaN"));
        this.compareValue(Float.POSITIVE_INFINITY, 0, Float.POSITIVE_INFINITY);
        this.compareValue(Float.NEGATIVE_INFINITY, 0, Float.NEGATIVE_INFINITY);
        harness.checkPoint("Float infinity and NaN definitions");
        harness.check(Double.toString(Double.NaN).equals("NaN"));
        harness.check(Double.toString(Double.NaN).equals("NaN"));
        this.compareValue(Double.POSITIVE_INFINITY, 0, Double.POSITIVE_INFINITY);
        this.compareValue(Double.NEGATIVE_INFINITY, 0, Double.NEGATIVE_INFINITY);
        harness.checkPoint("Float infinity and NaN add, subtract");
        this.compareValue(Float.POSITIVE_INFINITY, 0, Float.POSITIVE_INFINITY);
        this.compareValue(Float.NEGATIVE_INFINITY, 0, Float.NEGATIVE_INFINITY);
        this.compareValue(Float.POSITIVE_INFINITY, 0, Float.POSITIVE_INFINITY);
        this.compareValue(Float.NEGATIVE_INFINITY, 0, Float.NEGATIVE_INFINITY);
        float f1 = Float.POSITIVE_INFINITY;
        this.compareValue(f1 - Float.POSITIVE_INFINITY, -2);
        this.compareValue(f1 + Float.NEGATIVE_INFINITY, -2);
        f1 = Float.NEGATIVE_INFINITY;
        this.compareValue(f1 - Float.NEGATIVE_INFINITY, -2);
        this.compareValue(f1 + Float.POSITIVE_INFINITY, -2);
        harness.checkPoint("Double infinity and NaN add, subtract");
        this.compareValue(Double.POSITIVE_INFINITY, 0, Double.POSITIVE_INFINITY);
        this.compareValue(Double.NEGATIVE_INFINITY, 0, Double.NEGATIVE_INFINITY);
        this.compareValue(Double.POSITIVE_INFINITY, 0, Double.POSITIVE_INFINITY);
        this.compareValue(Double.NEGATIVE_INFINITY, 0, Double.NEGATIVE_INFINITY);
        this.compareValue(Double.NaN, -2);
        this.compareValue(Double.NaN, -2);
        this.compareValue(Double.NaN, -2);
        this.compareValue(Double.NaN, -2);
        harness.checkPoint("Float infinity and NaN multiplicatins, devisions, remainders");
        this.compareValue(Float.POSITIVE_INFINITY, 0, Float.POSITIVE_INFINITY);
        this.compareValue(Float.POSITIVE_INFINITY, 0, Float.POSITIVE_INFINITY);
        this.compareValue(Float.NEGATIVE_INFINITY, 0, Float.NEGATIVE_INFINITY);
        this.compareValue(Float.NEGATIVE_INFINITY, 0, Float.NEGATIVE_INFINITY);
        f1 = Float.POSITIVE_INFINITY;
        this.compareValue(f1 / Float.POSITIVE_INFINITY, -2);
        this.compareValue(f1 / Float.NEGATIVE_INFINITY, -2);
        f1 = Float.NEGATIVE_INFINITY;
        this.compareValue(f1 / Float.NEGATIVE_INFINITY, -2);
        this.compareValue(f1 / Float.POSITIVE_INFINITY, -2);
        harness.checkPoint("Double infinity and NaN multiplicatins, devisions, remainders");
        this.compareValue(Double.POSITIVE_INFINITY, 0, Double.POSITIVE_INFINITY);
        this.compareValue(Double.POSITIVE_INFINITY, 0, Double.POSITIVE_INFINITY);
        this.compareValue(Double.NEGATIVE_INFINITY, 0, Double.NEGATIVE_INFINITY);
        this.compareValue(Double.NEGATIVE_INFINITY, 0, Double.NEGATIVE_INFINITY);
        this.compareValue(Double.NaN, -2);
        this.compareValue(Double.NaN, -2);
        this.compareValue(Double.NaN, -2);
        this.compareValue(Double.NaN, -2);
    }

    private final void compareValue(byte first, int specification, byte second) {
        switch (specification) {
            case 1: {
                if (first > second) {
                    harness.check(true);
                    break;
                }
                if (first < second) {
                    harness.fail("Detected byte " + first + " smaller then " + second + " (should be bigger)");
                    break;
                }
                harness.fail("Detected byte " + first + " equals to " + second + " (should be bigger)");
                break;
            }
            case 0: {
                if (first > second) {
                    harness.fail("Detected byte " + first + " bigger then " + second + " (should be equal)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected byte " + first + " smaller then " + second + " (should be equal)");
                    break;
                }
                harness.check(true);
                break;
            }
            case -1: {
                if (first > second) {
                    harness.fail("Detected byte " + first + " bigger then " + second + " (should be smaller)");
                    break;
                }
                if (first < second) {
                    harness.check(true);
                    break;
                }
                harness.fail("Detected byte " + first + " equals to " + second + " (should be smaller)");
                break;
            }
        }
    }

    private final void compareValue(short first, int specification, short second) {
        switch (specification) {
            case 1: {
                if (first > second) {
                    harness.check(true);
                    break;
                }
                if (first < second) {
                    harness.fail("Detected short " + first + " smaller then " + second + " (should be bigger)");
                    break;
                }
                harness.fail("Detected short " + first + " equals to " + second + " (should be bigger)");
                break;
            }
            case 0: {
                if (first > second) {
                    harness.fail("Detected short " + first + " bigger then " + second + " (should be equal)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected short " + first + " smaller then " + second + " (should be equal)");
                    break;
                }
                harness.check(true);
                break;
            }
            case -1: {
                if (first > second) {
                    harness.fail("Detected short " + first + " bigger then " + second + " (should be smaller)");
                    break;
                }
                if (first < second) {
                    harness.check(true);
                    break;
                }
                harness.fail("Detected short " + first + " equals to " + second + " (should be smaller)");
                break;
            }
        }
    }

    private final void compareValue(int first, int specification, int second) {
        switch (specification) {
            case 1: {
                if (first > second) {
                    harness.check(true);
                    break;
                }
                if (first < second) {
                    harness.fail("Detected int " + first + " smaller then " + second + " (should be bigger)");
                    break;
                }
                harness.fail("Detected int " + first + " equals to " + second + " (should be bigger)");
                break;
            }
            case 0: {
                if (first > second) {
                    harness.fail("Detected int " + first + " bigger then " + second + " (should be equal)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected int " + first + " smaller then " + second + " (should be equal)");
                    break;
                }
                harness.check(true);
                break;
            }
            case -1: {
                if (first > second) {
                    harness.fail("Detected int " + first + " bigger then " + second + " (should be smaller)");
                    break;
                }
                if (first < second) {
                    harness.check(true);
                    break;
                }
                harness.fail("Detected int " + first + " equals to " + second + " (should be smaller)");
                break;
            }
        }
    }

    private final void compareValue(long first, int specification, long second) {
        switch (specification) {
            case 1: {
                if (first > second) {
                    harness.check(true);
                    break;
                }
                if (first < second) {
                    harness.fail("Detected long " + first + " smaller then " + second + " (should be bigger)");
                    break;
                }
                harness.fail("Detected long " + first + " equals to " + second + " (should be bigger)");
                break;
            }
            case 0: {
                if (first > second) {
                    harness.fail("Detected long " + first + " bigger then " + second + " (should be equal)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected long " + first + " smaller then " + second + " (should be equal)");
                    break;
                }
                harness.check(true);
                break;
            }
            case -1: {
                if (first > second) {
                    harness.fail("Detected long " + first + " bigger then " + second + " (should be smaller)");
                    break;
                }
                if (first < second) {
                    harness.check(true);
                    break;
                }
                harness.fail("Detected long " + first + " equals to " + second + " (should be smaller)");
                break;
            }
        }
    }

    private final void compareValue(float first, int specification, float second) {
        switch (specification) {
            case 1: {
                if (first > second) {
                    harness.check(true);
                    break;
                }
                if (first < second) {
                    harness.fail("Detected float " + first + " smaller then " + second + " (should be bigger)");
                    break;
                }
                if (first == second) {
                    harness.fail("Detected float " + first + " equals to " + second + " (should be bigger)");
                    break;
                }
                harness.fail("no comparison between float " + first + " and " + second + " possible (should be bigger)");
                break;
            }
            case 0: {
                if (first > second) {
                    harness.fail("Detected float " + first + " bigger then " + second + " (should be equal)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected float " + first + " smaller then " + second + " (should be equal)");
                    break;
                }
                if (first == second) {
                    harness.check(true);
                    break;
                }
                harness.fail("no comparison between float " + first + " and " + second + " possible (should be bigger)");
                break;
            }
            case -1: {
                if (first > second) {
                    harness.fail("Detected float " + first + " bigger then " + second + " (should be smaller)");
                    break;
                }
                if (first < second) {
                    harness.check(true);
                    break;
                }
                if (first == second) {
                    harness.fail("Detected float " + first + " equals to " + second + " (should be smaller)");
                    break;
                }
                harness.fail("no comparison between float " + first + " and " + second + " possible (should be bigger)");
                break;
            }
            case -2: {
                if (first > second) {
                    harness.fail("Detected float " + first + " bigger then " + second + " (should be undefined)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected float " + first + " smaller then " + second + " (should be undefined)");
                    break;
                }
                if (first == second) {
                    harness.fail("Detected float " + first + " equals to " + second + " (should be undefined)");
                    break;
                }
                harness.check(true);
                break;
            }
        }
    }

    private final void compareValue(double first, int specification, double second) {
        switch (specification) {
            case 1: {
                if (first > second) {
                    harness.check(true);
                    break;
                }
                if (first < second) {
                    harness.fail("Detected double " + first + " smaller then " + second + " (should be bigger)");
                    break;
                }
                if (first == second) {
                    harness.fail("Detected double " + first + " equals to " + second + " (should be bigger)");
                    break;
                }
                harness.fail("no comparison between double " + first + " and " + second + " possible (should be bigger)");
                break;
            }
            case 0: {
                if (first > second) {
                    harness.fail("Detected double " + first + " bigger then " + second + " (should be equal)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected double " + first + " smaller then " + second + " (should be equal)");
                    break;
                }
                if (first == second) {
                    harness.check(true);
                    break;
                }
                harness.fail("no comparison between double " + first + " and " + second + " possible (should be bigger)");
                break;
            }
            case -1: {
                if (first > second) {
                    harness.fail("Detected double " + first + " bigger then " + second + " (should be smaller)");
                    break;
                }
                if (first < second) {
                    harness.check(true);
                    break;
                }
                if (first == second) {
                    harness.fail("Detected double " + first + " equals to " + second + " (should be smaller)");
                    break;
                }
                harness.fail("no comparison between double " + first + " and " + second + " possible (should be bigger)");
                break;
            }
            case -2: {
                if (first > second) {
                    harness.fail("Detected double " + first + " bigger then " + second + " (should be undefined)");
                    break;
                }
                if (first < second) {
                    harness.fail("Detected double " + first + " smaller then " + second + " (should be undefined)");
                    break;
                }
                if (first == second) {
                    harness.fail("Detected double " + first + " equals to " + second + " (should be undefined)");
                    break;
                }
                harness.check(true);
                break;
            }
        }
    }

    private final void compareValue(float first, int specification) {
        this.compareValue(first, specification, 0.0f);
    }

    private final void compareValue(double first, int specification) {
        this.compareValue(first, specification, 0.0);
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("operators//opcodes");
        this.testMaximumValues();
        this.testBiggerSmaller();
        this.testConversions();
        this.testBasicOps();
        this.testBooleanOps();
        this.testShiftOps();
        this.testBitwiseOps();
        this.testInfiniteNanOperators();
    }
}

