/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Math;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class SMMathTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness testharness) {
        this.th = testharness;
        this.th.setclass("java.lang.Math");
        this.cygnustest();
        this.test_remainder();
        this.test_toDegrees();
        this.test_toRadians();
    }

    public void test_toDegrees() {
        this.th.checkPoint("toDegrees(double)double)");
        this.th.check(Math.toDegrees(0.0), 0.0, "0.0 --> 0.0");
        this.th.check(Math.toDegrees(-0.0), -0.0, "-0.0 --> -0.0");
        this.th.check(Math.toDegrees(Math.PI), 180.0, "PI --> 180.0");
        this.th.check(Math.toDegrees(1.5707963267948966), 90.0, "PI/2 --> 90.0");
        this.th.check(Math.toDegrees(0.7853981633974483), 45.0, "PI --> 45.0");
        this.th.check(Math.toDegrees(1.0471975511965976), 59.99999999999999, "PI/3 -->60.0");
        this.th.check(Math.toDegrees(-Math.PI), -180.0, "-PI --> -180.0");
        this.th.check(Math.toDegrees(-1.5707963267948966), -90.0, "-PI/2 --> -90.0");
        this.th.check(Math.toDegrees(-0.7853981633974483), -45.0, "-PI --> -45.0");
        this.th.check(Math.toDegrees(-1.0471975511965976), -59.99999999999999, "-PI/3 -->-60.0");
        this.th.check(Math.toDegrees(3.5), 200.53522829578813, "test a number");
        this.th.check(new Double(Math.toDegrees(Double.NaN)).isNaN(), "NaN --> NaN");
        this.th.check(new Double(Math.toDegrees(Double.POSITIVE_INFINITY)).isInfinite(), "+ inf --> + inf");
        this.th.check(new Double(Math.toDegrees(Double.NEGATIVE_INFINITY)).isInfinite(), "- inf --> - inf");
    }

    public void test_toRadians() {
        this.th.checkPoint("toRadians(double)double)");
        this.th.check(Math.toRadians(30.0), 0.5235987755982988, "30.0 --> PI/6");
        this.th.check(Math.toRadians(60.0), 1.0471975511965976, "60.0 --> PI/3");
        this.th.check(Math.toRadians(90.0), 1.5707963267948966, "90.0 --> PI/2");
        this.th.check(Math.toRadians(-180.0), -Math.PI, "180.0 --> PI");
        this.th.check(Math.toRadians(-30.0), -0.5235987755982988, "-30.0 --> -PI/6");
        this.th.check(Math.toRadians(-60.0), -1.0471975511965976, "-60.0 --> -PI/3");
        this.th.check(Math.toRadians(-90.0), -1.5707963267948966, "-90.0 --> -PI/2");
        this.th.check(Math.toRadians(-180.0), -Math.PI, "-180.0 --> -PI");
        this.th.check(Math.toRadians(0.0), 0.0, "0.0 --> 0.0");
        this.th.check(Math.toRadians(-0.0), -0.0, "- 0.0 --> - 0.0");
        this.th.check(Math.toRadians(123.0), 2.1467549799530254, "test a number");
        this.th.check(new Double(Math.toRadians(Double.NaN)).isNaN(), "NaN --> NaN");
        this.th.check(new Double(Math.toRadians(Double.POSITIVE_INFINITY)).isInfinite(), "+ inf --> + inf");
        this.th.check(new Double(Math.toRadians(Double.NEGATIVE_INFINITY)).isInfinite(), "- inf --> - inf");
    }

    public void test_remainder() {
    }

    private final void cygnustest() {
        this.th.checkPoint("sin(double)double");
        boolean bl = false;
        if (Math.abs(Math.sin(1.0E50)) <= 1.0) {
            bl = true;
        }
        this.th.check(bl, "sin of large Number");
        this.th.checkPoint("cos(double)double");
        this.th.check(Math.cos(0.0), 1.0);
        this.th.check(Math.cos(Math.PI), -1.0);
        this.th.check(Math.cos(3.1415926535897933E18), 1.0, "PI E18");
        boolean bl2 = false;
        if (Math.abs(Math.cos(1.0E50)) <= 1.0) {
            bl2 = true;
        }
        this.th.check(bl2, "got: " + Math.cos(1.0E50));
        boolean bl3 = false;
        if (Math.abs(Math.cos(1.5707963267948966)) <= 1.0E-10) {
            bl3 = true;
        }
        this.th.check(bl3, "expected 0.0,but got: " + Math.cos(1.5707963267948966));
        this.th.checkPoint("max(double,double)double");
        this.th.check(Double.toString(Math.max(0.0, -0.0)), (Object)"0.0");
        this.th.check(Double.toString(Math.max(-0.0, -0.0)), (Object)"-0.0");
        this.th.check(Double.toString(Math.max(0.0, -0.0)), (Object)"0.0");
        this.th.check(Double.toString(Math.max(0.0, 0.0)), (Object)"0.0");
        this.th.check(Double.toString(Math.max(1.0, (double)2)), (Object)"2.0");
        this.th.check(Double.toString(Math.max((double)2, 1.0)), (Object)"2.0");
        this.th.check(Double.toString(Math.max(-1.0, -2.0)), (Object)"-1.0");
        this.th.check(Double.toString(Math.max(-2.0, 1.0)), (Object)"1.0");
        this.th.check(Double.toString(Math.max(1.0, -2.0)), (Object)"1.0");
        this.th.check(Double.toString(Math.max((double)2, Double.NaN)), (Object)"NaN");
        this.th.check(Double.toString(Math.max(Double.NaN, (double)2)), (Object)"NaN");
        this.th.check(Double.toString(Math.max(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)), (Object)"Infinity");
        this.th.check(Double.toString(Math.max(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY)), (Object)"Infinity");
        this.th.check(Double.toString(Math.max(Double.NEGATIVE_INFINITY, 0.0)), (Object)"0.0");
        this.th.check(Double.toString(Math.max(Double.POSITIVE_INFINITY, 0.0)), (Object)"Infinity");
        this.th.check(Double.toString(Math.max(Math.PI, 0.0)), (Object)Double.toString(Math.PI));
        this.th.checkPoint("max(float,float)float");
        this.th.check(Math.max(0.0f, -0.0f), 0.0);
        this.th.check(Math.max(-0.0f, -0.0f), -0.0);
        this.th.check(Math.max(0.0f, -0.0f), 0.0);
        this.th.check(Math.max(0.0f, 0.0f), 0.0);
        this.th.check(Math.max(1.0f, 2.0f), (double)2);
        this.th.check(Math.max(2.0f, 1.0f), (double)2);
        this.th.check(Math.max(-1.0f, -2.0f), -1.0);
        boolean bl4 = false;
        if ((double)Math.max(-2.0f, 1.0f) == 1.0) {
            bl4 = true;
        }
        this.th.check(bl4, "got: " + Math.max(-2.0f, 1.0f));
        boolean bl5 = false;
        if ((double)Math.max(1.0f, -2.0f) == 1.0) {
            bl5 = true;
        }
        this.th.check(bl5, "got: " + Math.max(1.0f, -2.0f));
        this.th.check(Math.max(2.0f, Float.NaN), Double.NaN);
        this.th.check(Math.max(Float.NaN, 2.0f), Double.NaN);
        this.th.check(Math.max(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY), Double.POSITIVE_INFINITY);
        this.th.check(Math.max(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY), Double.POSITIVE_INFINITY);
        this.th.check(Math.max(Float.NEGATIVE_INFINITY, 0.0f), 0.0);
        this.th.check(Math.max(Float.POSITIVE_INFINITY, 0.0f), Double.POSITIVE_INFINITY);
        this.th.check(Math.max((float)Math.PI, 0.0f), 3.1415927410125732);
        this.th.checkPoint("min(double,double)double");
        this.th.check(Math.min(0.0, -0.0), -0.0);
        this.th.check(Math.min(-0.0, -0.0), -0.0);
        this.th.check(Math.min(0.0, -0.0), -0.0);
        this.th.check(Math.min(0.0, 0.0), 0.0);
        this.th.check(Math.min(1.0, (double)2), 1.0);
        this.th.check(Math.min((double)2, 1.0), 1.0);
        this.th.check(Math.min(-1.0, -2.0), -2.0);
        this.th.check(Math.min(-2.0, 1.0), -2.0);
        this.th.check(Math.min(1.0, -2.0), -2.0);
        this.th.check(Math.min((double)2, Double.NaN), Double.NaN);
        this.th.check(Math.min(Double.NaN, (double)2), Double.NaN);
        this.th.check(Math.min(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), Double.NEGATIVE_INFINITY);
        this.th.check(Math.min(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), Double.POSITIVE_INFINITY);
        this.th.check(Math.min(Double.NEGATIVE_INFINITY, 0.0), Double.NEGATIVE_INFINITY);
        this.th.check(Math.min(Double.POSITIVE_INFINITY, 0.0), 0.0);
        this.th.check(Math.max(Math.PI, 0.0), Math.PI);
        this.th.checkPoint("min(float,float)float");
        this.th.check(Math.min(0.0f, -0.0f), -0.0);
        this.th.check(Math.min(-0.0f, -0.0f), -0.0);
        this.th.check(Math.min(0.0f, -0.0f), -0.0);
        this.th.check(Math.min(0.0f, 0.0f), 0.0);
        boolean bl6 = false;
        if ((double)Math.min(1.0f, 2.0f) == 1.0) {
            bl6 = true;
        }
        this.th.check(bl6, "got: " + Math.min(1.0f, 2.0f));
        boolean bl7 = false;
        if ((double)Math.min(2.0f, 1.0f) == 1.0) {
            bl7 = true;
        }
        this.th.check(bl7, "got: " + Math.min(2.0f, 1.0f));
        this.th.check(Math.min(-1.0f, -2.0f), -2.0);
        this.th.check(Math.min(-2.0f, 1.0f), -2.0);
        this.th.check(Math.min(1.0f, -2.0f), -2.0);
        this.th.check(Math.min(2.0f, Float.NaN), Double.NaN);
        this.th.check(Math.min(Float.NaN, 2.0f), Double.NaN);
        this.th.check(Math.min(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY), Double.NEGATIVE_INFINITY);
        this.th.check(Math.min(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY), Double.POSITIVE_INFINITY);
        this.th.check(Math.min(Float.NEGATIVE_INFINITY, 0.0f), Double.NEGATIVE_INFINITY);
        this.th.check(Math.min(Float.POSITIVE_INFINITY, 0.0f), 0.0);
        this.th.check(Math.max((float)Math.PI, 0.0f), 3.1415927410125732);
        this.th.checkPoint("rint(double)double");
        this.th.check(Math.rint(-3.5), -4.0, "got: " + Math.rint(-3.5));
        this.th.check(Math.rint(4.5), (double)4, "got: " + Math.rint(4.5));
        this.th.check(Math.rint(3.5), (double)4, "got: " + Math.rint(3.5));
        this.th.check(Math.rint(-0.5), -0.0, "got: " + Math.rint(-0.5));
        this.th.check(Math.rint(-1.5), -2.0, "got: " + Math.rint(-1.5));
        this.th.check(Math.rint(5.5), 6.0, "got: " + Math.rint(5.5));
        this.th.check(Math.rint(-3.5001), -4.0, "got: " + Math.rint(-3.5001));
        this.th.check(Math.rint(4.4999), (double)4, "got: " + Math.rint(4.4999));
        this.th.check(Math.rint(3.5001), (double)4, "got: " + Math.rint(3.5001));
        this.th.check(Math.rint(-0.5001), -1.0, "got: " + Math.rint(-0.5001));
        this.th.check(Math.rint(-1.50001), -2.0, "got: " + Math.rint(-1.50001));
        this.th.check(Math.rint(5.500001), 6.0, "got: " + Math.rint(5.500001));
        this.th.check(Math.rint(0.0), 0.0, "got: " + Math.rint(0.0));
        this.th.check(Math.rint(-0.0), -0.0, "got: " + Math.rint(-0.0));
        this.th.check(Math.rint(Double.NaN), Double.NaN, "got: " + Math.rint(Double.NaN));
        this.th.check(Math.rint(Double.POSITIVE_INFINITY), Double.POSITIVE_INFINITY, "got: " + Math.rint(Double.POSITIVE_INFINITY));
        this.th.check(Math.rint(Double.NEGATIVE_INFINITY), Double.NEGATIVE_INFINITY, "got: " + Math.rint(Double.NEGATIVE_INFINITY));
        this.th.checkPoint("floor(double)double");
        this.th.check(Math.floor(-3.5), -4.0, "got: " + Math.floor(-3.5));
        this.th.check(Math.floor(4.5), (double)4, "got: " + Math.floor(4.5));
        this.th.check(Math.floor(3.5), (double)3, "got: " + Math.floor(3.5));
        this.th.check(Math.floor(-0.5), -1.0, "got: " + Math.floor(-0.5));
        this.th.check(Math.floor(0.5), 0.0, "got: " + Math.floor(-0.5));
        this.th.check(Math.floor(-1.5), -2.0, "got: " + Math.floor(-1.5));
        this.th.check(Math.floor(5.5), (double)5, "got: " + Math.floor(5.5));
        this.th.check(Math.floor(-3.5001), -4.0, "got: " + Math.floor(-3.5001));
        this.th.check(Math.floor(4.9999), (double)4, "got: " + Math.floor(4.9999));
        this.th.check(Math.floor(3), (double)3, "got: " + Math.floor(3));
        this.th.check(Math.floor(-3.0), -3.0, "got: " + Math.floor(-3.0));
        this.th.check(Math.floor(-1.50001), -2.0, "got: " + Math.floor(-1.50001));
        this.th.check(Math.floor(5.500001), (double)5, "got: " + Math.floor(5.500001));
        this.th.check(Math.floor(0.0), 0.0, "got: " + Math.floor(0.0));
        this.th.check(Math.floor(-0.0), -0.0, "got: " + Math.floor(-0.0));
        this.th.check(Math.floor(Double.NaN), Double.NaN, "got: " + Math.floor(Double.NaN));
        this.th.check(Math.floor(Double.POSITIVE_INFINITY), Double.POSITIVE_INFINITY, "got: " + Math.floor(Double.POSITIVE_INFINITY));
        this.th.check(Math.floor(Double.NEGATIVE_INFINITY), Double.NEGATIVE_INFINITY, "got: " + Math.floor(Double.NEGATIVE_INFINITY));
        this.th.checkPoint("ceil(double)double");
        this.th.check(Math.ceil(-3.5), -3.0, "got: " + Math.ceil(-3.5));
        this.th.check(Math.ceil(4.5), (double)5, "got: " + Math.ceil(4.5));
        this.th.check(Math.ceil(3.5), (double)4, "got: " + Math.ceil(3.5));
        this.th.check(Math.ceil(-0.5), -0.0, "got: " + Math.ceil(-0.5));
        this.th.check(Math.ceil(-1.5), -1.0, "got: " + Math.ceil(-1.5));
        this.th.check(Math.ceil(5.5), 6.0, "got: " + Math.ceil(5.5));
        this.th.check(Math.ceil(-3.999999), -3.0, "got: " + Math.ceil(-3.999999));
        this.th.check(Math.ceil(4), (double)4, "got: " + Math.ceil(4));
        this.th.check(Math.ceil(-3.0), -3.0, "got: " + Math.ceil(-3.0));
        this.th.check(Math.ceil(0.0), 0.0, "got: " + Math.ceil(0.0));
        this.th.check(Math.ceil(-0.0), -0.0, "got: " + Math.ceil(-0.0));
        this.th.check(Math.ceil(Double.NaN), Double.NaN, "got: " + Math.ceil(Double.NaN));
        this.th.check(Math.ceil(Double.POSITIVE_INFINITY), Double.POSITIVE_INFINITY, "got: " + Math.ceil(Double.POSITIVE_INFINITY));
        this.th.check(Math.ceil(Double.NEGATIVE_INFINITY), Double.NEGATIVE_INFINITY, "got: " + Math.ceil(Double.NEGATIVE_INFINITY));
    }
}

