/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Float;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class FloatTest
implements Testlet {
    protected static TestHarness harness;

    public void testConstructors() {
        harness.checkPoint("Float(float)");
        String msg = "Float == /Float.equals() ";
        Float a = new Float(0.0f);
        Float b = new Float(110.0f);
        Float c = new Float(0.0f);
        Float d = a;
        Float e = new Float(110.0f);
        Float f = new Float(-2200.0f);
        Float g = new Float(-0.0f);
        Integer i = new Integer(0);
        boolean bl = false;
        if (a != null) {
            bl = true;
        }
        harness.check(bl, msg);
        harness.check(a.equals(null) ^ true, msg);
        boolean bl2 = false;
        if (a != b) {
            bl2 = true;
        }
        harness.check(bl2, msg);
        harness.check(a.equals(b) ^ true, msg);
        boolean bl3 = false;
        if (a != c) {
            bl3 = true;
        }
        harness.check(bl3, msg);
        harness.check(a.equals(c), msg);
        boolean bl4 = false;
        if (a == d) {
            bl4 = true;
        }
        harness.check(bl4, msg);
        harness.check(a.equals(d), msg);
        boolean bl5 = false;
        if (a == a) {
            bl5 = true;
        }
        harness.check(bl5, msg);
        harness.check(a.equals(i) ^ true, msg);
        harness.check(b.equals(e), msg);
        harness.checkPoint("floatValue()float");
        harness.check(a.floatValue(), 0.0);
        harness.check(a.floatValue(), a.floatValue());
        harness.check(a.floatValue(), c.floatValue());
        harness.check(a.floatValue(), d.floatValue());
        harness.check((int)a.floatValue(), i);
        harness.check(b.floatValue(), 110.0);
        harness.check(b.floatValue(), 110.0);
        harness.check(f.floatValue(), -2200.0);
        harness.check(true);
        harness.check(true);
        harness.checkPoint("Float(double)");
        Float fmax = new Float(Double.POSITIVE_INFINITY);
        Float fmin = new Float(0.0);
        Float hmax = new Float((double)Double.MAX_VALUE);
        Float hmin = new Float((double)Double.MIN_VALUE);
        harness.check(fmax.floatValue(), Double.POSITIVE_INFINITY);
        harness.check(fmin.floatValue(), 0.0);
        harness.check(hmax.floatValue(), Double.POSITIVE_INFINITY);
        harness.check(hmin.floatValue(), 0.0);
        Float h1 = new Float(110.0f);
        Float h2 = new Float(110.0f);
        Float h3 = new Float(110.0);
        Float h4 = new Float(110.0);
        Float h5 = new Float(110.0);
        harness.check(h1.floatValue(), 110.0);
        harness.check(h2.floatValue(), 110.0);
        harness.check(h3.floatValue(), 110.0);
        harness.check(h4.floatValue(), 110.0);
        harness.check(h5.floatValue(), 110.0);
        harness.checkPoint("Float(float)");
        msg = "Minimum and maximum values";
        harness.check(Double.NaN, Double.NaN, msg);
        harness.check(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, msg);
        harness.check(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, msg);
        harness.checkPoint("Float(java.lang.String)");
        this.constructMustSucceed("1", 1.0f);
        this.constructMustSucceed("1.0", 1.0f);
        this.constructMustSucceed("1e2", 100.0f);
        this.constructMustSucceed("1.02e2", 102.0f);
        this.constructMustSucceed("1.02e2f", 102.0f);
        this.constructMustSucceed("-10.2 ", -10.2f);
        this.constructMustSucceed("10.2e3", 10200.0f);
        this.constructMustSucceed("-10.2e3 ", -10200.0f);
        this.constructMustSucceed("10.2e-4", 0.00102f);
        this.constructMustSucceed("-10.2e-4 ", -0.00102f);
        this.constructMustSucceed("-10.2e-4 ", -0.00102f);
        this.constructMustSucceed(".2", 0.2f);
        this.constructMustSucceed(".2e3", 200.0f);
        this.constructMustSucceed(".2e-4", 2.0E-5f);
        this.constructMustSucceed("-.2", -0.2f);
        this.constructMustSucceed("-.2e3", -200.0f);
        this.constructMustSucceed("-.2e-4", -2.0E-5f);
        msg = "float/double endings";
        this.constructMustSucceed("1.02e2f", 102.0f);
        this.constructMustSucceed("1.02e2F", 102.0f);
        this.constructMustSucceed("1.02e2d", 102.0f);
        this.constructMustSucceed("1.02e2D", 102.0f);
        this.constructMustSucceed(" 110.0  ", 110.0f);
        this.constructMustFail("0x77");
        this.constructMustFail("#77");
        this.constructMustFail("4a");
        this.constructMustFail("0x4a");
        this.constructMustFail("#4a");
        harness.checkPoint("Float(java.lang.String)");
        this.constructMustFail(" ");
        this.constructMustFail("");
        this.constructMustFail(null);
    }

    private final void constructMustSucceed(String line, float expected) {
        try {
            Float constructed = new Float(line);
            harness.check(constructed.floatValue(), expected);
        }
        catch (NumberFormatException e) {
            harness.fail("Could not construct desired value <" + line + '>');
        }
    }

    private final void constructMustFail(String line) {
        try {
            new Float(line);
            harness.fail("Attempt to construct out-of-range float < " + line + " > ");
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testf2d() {
        harness.checkPoint("test float to double");
        Float fg = new Float(1.0f);
        boolean bl = false;
        if (Math.abs(fg.doubleValue() - 1.0) < 1.0E-4) {
            bl = true;
        }
        harness.check(bl, "got: " + fg.doubleValue() + ", but exp.: 1.0");
        fg = new Float(-1.0f);
        boolean bl2 = false;
        if (fg.doubleValue() == -1.0) {
            bl2 = true;
        }
        harness.check(bl2, "got: " + fg.doubleValue() + ", but exp.: -1.0");
        fg = new Float(10.0f);
        boolean bl3 = false;
        if (fg.doubleValue() == 10.0) {
            bl3 = true;
        }
        harness.check(bl3, "got: " + fg.doubleValue() + ", but exp.: 10.0");
        fg = new Float(-10.0f);
        boolean bl4 = false;
        if (fg.doubleValue() == -10.0) {
            bl4 = true;
        }
        harness.check(bl4, "got: " + fg.doubleValue() + ", but exp.: -10.0");
        fg = new Float(0.5f);
        boolean bl5 = false;
        if (fg.doubleValue() == 0.5) {
            bl5 = true;
        }
        harness.check(bl5, "got: " + fg.doubleValue() + ", but exp.: 0.5");
        fg = new Float(-0.5f);
        boolean bl6 = false;
        if (fg.doubleValue() == -0.5) {
            bl6 = true;
        }
        harness.check(bl6, "got: " + fg.doubleValue() + ", but exp.: -0.5");
        fg = new Float(1.01f);
        boolean bl7 = false;
        if (Math.abs(fg.doubleValue() - 1.01) < 1.0E-4) {
            bl7 = true;
        }
        harness.check(bl7, "got: " + fg.doubleValue() + ", but exp.: 1.01");
        fg = new Float(-1.01f);
        boolean bl8 = false;
        if (Math.abs(fg.doubleValue() + 1.01) < 1.0E-4) {
            bl8 = true;
        }
        harness.check(bl8, "got: " + fg.doubleValue() + ", but exp.: -1.01");
        fg = new Float(0.05f);
        boolean bl9 = false;
        if (Math.abs(fg.doubleValue() - 0.05) < 1.0E-4) {
            bl9 = true;
        }
        harness.check(bl9, "got: " + fg.doubleValue() + ", but exp.: 0.05");
        fg = new Float(-0.05f);
        boolean bl10 = false;
        if (Math.abs(fg.doubleValue() + 0.05) < 1.0E-4) {
            bl10 = true;
        }
        harness.check(bl10, "got: " + fg.doubleValue() + ", but exp.: -0.05");
        fg = new Float(0.01f);
        boolean bl11 = false;
        if (Math.abs(fg.doubleValue() - 0.01) < 1.0E-4) {
            bl11 = true;
        }
        harness.check(bl11, "got: " + fg.doubleValue() + ", but exp.: 0.01");
        fg = new Float(-0.01f);
        boolean bl12 = false;
        if (Math.abs(fg.doubleValue() + 0.01) < 1.0E-4) {
            bl12 = true;
        }
        harness.check(bl12, "got: " + fg.doubleValue() + ", but exp.: -0.01");
        fg = new Float(0.005f);
        boolean bl13 = false;
        if (Math.abs(fg.doubleValue() - 0.005) < 1.0E-5) {
            bl13 = true;
        }
        harness.check(bl13, "got: " + fg.doubleValue() + ", but exp.: 0.005");
        fg = new Float(-0.005f);
        boolean bl14 = false;
        if (Math.abs(fg.doubleValue() + 0.005) < 1.0E-5) {
            bl14 = true;
        }
        harness.check(bl14, "got: " + fg.doubleValue() + ", but exp.: -0.005");
        fg = new Float(0.25f);
        boolean bl15 = false;
        if (Math.abs(fg.doubleValue() - 0.25) < 1.0E-5) {
            bl15 = true;
        }
        harness.check(bl15, "got: " + fg.doubleValue() + ", but exp.: 0.25");
        fg = new Float(-0.25f);
        boolean bl16 = false;
        if (Math.abs(fg.doubleValue() + 0.25) < 1.0E-5) {
            bl16 = true;
        }
        harness.check(bl16, "got: " + fg.doubleValue() + ", but exp.: -0.25");
        fg = new Float(Float.NaN);
        harness.check(new Double(fg.doubleValue()).isNaN(), "got: " + fg.doubleValue() + ", but exp.: NaN");
        fg = new Float(Float.POSITIVE_INFINITY);
        boolean bl17 = false;
        if (fg.doubleValue() == Double.POSITIVE_INFINITY) {
            bl17 = true;
        }
        harness.check(bl17, "got: " + fg.doubleValue() + ", but exp.: Infinity");
        fg = new Float(Float.NEGATIVE_INFINITY);
        boolean bl18 = false;
        if (fg.doubleValue() == Double.NEGATIVE_INFINITY) {
            bl18 = true;
        }
        harness.check(bl18, "got: " + fg.doubleValue() + ", but exp.: -Infinity");
        fg = new Float(0.0f);
        boolean bl19 = false;
        if (fg.doubleValue() == 0.0) {
            bl19 = true;
        }
        harness.check(bl19, "got: " + fg.doubleValue() + ", but exp.: 0.0");
    }

    public void testInfiniteValues() {
        Float positive = new Float(Float.POSITIVE_INFINITY);
        Float negative = new Float(Float.NEGATIVE_INFINITY);
        Float undefined = new Float(Float.NaN);
        Float thirds = new Float(-0.33333334f);
        harness.checkPoint("isInfinite()boolean");
        harness.check(positive.isInfinite());
        harness.check(negative.isInfinite());
        harness.check(undefined.isInfinite() ^ true, "got: " + undefined.floatValue());
        harness.check(thirds.isInfinite() ^ true);
        harness.checkPoint("isNaN()boolean");
        harness.check(positive.isNaN() ^ true);
        harness.check(negative.isNaN() ^ true);
        harness.check(undefined.isNaN());
        harness.check(thirds.isNaN() ^ true);
        harness.checkPoint("isInfinite(float)boolean");
        harness.check(Float.isInfinite(Float.POSITIVE_INFINITY));
        harness.check(Float.isInfinite(Float.NEGATIVE_INFINITY));
        harness.check(Float.isInfinite(Float.NaN) ^ true, "got: " + undefined.floatValue());
        harness.check(Float.isInfinite(0.33333334f) ^ true);
        harness.checkPoint("isNaN(float)boolean");
        harness.check(Float.isNaN(Float.POSITIVE_INFINITY) ^ true);
        harness.check(Float.isNaN(Float.NEGATIVE_INFINITY) ^ true);
        harness.check(Float.isNaN(0.33333334f) ^ true);
        harness.check(Float.isNaN(Float.NaN));
    }

    public void testCompare() {
        Float f;
        harness.checkPoint("compareTo(java.lang.Object)int");
        this.checkCompare(10.0f, 10.1f);
        this.checkCompare(0.0f, 10.1f);
        this.checkCompare(-10.1f, -10.0f);
        this.checkCompare(-10.0f, 0.0f);
        this.checkCompare(-10.1f, 10.0f);
        try {
            Integer cha1 = new Integer(-9359);
            boolean bl = false;
            if (cha1.compareTo(new Integer(-9359)) == 0) {
                bl = true;
            }
            harness.check(bl);
        }
        catch (ClassCastException e) {
            harness.fail("Exception comparing two instances of class Byte ");
        }
        try {
            Integer i = new Integer(50);
            f = new Float(50.0f);
            f.compareTo(i);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
        try {
            Double d = new Double(50.0);
            f = new Float(50.0f);
            f.compareTo(d);
            harness.fail("Attempt to compare two different objects ");
        }
        catch (ClassCastException e) {
            harness.check(true);
        }
    }

    private final void checkCompare(float smallvalue, float bigvalue) {
        try {
            Float smallfloat = new Float(smallvalue);
            Float bigfloat = new Float(bigvalue);
            if (smallfloat.compareTo(bigfloat) > 0) {
                harness.fail("compareTo detected <" + smallvalue + "> bigger then <" + bigvalue + '>');
            } else if (smallfloat.compareTo(bigfloat) == 0) {
                harness.fail("compareTo detected <" + smallvalue + "> equal to <" + bigvalue + '>');
            } else {
                harness.check(true);
            }
            if (bigfloat.compareTo(smallfloat) < 0) {
                harness.fail("compareTo detected <" + bigvalue + "> smaller then <" + smallvalue + '>');
            } else if (bigfloat.compareTo(smallfloat) == 0) {
                harness.fail("compareTo detected <" + bigvalue + "> equal to <" + smallvalue + '>');
            } else {
                harness.check(true);
            }
            if (smallfloat.compareTo(smallfloat) != 0) {
                harness.fail("compareTo detected <" + smallvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
            if (bigfloat.compareTo(bigfloat) != 0) {
                harness.fail("compareTo detected <" + bigvalue + "> not equal to itselves");
            } else {
                harness.check(true);
            }
        }
        catch (Exception e) {
            harness.fail("Exception while comparing <" + smallvalue + "> and <" + bigvalue + '>');
        }
    }

    public void testStringConversion() {
        harness.checkPoint("toString(float)java.lang.String");
        float zerofloat = 0.0f;
        float negzerofloat = -0.0f;
        Float zero = new Float(0.0f);
        Float negzero = new Float(negzerofloat);
        Float posinfinite = new Float(Double.POSITIVE_INFINITY);
        Float neginfinite = new Float(Double.NEGATIVE_INFINITY);
        Float undefined = new Float(Double.NaN);
        Float biggermax = new Float(Float.POSITIVE_INFINITY);
        Float smallermin = new Float(0.0f);
        Float nbiggermax = new Float(Float.NEGATIVE_INFINITY);
        Float nsmallermin = new Float(-0.0f);
        harness.checkPoint("toString()java.lang.String");
        harness.check(zero.toString(), (Object)"0.0");
        harness.check(Float.toString(zerofloat), (Object)"0.0");
        harness.check(negzero.toString(), (Object)"-0.0");
        harness.check(Float.toString(negzerofloat), (Object)"-0.0");
        harness.check(posinfinite.toString(), (Object)"Infinity");
        harness.check(Float.toString(Float.POSITIVE_INFINITY), (Object)"Infinity");
        harness.check(neginfinite.toString(), (Object)"-Infinity");
        harness.check(Float.toString(Float.NEGATIVE_INFINITY), (Object)"-Infinity");
        harness.check(undefined.toString(), (Object)"NaN");
        harness.check(Float.toString(Float.NaN), (Object)"NaN");
        harness.check(biggermax.toString(), (Object)"Infinity");
        harness.check(nbiggermax.toString(), (Object)"-Infinity");
        harness.check(smallermin.toString(), (Object)"0.0");
        harness.check(nsmallermin.toString(), (Object)"-0.0");
        harness.check(Float.toString(Float.POSITIVE_INFINITY), (Object)"Infinity");
        harness.check(Float.toString(Float.NEGATIVE_INFINITY), (Object)"-Infinity");
        harness.check(Float.toString(0.0f), (Object)"0.0");
        harness.check(Float.toString(-0.0f), (Object)"-0.0");
        Float f = new Float(6000000.0f);
        harness.check(f.toString(), (Object)"6000000.0");
        harness.check(Float.toString(6000000.0f), (Object)"6000000.0");
        f = new Float(-4500000.0f);
        harness.check(f.toString(), (Object)"-4500000.0");
        harness.check(Float.toString(-4500000.0f), (Object)"-4500000.0");
        f = new Float(9999999.0f);
        harness.check(f.toString(), (Object)"9999999.0");
        harness.check(Float.toString(9999999.0f), (Object)"9999999.0");
        f = new Float(-9999999.0f);
        harness.check(f.toString(), (Object)"-9999999.0");
        harness.check(Float.toString(-9999999.0f), (Object)"-9999999.0");
        f = new Float(0.00101f);
        harness.check(f.toString(), (Object)"0.00101");
        harness.check(Float.toString(0.00101f), (Object)"0.00101");
        f = new Float(-0.00101f);
        harness.check(f.toString(), (Object)"-0.00101");
        harness.check(Float.toString(-0.00101f), (Object)"-0.00101");
        f = new Float(0.001f);
        harness.check(f.toString(), (Object)"0.001");
        harness.check(Float.toString(0.001f), (Object)"0.001");
        f = new Float(800000.1f);
        harness.check(f.toString().startsWith("800000."));
        harness.check(Float.toString(800000.1f).startsWith("800000."));
        f = new Float(-100000.2f);
        harness.check(f.toString(), (Object)"-100000.2");
        harness.check(Float.toString(-100000.2f), (Object)"-100000.2");
        f = new Float(1.0E7f);
        harness.check(f.toString(), (Object)"1.0E7");
        harness.check(Float.toString(1.0E7f), (Object)"1.0E7");
        f = new Float(-1.0E7f);
        harness.check(f.toString(), (Object)"-1.0E7");
        harness.check(Float.toString(-1.0E7f), (Object)"-1.0E7");
        f = new Float(9.9E-4f);
        boolean bl = false;
        if (f.toString().endsWith("E-4") && f.toString().startsWith("9.")) {
            bl = true;
        }
        harness.check(bl, "9.9E-4");
        f = new Float(-9.9E-4f);
        boolean bl2 = false;
        if (f.toString().endsWith("E-4") && f.toString().startsWith("-9.")) {
            bl2 = true;
        }
        harness.check(bl2, "-9.9E-4");
        f = new Float(0.001f);
        harness.check(f.toString().equals("1E-3") ^ true);
        harness.check(Float.toString(0.001f).equals("1E-3") ^ true);
    }

    public void testIntbitsRepresentation() {
        harness.checkPoint("intBitsToFloat(int)float");
        int i = 1234;
        float f = 123.45f;
        harness.check(Float.floatToIntBits(Float.intBitsToFloat(i)), i);
        harness.check(Float.intBitsToFloat(Float.floatToIntBits(f)), f);
        harness.check(Float.floatToIntBits(Float.intBitsToFloat(Integer.MAX_VALUE)), Integer.MAX_VALUE);
        harness.check(Float.floatToIntBits(Float.intBitsToFloat(Integer.MIN_VALUE)), Integer.MIN_VALUE);
        harness.check(Float.intBitsToFloat(Integer.MIN_VALUE), -0.0);
        harness.check(Float.intBitsToFloat(0), 0.0);
        f = Float.POSITIVE_INFINITY;
        i = 2139095040;
        harness.check(Float.intBitsToFloat(i), f);
        harness.check(Float.floatToIntBits(f), i);
        f = Float.NEGATIVE_INFINITY;
        i = -8388608;
        harness.check(Float.intBitsToFloat(i), f);
        harness.check(Float.floatToIntBits(f), i);
        f = Float.MAX_VALUE;
        i = 0x7F7FFFFF;
        harness.check(Float.intBitsToFloat(i), f);
        harness.check(Float.floatToIntBits(f), i);
        f = Float.MIN_VALUE;
        i = 1;
        harness.check(Float.intBitsToFloat(i), f);
        harness.check(Float.floatToIntBits(f), i);
        f = Float.NaN;
        i = 2143289344;
        harness.check(Float.intBitsToFloat(i), f);
        harness.check(Float.floatToIntBits(f), i);
        harness.debug("NaN = " + Integer.toHexString(Float.floatToIntBits(f)) + ", but should be 0x7fc00000");
        harness.check(Float.intBitsToFloat(2139095041), Double.NaN);
        harness.check(Float.intBitsToFloat(2140847326), Double.NaN);
        harness.check(Float.intBitsToFloat(Integer.MAX_VALUE), Double.NaN);
        harness.check(Float.intBitsToFloat(-8388607), Double.NaN);
        harness.check(Float.intBitsToFloat(-6636322), Double.NaN);
        harness.check(Float.intBitsToFloat(-1), Double.NaN);
    }

    public void testStringValueParsing() {
        harness.checkPoint("valueOf(java.lang.String)java.lang.Float");
        this.parseCheckMustSucceed("100.0", 100.0f);
        this.valueCheckMustSucceed("100.0", 100.0f);
        this.parseCheckMustSucceed("100", 100.0f);
        this.valueCheckMustSucceed("100", 100.0f);
        this.parseCheckMustSucceed("1e2", 100.0f);
        this.valueCheckMustSucceed("1e2", 100.0f);
        this.parseCheckMustSucceed("-100.0", -100.0f);
        this.valueCheckMustSucceed("-100.0", -100.0f);
        this.parseCheckMustSucceed("-100", -100.0f);
        this.valueCheckMustSucceed("-100", -100.0f);
        this.parseCheckMustSucceed("-1e2", -100.0f);
        this.valueCheckMustSucceed("-1e2", -100.0f);
        this.parseCheckMustSucceed("1100.51", 1100.51f);
        this.valueCheckMustSucceed("1100.51", 1100.51f);
        this.parseCheckMustSucceed("1100.510", 1100.51f);
        this.valueCheckMustSucceed("1100.510", 1100.51f);
        this.parseCheckMustSucceed("110.051e1", 1100.51f);
        this.valueCheckMustSucceed("110.051e1", 1100.51f);
        this.parseCheckMustSucceed("11.0051e2", 1100.51f);
        this.valueCheckMustSucceed("11.0051e2", 1100.51f);
        this.parseCheckMustSucceed("1.10051e3", 1100.51f);
        this.valueCheckMustSucceed("1.10051e3", 1100.51f);
        this.parseCheckMustSucceed("0.110051e4", 1100.51f);
        this.valueCheckMustSucceed("0.110051e4", 1100.51f);
        this.parseCheckMustSucceed("-1100.51", -1100.51f);
        this.valueCheckMustSucceed("-1100.51", -1100.51f);
        this.parseCheckMustSucceed("-1100.510", -1100.51f);
        this.valueCheckMustSucceed("-1100.510", -1100.51f);
        this.parseCheckMustSucceed("-110.051e1", -1100.51f);
        this.valueCheckMustSucceed("-110.051e1", -1100.51f);
        this.parseCheckMustSucceed("-11.0051e2", -1100.51f);
        this.valueCheckMustSucceed("-11.0051e2", -1100.51f);
        this.parseCheckMustSucceed("-1.10051e3", -1100.51f);
        this.valueCheckMustSucceed("-1.10051e3", -1100.51f);
        this.parseCheckMustSucceed("-0.110051e4", -1100.51f);
        this.valueCheckMustSucceed("-0.110051e4", -1100.51f);
        this.parseCheckMustSucceed("0.00512", 0.00512f);
        this.valueCheckMustSucceed("0.00512", 0.00512f);
        this.parseCheckMustSucceed("0.0051200", 0.00512f);
        this.valueCheckMustSucceed("0.0051200", 0.00512f);
        this.parseCheckMustSucceed("0.0512e-1", 0.00512f);
        this.valueCheckMustSucceed("0.0512e-1", 0.00512f);
        this.parseCheckMustSucceed("0.512e-2", 0.00512f);
        this.valueCheckMustSucceed("0.512e-2", 0.00512f);
        this.parseCheckMustSucceed("5.12e-3", 0.00512f);
        this.valueCheckMustSucceed("5.12e-3", 0.00512f);
        this.parseCheckMustSucceed("512e-5", 0.00512f);
        this.valueCheckMustSucceed("512e-5", 0.00512f);
        this.parseCheckMustSucceed("51200e-7", 0.00512f);
        this.valueCheckMustSucceed("51200e-7", 0.00512f);
        this.parseCheckMustSucceed("-0.00512", -0.00512f);
        this.valueCheckMustSucceed("-0.00512", -0.00512f);
        this.parseCheckMustSucceed("-0.0051200", -0.00512f);
        this.valueCheckMustSucceed("-0.0051200", -0.00512f);
        this.parseCheckMustSucceed("-0.0512e-1", -0.00512f);
        this.valueCheckMustSucceed("-0.0512e-1", -0.00512f);
        this.parseCheckMustSucceed("-0.512e-2", -0.00512f);
        this.valueCheckMustSucceed("-0.512e-2", -0.00512f);
        this.parseCheckMustSucceed("-5.12e-3", -0.00512f);
        this.valueCheckMustSucceed("-5.12e-3", -0.00512f);
        this.parseCheckMustSucceed("-512e-5", -0.00512f);
        this.valueCheckMustSucceed("-512e-5", -0.00512f);
        this.parseCheckMustSucceed("-51200e-7", -0.00512f);
        this.valueCheckMustSucceed("-51200e-7", -0.00512f);
        this.parseCheckMustSucceed("11.51", 11.51f);
        this.valueCheckMustSucceed("11.51", 11.51f);
        this.parseCheckMustSucceed("1151e-2", 11.51f);
        this.valueCheckMustSucceed("1151e-2", 11.51f);
        this.parseCheckMustSucceed("115100e-4", 11.51f);
        this.valueCheckMustSucceed("115100e-4", 11.51f);
        this.parseCheckMustSucceed("0.1151e2", 11.51f);
        this.valueCheckMustSucceed("0.1151e2", 11.51f);
        this.parseCheckMustSucceed("0.001151e4", 11.51f);
        this.valueCheckMustSucceed("0.001151e4", 11.51f);
        harness.checkPoint("parseFloat(java.lang.String)float");
        this.parseCheckMustSucceed("11.51f", 11.51f);
        this.valueCheckMustSucceed("11.51f", 11.51f);
        this.parseCheckMustSucceed("11.51F", 11.51f);
        this.valueCheckMustSucceed("11.51F", 11.51f);
        this.parseCheckMustSucceed("11.51d", 11.51f);
        this.valueCheckMustSucceed("11.51d", 11.51f);
        this.parseCheckMustSucceed("11.51D", 11.51f);
        this.valueCheckMustSucceed("11.51D", 11.51f);
        this.parseCheckMustSucceed("  11.51   ", 11.51f);
        this.valueCheckMustSucceed("  11.51   ", 11.51f);
        this.parseCheckMustFail(" ");
        this.valueCheckMustFail(" ");
        this.parseCheckMustFail("");
        this.valueCheckMustFail("");
        this.parseCheckMustFail(null);
        this.valueCheckMustFail(null);
        this.parseCheckMustFail("abc");
        this.valueCheckMustFail("abc");
        this.parseCheckMustFail("100.0.1");
        this.valueCheckMustFail("100.0.1");
        this.parseCheckMustFail("100. 01");
        this.valueCheckMustFail("100. 01");
        this.parseCheckMustFail("10 0.01");
        this.valueCheckMustFail("10 0.01");
        this.parseCheckMustFail("4.0 e5");
        this.valueCheckMustFail("4.0 e5");
        this.parseCheckMustSucceed("3.401E38", 3.401E38f);
        this.valueCheckMustSucceed("3.401E38", 3.401E38f);
        this.parseCheckMustSucceed("3.4028235E38", Float.MAX_VALUE);
        this.valueCheckMustSucceed("3.4028235E38", Float.MAX_VALUE);
        this.parseCheckMustSucceed("3.403E38", Float.POSITIVE_INFINITY);
        this.valueCheckMustSucceed("3.403E38", Float.POSITIVE_INFINITY);
        this.parseCheckMustSucceed("-3.401E38", -3.401E38f);
        this.valueCheckMustSucceed("-3.401E38", -3.401E38f);
        this.parseCheckMustSucceed("-3.4028235E38", -3.4028235E38f);
        this.valueCheckMustSucceed("-3.4028235E38", -3.4028235E38f);
        this.parseCheckMustSucceed("-3.403E38", Float.NEGATIVE_INFINITY);
        this.valueCheckMustSucceed("-3.403E38", Float.NEGATIVE_INFINITY);
        this.parseCheckMustSucceed("1.7E-45", Float.MIN_VALUE);
        this.valueCheckMustSucceed("1.7E-45", Float.MIN_VALUE);
        this.parseCheckMustSucceed("1.4E-45", Float.MIN_VALUE);
        this.valueCheckMustSucceed("1.4E-45", Float.MIN_VALUE);
        this.parseCheckMustSucceed("1.0E-46", 0.0f);
        this.valueCheckMustSucceed("1.0E-46", 0.0f);
        this.parseCheckMustSucceed("-1.7E-45", -1.4E-45f);
        this.valueCheckMustSucceed("-1.7E-45", -1.4E-45f);
        this.parseCheckMustSucceed("-1.4E-45", -1.4E-45f);
        this.valueCheckMustSucceed("-1.4E-45", -1.4E-45f);
        this.parseCheckMustSucceed("-1.0E-46", -0.0f);
        this.valueCheckMustSucceed("-1.0E-46", -0.0f);
    }

    private final void parseCheckMustSucceed(String line, float target) {
        try {
            float decoded = Float.parseFloat(line);
            if (decoded == target) {
                harness.check(true);
            } else {
                harness.fail("Decoded <" + line + "> into " + decoded + " instead of " + target);
                harness.debug("decoded " + Integer.toHexString(Float.floatToIntBits(decoded)));
                harness.debug("target " + Integer.toHexString(Float.floatToIntBits(target)));
            }
        }
        catch (Exception e) {
            harness.fail("Exception while decoding float string <" + line + '>');
        }
    }

    private final void valueCheckMustSucceed(String line, float target) {
        try {
            Float decodedFloat = Float.valueOf(line);
            float decoded = decodedFloat.floatValue();
            if (decoded == target) {
                harness.check(true);
            } else {
                harness.fail("ValueOf Decoded <" + line + "> into " + decoded + " instead of " + target);
                harness.debug("decoded " + Integer.toHexString(Float.floatToIntBits(decoded)));
                harness.debug("target " + Integer.toHexString(Float.floatToIntBits(target)));
            }
        }
        catch (Exception e) {
            harness.fail("Exception while decoding float string <" + line + '>');
        }
    }

    private final void parseCheckMustFail(String line) {
        try {
            Float.parseFloat(line);
            harness.fail("Attempt to parse illegal float string <" + line + '>');
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    private final void valueCheckMustFail(String line) {
        try {
            Float.valueOf(line);
            harness.fail("Attempt to get value from illegal float string <" + line + '>');
        }
        catch (Exception e) {
            harness.check(true);
        }
    }

    public void testValueConversion() {
        Float zero = new Float(0.0);
        Float afloat = new Float(97.0f);
        Float fvalue1 = new Float(30.0f);
        Float fvalue2 = new Float(123.45f);
        Float fvalue3 = new Float(400.35f);
        Float fvalue4 = new Float(-23.45f);
        Float fvalue5 = new Float(3.3E38f);
        Float fvalue6 = new Float(3.4E100);
        harness.checkPoint("Value conversins");
        boolean bl = false;
        if (zero.byteValue() == 0) {
            bl = true;
        }
        harness.check(bl);
        boolean bl2 = false;
        if (afloat.byteValue() == 97) {
            bl2 = true;
        }
        harness.check(bl2);
        boolean bl3 = false;
        if (fvalue1.byteValue() == 30) {
            bl3 = true;
        }
        harness.check(bl3);
        boolean bl4 = false;
        if (fvalue2.byteValue() == 123) {
            bl4 = true;
        }
        harness.check(bl4);
        boolean bl5 = false;
        if (fvalue3.byteValue() == -112) {
            bl5 = true;
        }
        harness.check(bl5);
        boolean bl6 = false;
        if (fvalue4.byteValue() == -23) {
            bl6 = true;
        }
        harness.check(bl6);
        boolean bl7 = false;
        if (fvalue5.byteValue() == -1) {
            bl7 = true;
        }
        harness.check(bl7);
        boolean bl8 = false;
        if (fvalue6.byteValue() == -1) {
            bl8 = true;
        }
        harness.check(bl8);
        boolean bl9 = false;
        if (zero.shortValue() == 0) {
            bl9 = true;
        }
        harness.check(bl9);
        boolean bl10 = false;
        if (afloat.shortValue() == 97) {
            bl10 = true;
        }
        harness.check(bl10);
        boolean bl11 = false;
        if (fvalue1.shortValue() == 30) {
            bl11 = true;
        }
        harness.check(bl11);
        boolean bl12 = false;
        if (fvalue2.shortValue() == 123) {
            bl12 = true;
        }
        harness.check(bl12);
        boolean bl13 = false;
        if (fvalue3.shortValue() == 400) {
            bl13 = true;
        }
        harness.check(bl13);
        boolean bl14 = false;
        if (fvalue4.shortValue() == -23) {
            bl14 = true;
        }
        harness.check(bl14);
        boolean bl15 = false;
        if (fvalue5.shortValue() == -1) {
            bl15 = true;
        }
        harness.check(bl15);
        boolean bl16 = false;
        if (fvalue6.shortValue() == -1) {
            bl16 = true;
        }
        harness.check(bl16);
        boolean bl17 = false;
        if (zero.intValue() == 0) {
            bl17 = true;
        }
        harness.check(bl17);
        boolean bl18 = false;
        if (afloat.intValue() == 97) {
            bl18 = true;
        }
        harness.check(bl18);
        boolean bl19 = false;
        if (fvalue1.intValue() == 30) {
            bl19 = true;
        }
        harness.check(bl19);
        boolean bl20 = false;
        if (fvalue2.intValue() == 123) {
            bl20 = true;
        }
        harness.check(bl20);
        boolean bl21 = false;
        if (fvalue3.intValue() == 400) {
            bl21 = true;
        }
        harness.check(bl21);
        boolean bl22 = false;
        if (fvalue4.intValue() == -23) {
            bl22 = true;
        }
        harness.check(bl22);
        boolean bl23 = false;
        if (fvalue5.intValue() == Integer.MAX_VALUE) {
            bl23 = true;
        }
        harness.check(bl23);
        boolean bl24 = false;
        if (fvalue6.intValue() == Integer.MAX_VALUE) {
            bl24 = true;
        }
        harness.check(bl24);
        boolean bl25 = false;
        if (new Float(3456.789f).intValue() == 3456) {
            bl25 = true;
        }
        harness.check(bl25, "got: " + new Float(3456.789f).intValue() + " but exp.: 3456");
        boolean bl26 = false;
        if (zero.longValue() == 0L) {
            bl26 = true;
        }
        harness.check(bl26);
        boolean bl27 = false;
        if (afloat.longValue() == 97L) {
            bl27 = true;
        }
        harness.check(bl27);
        boolean bl28 = false;
        if (fvalue1.longValue() == 30L) {
            bl28 = true;
        }
        harness.check(bl28);
        boolean bl29 = false;
        if (fvalue2.longValue() == 123L) {
            bl29 = true;
        }
        harness.check(bl29);
        boolean bl30 = false;
        if (fvalue3.longValue() == 400L) {
            bl30 = true;
        }
        harness.check(bl30);
        boolean bl31 = false;
        if (fvalue4.longValue() == -23L) {
            bl31 = true;
        }
        harness.check(bl31);
        boolean bl32 = false;
        if (fvalue5.longValue() == Long.MAX_VALUE) {
            bl32 = true;
        }
        harness.check(bl32);
        boolean bl33 = false;
        if (fvalue6.longValue() == Long.MAX_VALUE) {
            bl33 = true;
        }
        harness.check(bl33);
        boolean bl34 = false;
        if (new Float(123456.79f).longValue() == 123456L) {
            bl34 = true;
        }
        harness.check(bl34, "got: " + new Float(123456.79f).longValue() + " but exp.: 123456");
        boolean bl35 = false;
        if (zero.floatValue() == 0.0f) {
            bl35 = true;
        }
        harness.check(bl35);
        boolean bl36 = false;
        if (afloat.floatValue() == 97.0f) {
            bl36 = true;
        }
        harness.check(bl36);
        boolean bl37 = false;
        if (fvalue1.floatValue() == 30.0f) {
            bl37 = true;
        }
        harness.check(bl37);
        boolean bl38 = false;
        if (fvalue2.floatValue() == 123.45f) {
            bl38 = true;
        }
        harness.check(bl38);
        boolean bl39 = false;
        if (fvalue3.floatValue() == 400.35f) {
            bl39 = true;
        }
        harness.check(bl39);
        boolean bl40 = false;
        if (fvalue4.floatValue() == -23.45f) {
            bl40 = true;
        }
        harness.check(bl40);
        boolean bl41 = false;
        if (fvalue5.floatValue() == 3.3E38f) {
            bl41 = true;
        }
        harness.check(bl41);
        boolean bl42 = false;
        if (fvalue6.floatValue() == Float.POSITIVE_INFINITY) {
            bl42 = true;
        }
        harness.check(bl42);
        boolean bl43 = false;
        if (zero.doubleValue() == 0.0) {
            bl43 = true;
        }
        harness.check(bl43);
        boolean bl44 = false;
        if (afloat.doubleValue() == 97.0) {
            bl44 = true;
        }
        harness.check(bl44);
        harness.check(fvalue1.doubleValue(), 30.0);
        harness.check(fvalue2.doubleValue(), 123.45f);
        harness.check(fvalue3.doubleValue(), 400.35f);
        harness.check(fvalue4.doubleValue(), -23.45f);
        harness.check(fvalue5.doubleValue(), 3.3E38f);
        boolean bl45 = false;
        if (fvalue6.doubleValue() == Double.POSITIVE_INFINITY) {
            bl45 = true;
        }
        harness.check(bl45);
    }

    public void testHashCode() {
        Float a = new Float(0.01f);
        Float newa = new Float(0.01f);
        Float infinite = new Float(Float.POSITIVE_INFINITY);
        int binary32 = 48237217;
        Float b32 = new Float(Float.intBitsToFloat(binary32));
        harness.checkPoint("hashCode()int");
        harness.check(b32.hashCode(), binary32);
        harness.check(a.floatValue(), Float.intBitsToFloat(a.hashCode()));
        harness.check(Float.floatToIntBits(0.01f), newa.hashCode());
        harness.check(a.hashCode(), newa.hashCode());
    }

    public void testGetClass() {
        Float a = new Float(0.0f);
        Float b = new Float(Float.POSITIVE_INFINITY);
        Float c = new Float(Float.NEGATIVE_INFINITY);
        Float d = new Float(Float.NaN);
        Integer i = new Integer(0);
        harness.checkPoint("TYPE(public)java.lang.Class");
        harness.check(a.getClass(), b.getClass());
        harness.check(a.getClass(), c.getClass());
        harness.check(a.getClass(), d.getClass());
        boolean bl = false;
        if (a.getClass() != i.getClass()) {
            bl = true;
        }
        harness.check(bl);
        try {
            harness.check(a instanceof Float);
            harness.check(b instanceof Float);
            harness.check(a.getClass().getName(), (Object)"java.lang.Float");
            harness.check(b.getClass().getName(), (Object)"java.lang.Float");
            harness.check(c.getClass().getName(), (Object)"java.lang.Float");
            harness.check(d.getClass().getName(), (Object)"java.lang.Float");
            harness.check(a.getClass(), Class.forName("java.lang.Float"));
            harness.check(b.getClass(), Class.forName("java.lang.Float"));
            harness.check(c.getClass(), Class.forName("java.lang.Float"));
            harness.check(d.getClass(), Class.forName("java.lang.Float"));
            boolean bl2 = false;
            if (i.getClass() != Class.forName("java.lang.Float")) {
                bl2 = true;
            }
            harness.check(bl2);
            harness.check(Float.TYPE.getName(), (Object)"float");
        }
        catch (ClassNotFoundException e) {
            harness.fail("error finding class name");
            harness.debug(e);
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.lang.Float");
        this.testConstructors();
        this.testInfiniteValues();
        this.testCompare();
        this.testStringConversion();
        this.testIntbitsRepresentation();
        this.testStringValueParsing();
        this.testValueConversion();
        this.testHashCode();
        this.testGetClass();
        this.testf2d();
    }
}

