/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.ClassLoader;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.lang.ClassLoader.BadClassLoader;
import gnu.testlet.wonka.lang.ClassLoader.ExClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AcuniaClassLoaderTest
implements Testlet {
    protected TestHarness th;
    protected HashMap hm;
    protected Object class1;
    protected Object class2;
    protected Object duplicate;
    protected ClassLoader baseCl;
    protected ClassLoader evol1Cl;
    protected ClassLoader atest1Cl;
    protected ClassLoader atest2Cl;
    protected ClassLoader rtest1Cl;
    protected ClassLoader rtest2Cl;
    protected ClassLoader duplicateCl;
    private static final String tc1 = "gnu.testlet.wonka.lang.ClassLoader.TestClass1";
    private static final String tc2 = "gnu.testlet.wonka.lang.ClassLoader.TestClass2";
    private static final String ti1 = "gnu.testlet.wonka.lang.ClassLoader.TestInterface1";
    private static final String ti2 = "gnu.testlet.wonka.lang.ClassLoader.TestInterface2";
    private static final String bsi = "gnu.testlet.wonka.lang.ClassLoader.BasicInterface";
    private static final String abc = "gnu.testlet.wonka.lang.ClassLoader.AbstractBaseClass";
    private static final String ac1 = "gnu.testlet.wonka.lang.ClassLoader.AbstractClass1";
    private static final String ac2 = "gnu.testlet.wonka.lang.ClassLoader.AbstractClass2";
    private static final String ae1 = "gnu.testlet.wonka.lang.ClassLoader.AbstractEvol1";
    private static final String e1i = "gnu.testlet.wonka.lang.ClassLoader.Evol1Interface";
    static /* synthetic */ Class class$java$lang$ClassCircularityError;
    static /* synthetic */ Class class$java$lang$NoClassDefFoundError;
    static /* synthetic */ Class class$java$lang$ClassFormatError;
    static /* synthetic */ Class class$java$lang$VerifyError;

    protected boolean setup() {
        this.hm = new HashMap();
        this.th.debug("start seting up ClassLoaderTest");
        try {
            JarFile jf = new JarFile("/test/CLTest.jar");
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                String s = je.getName();
                if (!s.endsWith(".class")) continue;
                int i = s.indexOf(47);
                while (i != -1) {
                    s = s.substring(0, i) + "." + s.substring(i + 1);
                    i = s.indexOf(47);
                }
                i = s.lastIndexOf(46);
                if (i != -1) {
                    s = s.substring(0, i);
                }
                InputStream in = jf.getInputStream(je);
                byte[] bytes = new byte[1024];
                int rd = in.read(bytes, 0, 1024);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while (rd != -1) {
                    bos.write(bytes, 0, rd);
                    rd = in.read(bytes, 0, 1024);
                }
                bytes = bos.toByteArray();
                this.hm.put(s, bytes);
            }
            HashMap clmap = new HashMap();
            clmap.put(abc, this.hm.get(abc));
            clmap.put(bsi, this.hm.get(bsi));
            this.baseCl = new ExClassLoader(clmap, "baseClassLoader");
            clmap = new HashMap(clmap);
            clmap.put(ae1, this.hm.get(ae1));
            clmap.put(e1i, this.hm.get(e1i));
            this.evol1Cl = new ExClassLoader(this.baseCl, clmap, "evol1ClassLoader");
            clmap = new HashMap(clmap);
            clmap.put(ac1, this.hm.get(ac1));
            clmap.put(ti1, this.hm.get(ti1));
            clmap.put(ac2, this.hm.get(ac2));
            clmap.put(ti2, this.hm.get(ti2));
            this.atest1Cl = new ExClassLoader(this.evol1Cl, clmap, "atest1ClassLoader");
            this.atest2Cl = new ExClassLoader(this.evol1Cl, clmap, "atest2ClassLoader");
            clmap = new HashMap(clmap);
            clmap.put(tc1, this.hm.get(tc1));
            clmap.put(tc2, this.hm.get(tc2));
            this.rtest1Cl = new ExClassLoader(this.atest1Cl, clmap, "rtest1ClassLoader");
            this.rtest2Cl = new ExClassLoader(this.atest2Cl, clmap, "rtestClassLoader");
            this.duplicateCl = new ExClassLoader(clmap, "duplucateClassLoader");
            this.th.debug("done setting up ClassLoaderTest");
            return true;
        }
        catch (IOException e) {
            this.th.debug("Jar-file is Missing");
            return false;
        }
    }

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.lang.ClassLoader");
        if (this.setup()) {
            this.test_delegation();
        } else {
            this.th.debug("setup failed");
        }
        this.test_badClasses();
    }

    public void test_delegation() {
        Class<?> c;
        this.th.checkPoint("delegation");
        Thread t = new Thread(new InitClass(this.rtest1Cl));
        ExClassLoader cl = new ExClassLoader(new HashMap(), "dumbClassLoader");
        try {
            c = Class.forName(bsi, true, cl);
            this.th.fail("should throw a ClassNotFoundException");
        }
        catch (ClassNotFoundException cnfe) {
            this.th.check(true);
        }
        try {
            c = Class.forName(bsi, true, this.baseCl);
            t.start();
            Thread.yield();
            c = Class.forName(tc2, false, this.rtest2Cl);
            Object o = c.newInstance();
            this.class2 = o;
            System.out.println("Main class constructed: " + o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            c = Class.forName(bsi, true, cl);
            this.th.fail("should throw a ClassNotFoundException");
        }
        catch (ClassNotFoundException cnfe) {
            this.th.check(true);
        }
        c = this.class1.getClass();
        this.th.check(c.getClassLoader(), this.rtest1Cl, "checking classLoader -- 1");
        c = c.getSuperclass();
        this.th.check(c.getClassLoader(), this.atest1Cl, "checking classLoader -- 2");
        Class<?>[] ca = c.getInterfaces();
        this.th.check(ca[0].getClassLoader(), this.atest1Cl, "checking classLoader -- 3");
        c = c.getSuperclass();
        this.th.check(c.getClassLoader(), this.evol1Cl, "checking classLoader -- 4");
        ca = c.getInterfaces();
        this.th.check(ca[0].getClassLoader(), this.evol1Cl, "checking classLoader -- 5");
        c = c.getSuperclass();
        this.th.check(c.getClassLoader(), this.baseCl, "checking classLoader -- 6");
        ca = c.getInterfaces();
        this.th.debug(ca[0].getName());
        this.th.check(ca[0].getClassLoader(), this.baseCl, "checking classLoader -- 7");
        c = this.class2.getClass();
        this.th.check(c.getClassLoader(), this.rtest2Cl, "checking classLoader -- 9");
        c = c.getSuperclass();
        this.th.check(c.getClassLoader(), this.atest2Cl, "checking classLoader -- 10");
        ca = c.getInterfaces();
        this.th.check(ca[0].getClassLoader(), this.atest2Cl, "checking classLoader -- 11");
        c = c.getSuperclass();
        this.th.check(c.getClassLoader(), this.evol1Cl, "checking classLoader -- 12");
        ca = c.getInterfaces();
        this.th.check(ca[0].getClassLoader(), this.evol1Cl, "checking classLoader -- 13");
        c = c.getSuperclass();
        this.th.check(c.getClassLoader(), this.baseCl, "checking classLoader -- 14");
        ca = c.getInterfaces();
        this.th.check(ca[0].getClassLoader(), this.baseCl, "checking classLoader -- 15");
        this.th.checkPoint("duplicate class loading");
        try {
            c = Class.forName(tc2, false, this.duplicateCl);
            Object o = c.newInstance();
            this.duplicate = o;
            System.out.println("Main class constructed: " + o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        c = this.class2.getClass();
        this.th.check(!c.isInstance(this.duplicate), "not the same instance");
    }

    public void test_badClasses() {
        Class c;
        this.th.checkPoint("defineClass(java.lang.String,byte[],int,int)java.lang.Class");
        BadClassLoader cl = new BadClassLoader();
        try {
            c = cl.findClass("A");
            this.th.fail("should throw ClassCircularityError");
        }
        catch (Throwable t) {
            this.th.check(t.getClass(), class$java$lang$ClassCircularityError == null ? (class$java$lang$ClassCircularityError = AcuniaClassLoaderTest.class$("java.lang.ClassCircularityError")) : class$java$lang$ClassCircularityError);
        }
        try {
            c = cl.findClass("String");
            String s = (String)c.newInstance();
            this.th.fail("should throw an Error");
        }
        catch (Throwable t) {
            this.th.check(t instanceof ClassCastException || t instanceof SecurityException, "checking Throwable type");
        }
        try {
            c = cl.findClass("java.lang.Bad");
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            c = cl.findClass("Old");
            Object o = c.newInstance();
            this.th.fail("should throw a LinkageError");
        }
        catch (Throwable t) {
            this.th.check(t instanceof LinkageError, "caught an Error");
        }
        try {
            c = cl.findClass("Mis");
            c.newInstance();
            this.th.fail("should throw a NoClassDefFoundError");
        }
        catch (Throwable t) {
            this.th.check(t.getClass(), class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = AcuniaClassLoaderTest.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError);
        }
        try {
            c = cl.findClass("MisClass");
            c.newInstance();
            this.th.fail("should throw a NoClassDefFoundError");
        }
        catch (Throwable t) {
            this.th.check(t.getClass(), class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = AcuniaClassLoaderTest.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError);
        }
        try {
            c = cl.findClass("BadFormat1");
            this.th.fail("should throw a ClassFormatError");
        }
        catch (Throwable t) {
            this.th.check(t.getClass(), class$java$lang$ClassFormatError == null ? (class$java$lang$ClassFormatError = AcuniaClassLoaderTest.class$("java.lang.ClassFormatError")) : class$java$lang$ClassFormatError);
        }
        try {
            c = cl.findClass("BadFormat2");
            this.th.fail("should throw a ClassFormatError");
        }
        catch (Throwable t) {
            this.th.check(t.getClass(), class$java$lang$ClassFormatError == null ? (class$java$lang$ClassFormatError = AcuniaClassLoaderTest.class$("java.lang.ClassFormatError")) : class$java$lang$ClassFormatError);
        }
        try {
            c = cl.findClass("BadFormat3");
            c.newInstance();
            this.th.fail("should throw a VerifyError");
        }
        catch (Throwable t) {
            this.th.check(t.getClass(), class$java$lang$VerifyError == null ? (class$java$lang$VerifyError = AcuniaClassLoaderTest.class$("java.lang.VerifyError")) : class$java$lang$VerifyError);
        }
        try {
            c = cl.findClass("CreateByteArray");
            this.th.fail("should throw a ClassFormatError");
        }
        catch (Throwable t) {
            this.th.check(t.getClass(), class$java$lang$ClassFormatError == null ? (class$java$lang$ClassFormatError = AcuniaClassLoaderTest.class$("java.lang.ClassFormatError")) : class$java$lang$ClassFormatError);
        }
        try {
            c = cl.findClass("wrongName");
            this.th.fail("should throw an Error");
        }
        catch (Throwable t) {
            this.th.check(t instanceof Error);
        }
        try {
            c = cl.findClass("Acces.AcMethod");
            c.newInstance();
            this.th.fail("should throw an IncompatibleClassChangeError");
        }
        catch (Throwable t) {
            this.th.check(t instanceof IllegalAccessError);
        }
        try {
            c = cl.findClass("Acces");
            c.newInstance();
            this.th.fail("should throw an IncompatibleClassChangeError");
        }
        catch (Throwable t) {
            this.th.check(t instanceof IllegalAccessError);
        }
        try {
            c = cl.findClass("NoSuchField");
            c.newInstance();
            this.th.fail("should throw an IncompatibleClassChangeError");
        }
        catch (Throwable t) {
            this.th.check(t instanceof NoSuchFieldError);
        }
        try {
            c = cl.findClass("NoSuchMethod");
            c.newInstance();
            this.th.fail("should throw an IncompatibleClassChangeError");
        }
        catch (Throwable t) {
            this.th.check(t instanceof NoSuchMethodError);
        }
        try {
            c = cl.findClass("Instantiate");
            c.newInstance();
            this.th.fail("should throw an IncompatibleClassChangeError");
        }
        catch (Throwable t) {
            this.th.check(t instanceof InstantiationError);
        }
        try {
            c = cl.findClass("Initializer");
            c.newInstance();
            this.th.fail("should throw an ExceptionInInitializerError");
        }
        catch (Throwable t) {
            this.th.check(t instanceof ExceptionInInitializerError);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InitClass
    implements Runnable {
        ClassLoader cl;

        public InitClass(ClassLoader cl) {
            this.cl = cl;
        }

        public void run() {
            try {
                Class<?> c = Class.forName(AcuniaClassLoaderTest.tc1, false, this.cl);
                Object o = c.newInstance();
                AcuniaClassLoaderTest.this.class1 = o;
                System.out.println("InitClass constructed: " + o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

