/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.lang.Boolean;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Properties;

public class BooleanTest
implements Testlet {
    TestHarness harness;

    void testConstructors() {
        this.harness.checkPoint("Boolean(boolean)");
        Boolean a = new Boolean(true);
        Boolean b = new Boolean(false);
        Boolean c = new Boolean(true);
        boolean b_true = true;
        boolean b_false = false;
        Boolean d = new Boolean(b_true);
        Boolean e = new Boolean(b_false);
        Boolean f = a;
        this.harness.checkPoint("equals(java.lang.Object)boolean");
        boolean bl = false;
        if (a != null) {
            bl = true;
        }
        this.harness.check(bl);
        this.harness.check(a.equals(null) ^ true);
        this.harness.check(a.equals(Boolean.TRUE));
        this.harness.check(a.equals(new Boolean(true)));
        boolean bl2 = false;
        if (a != Boolean.TRUE) {
            bl2 = true;
        }
        this.harness.check(bl2);
        this.harness.check(a);
        this.harness.check(b.equals(Boolean.FALSE));
        this.harness.check(b.equals(new Boolean(false)));
        boolean bl3 = false;
        if (b != Boolean.FALSE) {
            bl3 = true;
        }
        this.harness.check(bl3);
        this.harness.check(b ^ true);
        boolean bl4 = false;
        if (a != b) {
            bl4 = true;
        }
        this.harness.check(bl4);
        this.harness.check(a.equals(b) ^ true);
        boolean bl5 = false;
        if (a != c) {
            bl5 = true;
        }
        this.harness.check(bl5);
        this.harness.check(a.equals(c));
        boolean bl6 = false;
        if (a == f) {
            bl6 = true;
        }
        this.harness.check(bl6);
        this.harness.check(a.equals(f));
        boolean bl7 = false;
        if (a == a) {
            bl7 = true;
        }
        this.harness.check(bl7);
        this.harness.checkPoint("booleanValue()boolean");
        this.harness.check(a);
        this.harness.check(d);
        this.harness.check(d ^ b_true ^ true);
        this.harness.check(a ^ d ^ true);
        this.harness.check(b ^ true);
        this.harness.check(e ^ true);
        this.harness.check(e ^ b_false ^ true);
        this.harness.check(b ^ e ^ true);
        Integer i = new Integer(123);
        this.harness.check(a.equals(i) ^ true);
        this.harness.check(b.equals(i) ^ true);
        this.harness.checkPoint("Boolean(java.lang.String)");
        Boolean stringbool = new Boolean("true");
        this.harness.check(stringbool.equals(Boolean.TRUE));
        stringbool = new Boolean("false");
        this.harness.check(stringbool.equals(Boolean.FALSE));
        stringbool = new Boolean("TRUE");
        this.harness.check(stringbool.equals(Boolean.TRUE));
        stringbool = new Boolean("tRuE");
        this.harness.check(stringbool.equals(Boolean.TRUE));
        stringbool = new Boolean("foo");
        this.harness.check(stringbool.equals(Boolean.FALSE));
        stringbool = new Boolean("");
        this.harness.check(stringbool.equals(Boolean.FALSE));
        stringbool = new Boolean(null);
        this.harness.check(stringbool.equals(Boolean.FALSE));
    }

    void testStringConversion() {
        this.harness.checkPoint("valueOf(java.lang.String)java.lang.Boolean");
        Boolean stringbool = Boolean.valueOf("true");
        this.harness.check(stringbool);
        stringbool = Boolean.valueOf("TRUE");
        this.harness.check(stringbool);
        stringbool = Boolean.valueOf("TruE");
        this.harness.check(stringbool);
        stringbool = Boolean.valueOf("false");
        this.harness.check(stringbool ^ true);
        stringbool = Boolean.valueOf("trou");
        this.harness.check(stringbool ^ true);
        stringbool = Boolean.valueOf("  true  ");
        this.harness.check(stringbool ^ true);
        stringbool = Boolean.valueOf("");
        this.harness.check(stringbool ^ true);
        stringbool = Boolean.valueOf(null);
        this.harness.check(stringbool ^ true);
        this.harness.check(Boolean.valueOf("true"));
        this.harness.checkPoint("toString()java.lang.String");
        Boolean a = new Boolean(true);
        Boolean b = new Boolean(false);
        this.harness.check(a.toString(), (Object)"true");
        this.harness.check(b.toString(), (Object)"false");
    }

    void testProperties() {
        this.harness.checkPoint("getBoolean(java.lang.String)boolean");
        Properties p = System.getProperties();
        p.put("e1", "true");
        p.put("e2", "false");
        this.harness.check(Boolean.getBoolean("e1"));
        this.harness.check(Boolean.getBoolean("e2") ^ true);
        this.harness.check(Boolean.getBoolean("e3") ^ true);
    }

    void testHashCode() {
        Boolean a = new Boolean("true");
        Boolean b = new Boolean("false");
        Boolean c = new Boolean("true");
        Boolean d = new Boolean("false");
        this.harness.checkPoint("hashCode()int");
        this.harness.check(a.hashCode(), c.hashCode());
        this.harness.check(b.hashCode(), d.hashCode());
        boolean bl = false;
        if (a.hashCode() != b.hashCode()) {
            bl = true;
        }
        this.harness.check(bl);
        this.harness.check(a.hashCode(), 1231);
        this.harness.check(b.hashCode(), 1237);
    }

    void testGetClass() {
        Boolean a = new Boolean("true");
        Boolean b = new Boolean("false");
        Integer i = new Integer(0);
        this.harness.checkPoint("TYPE(public)java.lang.Class");
        try {
            this.harness.check(a instanceof Boolean);
            this.harness.check(b instanceof Boolean);
            this.harness.check(a.getClass().getName(), (Object)"java.lang.Boolean");
            this.harness.check(b.getClass().getName(), (Object)"java.lang.Boolean");
            this.harness.check(a.getClass(), Class.forName("java.lang.Boolean"));
            this.harness.check(b.getClass(), Class.forName("java.lang.Boolean"));
            boolean bl = false;
            if (i.getClass() != Class.forName("java.lang.Boolean")) {
                bl = true;
            }
            this.harness.check(bl);
            this.harness.check(a.getClass(), b.getClass());
            boolean bl2 = false;
            if (a.getClass() != i.getClass()) {
                bl2 = true;
            }
            this.harness.check(bl2);
            this.harness.check(Boolean.TYPE.getName(), (Object)"boolean");
        }
        catch (ClassNotFoundException e) {
            this.harness.fail("error finding class name");
            this.harness.debug(e);
        }
    }

    public void test(TestHarness newharness) {
        this.harness = newharness;
        this.harness.setclass("java.lang.Boolean");
        this.testConstructors();
        this.testStringConversion();
        this.testProperties();
        this.testHashCode();
        this.testGetClass();
    }
}

