/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.jni;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class JNIStringTest
implements Testlet {
    protected static TestHarness harness;

    protected void testStringConstruction() {
        harness.checkPoint("String(void) /NewStringUTF");
        harness.check(this.nativeUTFHello(), (Object)"hello");
        harness.checkPoint("string(int) using NewStringUTF");
        harness.check(this.nativeUTFBuildString(6, (byte)42), (Object)"******");
        harness.checkPoint("String(void) /NewString");
        harness.check(this.nativeUnicodeHello(), (Object)"hello");
        harness.checkPoint("string(int) using NewString");
        harness.check(this.nativeUnicodeBuildString(3, '\u00f4'), (Object)JNIStringTest.unicodeString("/u00f4/u00f4/u00f4"));
    }

    public native String nativeUnicodeHello();

    public native String nativeUTFHello();

    native String nativeUnicodeBuildString(int var1, char var2);

    native String nativeUTFBuildString(int var1, byte var2);

    protected void testStringLength() {
        String testdoubles = JNIStringTest.unicodeString("sm/u00f6rebr/u00f6d");
        String testtriples = JNIStringTest.unicodeString("thai </u0e01/u0e0f>");
        harness.checkPoint("int(string): letter count using GetUTFStringLength()");
        harness.check(JNIStringTest.nativeUTFLength(testdoubles), 11, "Length of " + testdoubles);
        harness.check(JNIStringTest.nativeUTFLength(testtriples), 13, "Length of " + testtriples);
        harness.checkPoint("int(string): letter count using GetStringLength()");
        harness.check(JNIStringTest.nativeUnicodeLength(testdoubles), 9, "Length of " + testdoubles);
        harness.check(JNIStringTest.nativeUnicodeLength(testtriples), 9, "Length of " + testtriples);
    }

    static native int nativeUnicodeLength(String var0);

    static native int nativeUTFLength(String var0);

    protected void testStringAccess() {
        String testdoubles = JNIStringTest.unicodeString("sm/u00f6rebr/u00f6d");
        String testtriples = JNIStringTest.unicodeString("thai </u0e01/u0e0f>");
        harness.checkPoint("int(string): string scan using GetStringUTFChars/ReleaseStringUTFChars");
        harness.check(this.nativeUTFCountNonAscii(testdoubles), 4, testdoubles);
        harness.check(this.nativeUTFCountNonAscii(testtriples), 6, testtriples);
        harness.checkPoint("int(string): string scan using GetStringChars/ReleaseStringChars");
        harness.check(this.nativeUnicodeCountNonAscii(testdoubles), 2, testdoubles);
        harness.check(this.nativeUnicodeCountNonAscii(testtriples), 2, testtriples);
    }

    private final native int nativeUnicodeCountNonAscii(String var1);

    private final native int nativeUTFCountNonAscii(String var1);

    protected void testStringRebuild() {
        String testdoubles = JNIStringTest.unicodeString("sm/u00f6rebr/u00f6d");
        String testtriples = JNIStringTest.unicodeString("thai </u0e01/u0e0f>");
        harness.checkPoint("string(string): copy using GetStringUTFChars/ReleaseStringUTFChars and NewStringUTF)");
        String decoded = this.nativeUTFBuildOnlyAscii(testdoubles);
        harness.verbose(decoded);
        harness.check(decoded, (Object)"sm**rebr**d");
        decoded = this.nativeUTFBuildOnlyAscii(testtriples);
        harness.verbose(decoded);
        harness.check(decoded, (Object)"thai <******>");
        harness.checkPoint("string(string): copy using GetStringChars/ReleaseStringChars and NewString)");
        decoded = this.nativeUnicodeBuildOnlyAscii(testdoubles);
        harness.verbose(decoded);
        harness.check(decoded, (Object)"sm*rebr*d");
        decoded = this.nativeUnicodeBuildOnlyAscii(testtriples);
        harness.verbose(decoded);
        harness.check(decoded, (Object)"thai <**>");
    }

    private final native String nativeUnicodeBuildOnlyAscii(String var1);

    private final native String nativeUTFBuildOnlyAscii(String var1);

    protected void testStringManipulation() {
    }

    private final native String nativeUnicodeReplaceNonAscii(String var1);

    private final native String nativeUTFReplaceNonAscii(String var1);

    public void testStringCritical() {
        harness.checkPoint("int(string): string scan using GetStringCritical/ReleaseStringCritical");
        String testdoubles = JNIStringTest.unicodeString("sm/u00f6rebr/u00f6d");
        String testtriples = JNIStringTest.unicodeString("thai </u0e01/u0e0f>");
        harness.checkPoint("int(string): string scan using GetStringCritical/ReleaseStringCritical");
        harness.check(this.nativeCriticalCountNonAscii(testdoubles), 2, testdoubles);
        harness.check(this.nativeCriticalCountNonAscii(testtriples), 2, testtriples);
        harness.checkPoint("string(string): copy using GetStringCritical/ReleaseStringCritical and NewString)");
        harness.check(this.nativeCriticalBuildOnlyAscii(testdoubles), "sm*rebr*d", testdoubles);
        harness.check(this.nativeCriticalBuildOnlyAscii(testtriples), "thai <**>", testtriples);
    }

    private final native int nativeCriticalCountNonAscii(String var1);

    private final native String nativeCriticalBuildOnlyAscii(String var1);

    private final native String nativeCriticalReplaceNonAscii(String var1);

    public void testStringUTFRegion() {
        harness.checkPoint("testing special native GetStringUTFRegion() function");
    }

    static String unicodeString(String source) {
        String dest = "";
        int letter = 0;
        while (letter < source.length()) {
            char c = source.charAt(letter);
            if (c != '/') {
                ++letter;
            } else {
                String unicodestring = source.substring(letter + 2, letter + 6);
                c = (char)Integer.parseInt(unicodestring, 16);
                letter += 6;
            }
            dest = dest + c;
        }
        return dest;
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("JNI cass access");
        this.testStringConstruction();
        this.testStringLength();
        this.testStringAccess();
        this.testStringRebuild();
        this.testStringManipulation();
        this.testStringCritical();
        this.testStringUTFRegion();
    }

    static {
        System.loadLibrary("JNIStringTest");
    }
}

