/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.PipedReader;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.PipedReader.SMPipedThread;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMPipedReaderTest
implements Testlet {
    protected TestHarness th;
    private boolean go;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.PipedWriter");
        this.test_PipedWriter();
        this.th.setclass("java.io.PipedReader");
        this.test_PipedReader();
        this.test_connect();
        this.test_close();
        this.test_ready();
        this.test_thread();
        this.test_read_write();
    }

    public void test_PipedReader() {
        this.th.checkPoint("PipedReader(java.io.PipedWriter)");
        try {
            new PipedWriter(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught exception ...");
        }
        catch (IOException ieo) {
            this.th.fail("Constructor should not throw an IOException here");
        }
    }

    public void test_PipedWriter() {
        this.th.checkPoint("PipedWriter(java.io.PipedReader)");
        try {
            new PipedWriter(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught exception ...");
        }
        catch (IOException ieo) {
            this.th.fail("Constructor should not throw an IOException here");
        }
    }

    public void test_connect() {
        this.th.checkPoint("connect");
        PipedReader pr = new PipedReader();
        PipedWriter pw = null;
        try {
            pw = new PipedWriter(pr);
            pw.write("test".toCharArray(), 0, 4);
            char[] buf = new char[4];
            pr.read(buf, 0, 4);
            this.th.check(new String(buf), "test", "testing connection");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
        try {
            new PipedWriter(pr);
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        try {
            new PipedReader(pw);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        try {
            pr.connect(new PipedWriter());
            this.th.fail("should throw an IOException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 3");
        }
        try {
            pw.connect(new PipedReader());
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 4");
        }
        try {
            pr = new PipedReader();
            pr.close();
            pw = new PipedWriter();
            pw.close();
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 2");
        }
        try {
            new PipedWriter(pr);
            this.th.fail("should throw an IOException -- 5");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 5");
        }
        try {
            new PipedReader(pw);
            this.th.fail("should throw an IOException -- 6");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 6");
        }
        try {
            pr.connect(new PipedWriter());
            this.th.fail("should throw an IOException -- 7");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 7");
        }
        try {
            pw.connect(new PipedReader());
            this.th.fail("should throw an IOException -- 8");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 8");
        }
        pr = new PipedReader();
        pw = new PipedWriter();
        try {
            pr.connect(null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 1");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 3");
        }
        try {
            pw.connect(null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true, "caught NullPointerException -- 2");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 4");
        }
    }

    public void test_ready() {
        this.th.checkPoint("ready()boolean");
        try {
            PipedReader pr = new PipedReader();
            PipedWriter pw = new PipedWriter(pr);
            this.th.check(pr.ready() ^ true, "nothing availble -- 1");
            pw.write("testing".toCharArray(), 0, 5);
            this.th.check(pr.ready(), "things availble");
            char[] buf = new char[4];
            pr.read(buf, 0, 4);
            this.th.check(pr.ready(), "one char availble");
            pr.read();
            this.th.check(pr.ready() ^ true, "nothing availble -- 2");
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
    }

    public void test_thread() {
        this.th.checkPoint("read()int");
        PipedReader pr = new PipedReader();
        SMPipedThread pt = new SMPipedThread(pr, this.th);
        Thread t = new Thread(pt);
        t.start();
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            pr.read();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        this.th.checkPoint("read(char[],int,int)int");
        pr = new PipedReader();
        pt = new SMPipedThread(pr, this.th);
        t = new Thread(pt);
        t.start();
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            pr.read(new char[3], 1, 2);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        PipedWriter pw = new PipedWriter();
        pt = new SMPipedThread(pw, this.th);
        t = new Thread(pt);
        t.start();
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            pw.write(new char[3], 1, 2);
            this.th.fail("should throw an IOException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 3");
        }
        pw = new PipedWriter();
        pt = new SMPipedThread(pw, this.th);
        t = new Thread(pt);
        t.start();
        while (t.isAlive()) {
            Thread.yield();
        }
        try {
            pw.write(2);
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 4");
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        PipedReader pr = new PipedReader();
        PipedWriter pw = null;
        try {
            pw = new PipedWriter(pr);
            pw.close();
            pw.close();
            pr.close();
            pr.close();
            pw.close();
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
        try {
            pr.read();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        try {
            pr.read(new char[2], 0, 1);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        try {
            pr.ready();
            this.th.fail("should throw an IOException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 3");
        }
        try {
            pw.write(1);
            this.th.fail("should throw an IOException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 4");
        }
        try {
            pw.write(new char[2], 0, 1);
            this.th.fail("should throw an IOException -- 5");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 5");
        }
        try {
            pw.flush();
            this.th.fail("should throw an IOException -- 6");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 6");
        }
    }

    public void test_read_write() {
        this.th.checkPoint("read/write");
        PipedWriter pw = new PipedWriter();
        SMPipedThread pt = new SMPipedThread(pw, this.th);
        pt.setAlive(false);
        pt.setPRT(this);
        Thread t = new Thread(pt);
        t.start();
        String s = this.buildString();
        try {
            while (!this.go) {
                Thread.yield();
            }
            pw.write(s.toCharArray());
            pt.stop();
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 1");
        }
        while (t.isAlive()) {
            Thread.yield();
        }
        String readedS = pt.getBuffer();
        this.th.check(readedS, s, "reading is OK ...");
        pw = new PipedWriter();
        PipedReader pr = new PipedReader();
        try {
            pr.read();
            this.th.fail("should throw an IOException -- 1");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 1");
        }
        try {
            pr.read(new char[2], 0, 1);
            this.th.fail("should throw an IOException -- 2");
        }
        catch (IOException ioe) {
            this.th.check(true, "caught IOException -- 2");
        }
        try {
            pw.write(1);
            this.th.fail("should throw an NullPointerException -- 3");
        }
        catch (IOException ioe) {
            this.th.check(true, "IOException expected -- 2");
        }
        try {
            pw.write(new char[2], 0, 1);
            this.th.fail("should throw an NullPointerException -- 4");
        }
        catch (IOException ioe) {
            this.th.check(true, "IOException expected -- 3");
        }
        try {
            pr.connect(pw);
            char[] buf = new char[4];
            pw.write(buf, 0, 4);
            try {
                pr.read(buf, -1, 0);
                this.th.fail("should throw IndexOutOfBoundsException -- 1");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pr.read(buf, 1, -1);
                this.th.fail("should throw IndexOutOfBoundsException -- 2");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pr.read(buf, 2, 3);
                this.th.fail("should throw IndexOutOfBoundsException -- 3");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pw.write(buf, -1, 2);
                this.th.fail("should throw IndexOutOfBoundsException -- 4");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pw.write(buf, 1, -2);
                this.th.fail("should throw IndexOutOfBoundsException -- 5");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pw.write(buf, 3, 2);
                this.th.fail("should throw IndexOutOfBoundsException -- 6");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.th.check(true);
            }
            try {
                pw.write((char[])null, 3, 2);
                this.th.fail("should throw NullPointerException -- 1");
            }
            catch (NullPointerException npe) {
                this.th.check(true);
            }
            try {
                pr.read(null, 2, 3);
                this.th.fail("should throw NullPointerException -- 2");
            }
            catch (NullPointerException npe) {
                this.th.check(true);
            }
        }
        catch (IOException ioe) {
            this.th.fail("no IOException expected -- 4");
        }
    }

    private final String buildString() {
        StringBuffer b = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < 288) {
            b.append("ACUNIA" + j + ' ');
            if (j == 9) {
                b.setCharAt(b.length() - 1, '\n');
            }
            j = (j + 1) % 10;
            ++i;
        }
        b.setCharAt(b.length() - 1, '\n');
        b.setCharAt(0, '\n');
        return new String(b);
    }

    public void go() {
        this.go = true;
    }

    private final /* synthetic */ void this() {
        this.go = false;
    }

    public SMPipedReaderTest() {
        this.this();
    }
}

