/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.OutputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.OutputStream.SMExOutputStream;

public class SMOutputStreamTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.OutputStream");
        this.test_write();
        this.test_flush();
        this.test_close();
    }

    public void test_write() {
        this.th.checkPoint("write(int)void");
        this.th.checkPoint("write(byte[])void");
        SMExOutputStream os = new SMExOutputStream();
        String s = "abcdefgh";
        try {
            os.write(s.getBytes());
            this.th.check(s.equals(os.toString()), "checking bytes are written -- 1");
            os.write(s.getBytes());
            this.th.check(os.toString().equals(s + s), "checking bytes are written -- 1");
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exception -- 1, got:" + e);
        }
        try {
            os.write(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 2, got:" + e);
        }
        this.th.checkPoint("write(byte[],int,int)void");
        os = new SMExOutputStream();
        try {
            os.write(s.getBytes(), 0, 5);
            os.write(s.getBytes(), 5, 3);
            this.th.check(os.toString().equals(s), "checking bytes are written");
        }
        catch (Exception e) {
            this.th.fail("should not throw any Exception -- 1, got:" + e);
        }
        try {
            os.write(null, 4, 5);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 2, got:" + e);
        }
        try {
            os.write(s.getBytes(), -4, 5);
            this.th.fail("should throw IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 3, got:" + e);
        }
        try {
            os.write(s.getBytes(), 4, -5);
            this.th.fail("should throw IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 4, got:" + e);
        }
        try {
            os.write(s.getBytes(), 4, 5);
            this.th.fail("should throw IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 5, got:" + e);
        }
        try {
            os.write(s.getBytes(), 8, 1);
            this.th.fail("should throw IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 6, got:" + e);
        }
        this.th.check(os.toString().equals(s), "checking no extra bytes are written");
    }

    public void test_flush() {
        this.th.checkPoint("flush()void");
        SMExOutputStream os = new SMExOutputStream();
        try {
            os.flush();
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("flush does nothing --> throwing exceptions not allowed");
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMExOutputStream os = new SMExOutputStream();
        try {
            os.close();
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("close does nothing --> throwing exceptions not allowed");
        }
    }
}

