/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.FilterOutputStream;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.FilterOutputStream.SMInfoOutputStream;
import java.io.FilterOutputStream;

public class SMFilterOutputStreamTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.FilterOutputStream");
        this.test_FilterOutputStream();
        this.test_flush();
        this.test_write();
        this.test_close();
    }

    public void test_FilterOutputStream() {
        this.th.checkPoint("FilterOutputStream(java.io.OutputStream)");
    }

    public void test_flush() {
        this.th.checkPoint("flush()void");
        SMInfoOutputStream ios = new SMInfoOutputStream();
        FilterOutputStream fos = new FilterOutputStream(ios);
        try {
            fos.flush();
            this.th.check(ios.isMarked(), "check if flush is called downstream");
        }
        catch (Exception e) {
            this.th.fail("got unexpected Exception:" + e);
        }
    }

    public void test_write() {
        this.th.checkPoint("write(int)void");
        SMInfoOutputStream ios = new SMInfoOutputStream();
        FilterOutputStream fos = new FilterOutputStream(ios);
        try {
            fos.write(23);
            this.th.check(ios.isMarked(), "checking write -- 1");
            boolean bl = false;
            if (ios.off == 23) {
                bl = true;
            }
            this.th.check(bl, "checking write -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unexpected Exception:" + e);
        }
        ios.clean();
        this.th.checkPoint("write(byte[])void");
        byte[] buf = "abcd".getBytes();
        try {
            fos.write(buf);
            this.th.check(ios.isMarked(), "checking write -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unexpected Exception -- 1, got:" + e);
        }
        try {
            ios.clean();
            fos.write(null);
            this.th.fail("shoild throw a NullPointerException:");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected Exception -- 2, got:" + e);
        }
        this.th.check(ios.isMarked() ^ true, "checking marked after failed write -- 1");
        ios.clean();
        this.th.checkPoint("write(byte[],int,int)void");
        try {
            fos.write(buf, 1, 2);
            this.th.check(ios.isMarked(), "checking write -- 1");
        }
        catch (Exception e) {
            this.th.fail("got unexpected Exception -- 1, got:" + e);
        }
        try {
            ios.clean();
            fos.write(null, 1, 2);
            this.th.fail("shoild throw a NullPointerException:");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unexpected Exception -- 2, got:" + e);
        }
        this.th.check(ios.isMarked() ^ true, "checking marked after failed write -- 1");
        try {
            ios.clean();
            fos.write(buf, -1, 2);
            this.th.fail("should throw IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 3, got:" + e);
        }
        this.th.check(ios.isMarked() ^ true, "checking marked after failed write -- 2");
        try {
            ios.clean();
            fos.write(buf, 3, -2);
            this.th.fail("should throw IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 4, got:" + e);
        }
        this.th.check(ios.isMarked() ^ true, "checking marked after failed write -- 3");
        try {
            ios.clean();
            fos.write(buf, 5, 0);
            this.th.fail("should throw IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 5, got:" + e);
        }
        this.th.check(ios.isMarked() ^ true, "checking marked after failed write -- 4");
        try {
            ios.clean();
            fos.write(buf, 3, 2);
            this.th.fail("should throw IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("should not throw this Exception -- 6, got:" + e);
        }
        this.th.check(ios.isMarked() ^ true, "checking marked after failed write -- 5");
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMInfoOutputStream ios = new SMInfoOutputStream();
        FilterOutputStream fos = new FilterOutputStream(ios);
        try {
            fos.close();
            this.th.check(ios.isMarked(), "check if close is called downstream");
        }
        catch (Exception e) {
            this.th.fail("got unexpected Exception:" + e);
        }
    }
}

