/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.File;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class PhysicalFileTest
implements Testlet {
    static final String DIRSTUB = "level_";
    static final String FILESTUB = "file";
    static final String FILEEND = ".scr";
    static final String TEMPEND = ".tmp";
    static final String SUBDIR1 = "subdir_1";
    static final String SUBDIR2 = "subdir_2";
    protected static TestHarness harness;

    private final void testClass() {
        boolean mustfail = false;
        try {
            File current = new File("");
            File fulldir = current.getCanonicalFile();
            String fullpath = current.getCanonicalPath();
            harness.checkPoint("Class tests current dir");
            this.doClassTests(current, current);
            this.doClassTests(fulldir, current);
            this.doClassTests(new File(fullpath), current);
            String target = this.getDirPath(null, 1);
            this.doClassTests(target, fullpath, fulldir, current);
            target = this.getFilePath(null, 0, 1);
            this.doClassTests(target, fullpath, fulldir, current);
            target = this.getFilePath(null, 1, 1);
            this.doClassTests(target, fullpath, fulldir, current);
            target = this.getDirPath(null, 1) + ".." + File.separator + this.getFilePath(null, 0, 1);
            this.doClassTests(target, fullpath, fulldir, current);
            mustfail = true;
            harness.checkPoint("Class tests null class, should throw NullPointerException");
            this.doClassTests(null, new File(""));
            harness.fail("Class tests null class, should throw NullPointerException");
        }
        catch (NullPointerException e) {
            harness.check(mustfail, "Class tests null class, should throw NullPointerException : " + e.toString());
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void doClassTests(String target, String root, File rootdir, File dummy) throws Exception {
        harness.checkPoint("Class tests file <" + target + '>');
        this.doClassTests(new File(target), dummy);
        this.doClassTests(new File(root + File.separator + target), dummy);
        this.doClassTests(new File(root, target), dummy);
        this.doClassTests(new File(rootdir, target), dummy);
    }

    private final void doClassTests(File target, File dummy) throws Exception {
        Class<?> targetclass = target.getClass();
        harness.check(target instanceof File, "target instanceof File");
        harness.check(targetclass, dummy.getClass(), "target class = File.class");
        harness.check(targetclass.getName(), "java.io.File", "target class getName = <java.io.File>");
        harness.check(targetclass, Class.forName("java.io.File"), "target class = new class(java.io.File)");
    }

    private final void testConstruction(boolean absolute) {
        harness.checkPoint("Test construction, existence deleting of directories and files: absolute path:" + absolute);
        String root = absolute ? this.getCanonicalRoot() : null;
        File level1 = this.getDir(root, 1);
        File testfile = this.getDir(root, 1);
        harness.checkPoint("Construction of directory <" + testfile + "> using mkdir()");
        this.doDirConstructionTests(testfile);
        level1.mkdir();
        testfile = this.getDir(root, 2);
        harness.checkPoint("Construction of directory <" + testfile + "> using mkdir()");
        this.doDirConstructionTests(testfile);
        testfile = this.getDir(root, 3);
        harness.checkPoint("Construction of directory <" + testfile + "> in non-existing path, using mkdir()");
        this.failDirConstructionTests(testfile, "creating dir in nonexisting directory returns false");
        testfile = this.getResolvedRootDir("testdir", absolute);
        harness.checkPoint("Construction of canonical resolved directory <" + testfile + "> through existing path, using mkdir()");
        this.doDirConstructionTests(testfile);
        level1.delete();
        testfile = this.getResolvedRootDir("testdir", absolute);
        harness.checkPoint("Construction of canonical resolved directory <" + testfile + "> through existing path, using mkdir()");
        this.failDirConstructionTests(testfile, "creating canonicAL dir through nonexisting directory returns false");
        harness.checkPoint("Construction of directory <" + this.getDirPath(root, 1) + "> using mkdirs()");
        this.doDirConstructionTests(root, 1);
        harness.checkPoint("Construction of relative file <" + this.getDirPath(root, 3) + "> using mkdirs()");
        this.doDirConstructionTests(root, 3);
        testfile = this.getFile(root, 0, 1);
        harness.checkPoint("Construction of file <" + testfile + "> using createNewFile()");
        this.doFileConstructionTests(testfile);
        level1.mkdir();
        testfile = this.getFile(root, 1, 1);
        harness.checkPoint("Construction of file <" + testfile + "> using createNewFile()");
        this.doFileConstructionTests(testfile);
        testfile = this.getFile(root, 2, 1);
        harness.checkPoint("Construction of file <" + testfile + "> in non-existing path, using createNewFile()");
        this.failFileConstructionTests(testfile, "creating dir in nonexisting directory returns false");
        testfile = this.getResolvedRootFile(1, absolute);
        harness.checkPoint("Construction of canonical resolved file <" + testfile + "> in existing path, using createNewFile()");
        this.doFileConstructionTests(testfile);
        level1.delete();
        testfile = this.getResolvedRootFile(1, absolute);
        harness.checkPoint("Construction of canonical resolved file <" + testfile + "> in non-existing path, using createNewFile()");
        this.failFileConstructionTests(testfile, "using non-exixting directory");
    }

    private final void doDirConstructionTests(File testdir) {
        this.checkBasicNonExisting(testdir);
        harness.check(testdir.delete() ^ true, "Deleting no longer existing file must return false");
        harness.check(testdir.mkdir(), "Creating new directory");
        harness.check(testdir.mkdir() ^ true, "Creating already existing directory should throw error");
        this.checkBasicExisting(testdir, true);
        harness.check(testdir.setLastModified(1000L), "Setting last modified time");
        harness.check(testdir.lastModified(), 1000L, "last modified time, just set");
        harness.check(testdir.setLastModified(2005L), "Setting last modified time, trunkated to 1000 milliseconds");
        harness.check(testdir.lastModified(), 2000L, "last modified time, just set, trunkated to 1000 milliseconds");
        harness.check(testdir.setReadOnly(), "Setting file to read-only");
        harness.check(testdir.canRead(), "setReadOnly() must still must alow read");
        harness.check(testdir.canWrite() ^ true, "setReadOnly() may not alow write");
        harness.check(testdir.delete(), "Deleting existing file");
    }

    private final void doDirConstructionTests(String root, int level) {
        File testdir = this.getDir(root, level);
        this.checkBasicNonExisting(testdir);
        harness.check(testdir.delete() ^ true, "Deleting no longer existing file must return false");
        harness.check(testdir.mkdirs(), "Creating new directory");
        harness.check(testdir.mkdirs() ^ true, "Creating already existing directory should throw error");
        this.checkBasicExisting(testdir, true);
        harness.check(testdir.setLastModified(1000L), "Setting last modified time");
        harness.check(testdir.lastModified(), 1000L, "last modified time, just set");
        harness.check(testdir.setLastModified(2005L), "Setting last modified time, trunkated to 1000 milliseconds");
        harness.check(testdir.lastModified(), 2000L, "last modified time, just set, trunkated to 1000 milliseconds");
        harness.check(testdir.setReadOnly(), "Setting file to read-only");
        harness.check(testdir.canRead(), "setReadOnly() must still must alow read");
        harness.check(testdir.canWrite() ^ true, "setReadOnly() may not alow write");
        this.deleteFileStructure(level, 0, true);
    }

    private final void doFileConstructionTests(File testfile) {
        this.checkBasicNonExisting(testfile);
        harness.check(testfile.delete() ^ true, "Deleting no longer existing file must return false");
        try {
            harness.check(testfile.createNewFile(), "Creating new (non-existing) file");
            harness.check(testfile.createNewFile() ^ true, "Creating already-existing file must return false");
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
        this.checkBasicExisting(testfile, false);
        harness.check(testfile.setLastModified(1000L), "Setting last modified time");
        harness.check(testfile.lastModified(), 1000L, "last modified time, just set");
        harness.check(testfile.setLastModified(2005L), "Setting last modified time, trunkated to 1000 milliseconds");
        harness.check(testfile.lastModified(), 2000L, "last modified time, just set, trunkated to 1000 milliseconds");
        harness.check(testfile.setReadOnly(), "Setting file to read-only");
        harness.check(testfile.canRead(), "setReadOnly() must still must alow read");
        harness.check(testfile.canWrite() ^ true, "setReadOnly() may not alow write");
        harness.check(testfile.delete(), "Deleting existing file");
    }

    private final void failDirConstructionTests(File testdir, String errormessage) {
        this.checkBasicNonExisting(testdir);
        try {
            harness.check(testdir.mkdir() ^ true, errormessage);
        }
        catch (Exception ex) {
            harness.fail(" unexpected exception <" + ex.toString() + '>');
        }
        harness.check(testdir.delete() ^ true, "Deleting non existing dir must return false");
    }

    private final void failFileConstructionTests(File testfile, String errormessage) {
        this.checkBasicNonExisting(testfile);
        try {
            testfile.createNewFile();
            harness.fail(errormessage + " : file nevertheless constructed");
        }
        catch (IOException iox) {
            harness.check(true, errormessage + " IO exception <" + iox.toString() + '>');
        }
        catch (Exception ex) {
            harness.fail(" unexpected exception <" + ex.toString() + '>');
        }
        harness.check(testfile.delete() ^ true, "Deleting non existing file must return false");
    }

    private final void testCanonicalConstruction() {
        harness.checkPoint("Test construction and access of equivalent files");
        String canonicalroot = this.getCanonicalRoot();
        File currentrel = this.getFile(null, 0, 1);
        File currentabs = this.getFile(canonicalroot, 0, 1);
        File canonicalrel = this.getResolvedRootFile(1, false);
        File canonicalabs = this.getResolvedRootFile(1, true);
        File level = this.getDir(null, 1);
        level.mkdir();
        this.testPhysicalPresence(currentrel, currentabs, canonicalrel, canonicalabs, false);
        this.testPhysicalPresence(currentabs, canonicalrel, canonicalabs, currentrel, false);
        this.testPhysicalPresence(canonicalrel, canonicalabs, currentrel, currentabs, false);
        this.testPhysicalPresence(canonicalabs, currentrel, currentabs, canonicalrel, false);
        this.testPhysicalPresence(currentrel, currentabs, canonicalrel, canonicalabs, true);
        this.testPhysicalPresence(currentabs, canonicalrel, canonicalabs, currentrel, true);
        this.testPhysicalPresence(canonicalrel, canonicalabs, currentrel, currentabs, true);
        this.testPhysicalPresence(canonicalabs, currentrel, currentabs, canonicalrel, true);
        level.delete();
    }

    private final void testPhysicalPresence(File main, File equivalent1, File equivalent2, File equivalent3, boolean isdir) {
        try {
            if (isdir) {
                harness.check(main.mkdir(), "building dir <" + main + '>');
            } else {
                harness.check(main.createNewFile(), "building file <" + main + '>');
            }
            this.checkBasicExisting(equivalent1, isdir);
            this.checkBasicExisting(equivalent2, isdir);
            this.checkBasicExisting(equivalent3, isdir);
            main.delete();
            this.checkBasicNonExisting(equivalent1);
            this.checkBasicNonExisting(equivalent2);
            this.checkBasicNonExisting(equivalent3);
        }
        catch (Exception ex) {
            harness.fail(ex.toString());
        }
    }

    private final void testDeleting(boolean absolute) {
        String root = absolute ? this.getCanonicalRoot() : null;
        this.buildFileStructure(root, 1, 3, true);
        harness.checkPoint("deleting of existing file: should pass");
        File target = this.getFile(root, 1, 3);
        harness.check(target.delete(), "deleting <" + target + '>');
        harness.check(target.exists() ^ true, "<" + target + "> deleted");
        harness.checkPoint("deleting of existing file set read-only: should pass");
        target = this.getFile(root, 1, 2);
        target.setReadOnly();
        harness.check(target.delete(), "deleting <" + target + '>');
        harness.check(target.exists() ^ true, "<" + target + "> deleted");
        harness.checkPoint("deleting of non-existing file : should fail");
        target = this.getFile(root, 1, 0);
        harness.check(target.exists() ^ true, "<" + target + "> non-existing");
        harness.check(target.delete() ^ true, "deleting nonexisting <" + target + "> must fail");
        harness.checkPoint("deleting of non-empty dir : should fail");
        target = this.getDir(root, 1);
        harness.check(target.delete() ^ true, "deleting non-empty dir <" + target + "> must fail");
        harness.checkPoint("deleting of non-existing dir : should fail");
        target = this.getDir(root, 3);
        harness.check(target.exists() ^ true, "<" + target + "> non-existing");
        harness.check(target.delete() ^ true, "deleting non-existing dir <" + target + "> must fail");
        harness.checkPoint("deleting of existing empty dir : should pass");
        target = this.getFile(root, 1, 1);
        harness.check(target.delete(), "deleting <" + target + '>');
        target = this.getDir(root, 1);
        harness.check(target.delete(), "deleting empty dir <" + target + "> should pass");
        harness.check(target.exists() ^ true, "<" + target + "> deleted");
    }

    private final void testRenameFile(boolean absolute) {
        harness.checkPoint("Test renaming of files");
        String root = absolute ? this.getCanonicalRoot() : null;
        File sub1 = absolute ? new File(root, SUBDIR1) : new File(SUBDIR1);
        File sub2 = absolute ? new File(root, SUBDIR2) : new File(SUBDIR2);
        File source = this.getFile(root, 0, 1);
        harness.checkPoint("Renaming files in current dir");
        this.doRenameFileTests(source, this.getFile(null, 0, 2), 0L, false);
        this.doRenameFileTests(source, this.getFile(null, 0, 2), 2000L, true);
        File level1 = this.getDir(null, 1, true);
        harness.checkPoint("Renaming files in different dir");
        this.doRenameFileTests(source, this.getFile(null, 1, 1), 0L, false);
        this.doRenameFileTests(source, this.getFile(null, 1, 1), 2000L, true);
        level1.delete();
        harness.checkPoint("Renaming files to already existing file");
        File target = this.getFile(root, 0, 3, true);
        this.doRenameFileTests(source, target, 0L, false, true, false, false);
        this.doRenameFileTests(source, target, 2000L, true, true, false, false);
        harness.checkPoint("Renaming files to already existing file set to read-only");
        target.setReadOnly();
        this.doRenameFileTests(source, target, 0L, false, true, false, false);
        this.doRenameFileTests(source, target, 2000L, true, true, false, false);
        target.delete();
        harness.checkPoint("Renaming files to already existing directory (must fail)");
        sub1.mkdir();
        this.failRenameFileTests(source, sub1, true, false, "Renaming file to existing directory");
        sub1.delete();
        harness.checkPoint("Renaming directory to other directory");
        this.doRenameFileTests(sub1, sub2, 0L, false, true, true, true);
        this.doRenameFileTests(sub1, sub2, 2000L, true, true, true, true);
        harness.checkPoint("Renaming directory to existing directory");
        sub2.mkdir();
        this.doRenameFileTests(sub1, sub2, 0L, false, true, false, true);
        this.doRenameFileTests(sub1, sub2, 2000L, false, true, false, true);
        sub2.setReadOnly();
        this.doRenameFileTests(sub1, sub2, 0L, false, true, false, true);
        this.doRenameFileTests(sub1, sub2, 2000L, false, true, false, true);
        sub2.delete();
        harness.checkPoint("Renaming directory to existing file");
        target = this.getFile(root, 0, 3, true);
        this.failRenameFileTests(sub1, target, true, true, "target exists and explicitly is a file");
        target.delete();
        harness.checkPoint("Renaming files to unexisting subdir");
        this.failRenameFileTests(source, this.getFile(root, 2, 2), true, false, "target in unexisting subdir");
        harness.checkPoint("Renaming dir to own subdir");
        this.failRenameFileTests(sub1, new File(sub1, "sub3"), true, false, "target is own subdir");
        harness.checkPoint("Renaming non-existing file");
        this.failRenameFileTests(this.getFile(root, 0, 3), this.getFile(root, 0, 2), false, false, "target in unexisting subdir");
        harness.checkPoint("Renaming files nullfile");
        this.throwExRenameFileTests(source, null, "target is null");
    }

    private final void doRenameFileTests(File source, File dest, long creationtime, boolean readonly) {
        this.doRenameFileTests(source, dest, creationtime, readonly, true, true, false);
    }

    private final void doRenameFileTests(File source, File dest, long creationtime, boolean readonly, boolean create, boolean delete, boolean isdir) {
        try {
            long length = 0L;
            if (create && isdir) {
                harness.verbose(source.mkdir() ? "directory <" + source + "> constructed" : "dirctory <" + source + "> already existing");
            } else if (create) {
                harness.verbose(source.createNewFile() ? "File <" + source + "> constructed" : "File <" + source + "> already existing");
            }
            if (!isdir) {
                length = source.length();
            }
            if ((creationtime = creationtime / 1000L * 1000L) > 0L) {
                source.setLastModified(creationtime);
            } else {
                creationtime = source.lastModified();
            }
            if (readonly) {
                source.setReadOnly();
            }
            harness.check(source.renameTo(dest), "Renaming <" + source + "> to <" + dest + "> failed");
            harness.check(dest.exists(), "Renaming <" + source + "> to <" + dest + "> did not build destination dir");
            harness.check(source.delete() ^ true, "Renaming <" + source + "> to <" + dest + "> did not delete original dir");
            harness.check(dest.lastModified(), creationtime, "Renamed file <" + dest + "> did not retain original creation time");
            harness.check(dest.canRead(), "Renamed file <" + dest + "> not allowed to read");
            harness.check(dest.canWrite() ^ (readonly ^ true) ^ true, "Renamed file <" + dest + "> did not retain read-only setting " + readonly);
            if (isdir) {
                harness.check(dest.isDirectory(), "Renamed dir <" + dest + "> is not a directory any longer " + readonly);
            } else {
                harness.check(dest.length(), length, "Renamed file <" + dest + "> did not retain original length " + length);
                harness.check(dest.isFile(), "Renamed file <" + dest + "> is not a file any longer");
            }
            if (delete) {
                harness.verbose(dest.delete() ? "<" + dest + "> deleted" : "<" + dest + "> could not be deleted");
            }
        }
        catch (Exception ex) {
            harness.fail(ex.toString());
        }
    }

    private final void failRenameFileTests(File source, File dest, boolean create, boolean isdir, String reason) {
        try {
            if (create && isdir) {
                harness.verbose(source.mkdir() ? "source dir <" + source + "> constructed" : "source dir <" + source + "> already exists");
            } else if (create) {
                harness.verbose(source.createNewFile() ? "source File <" + source + "> constructed" : "source File <" + source + "> already exists");
            } else {
                harness.verbose(source.exists() ? "destination File <" + source + "> already exists" : "destination File <" + source + "> not existing");
            }
            harness.verbose(dest.exists() ? "destination File <" + dest + "> already exists" : "destination File <" + dest + "> not existing");
            harness.check(source.renameTo(dest) ^ true, "Renaming <" + source + "> to <" + dest + "> (" + reason + ") should fail ");
            harness.verbose(source.delete() ? "File <" + source + "> deleted" : "File <" + source + "> could not be deleted");
            harness.verbose(dest.delete() ? "File <" + dest + "> deleted" : "File <" + dest + "> could not be deleted");
        }
        catch (Exception ex) {
            harness.fail("Renaming <" + source + "> to <" + dest + "> (" + reason + ") threw error : " + ex);
        }
    }

    private final void throwExRenameFileTests(File source, File dest, String reason) {
        try {
            source.renameTo(dest);
            harness.fail("Renaming <" + source + "> to <" + dest + "> (" + reason + ")did not throw desired exception");
            harness.verbose(source.delete() ? "File <" + source + "> deleted" : "File <" + source + "> could not be deleted");
            harness.verbose(dest.delete() ? "File <" + dest + "> deleted" : "File <" + dest + "> could not be deleted");
        }
        catch (Exception ex) {
            harness.check(true, "Renaming <" + source + "> to <" + dest + "> (" + reason + ") threw desired exception : " + ex);
        }
    }

    private final void testListContents(boolean nullfilter, boolean absolute) {
        String filename;
        File rootfile;
        File[] files;
        String[] names;
        String test = "File.list(), File.listFiles() ";
        test = test + (nullfilter ? "NULL filter " : "no filters ");
        test = test + (absolute ? "absolute path" : "relative path");
        harness.checkPoint(test);
        String root = absolute ? this.getCanonicalRoot() : null;
        this.buildFileStructure(root, 3, 5, false);
        String currentpath = this.getCanonicalRoot();
        if (nullfilter) {
            FilenameFilter ourfilter = null;
            names = this.getDir(root, 2).list(ourfilter);
            files = this.getDir(root, 2).listFiles(ourfilter);
        } else {
            names = this.getDir(root, 2).list();
            files = this.getDir(root, 2).listFiles();
        }
        harness.checkPoint("File.list(), File.listFiles() no filters : list sizes");
        harness.check(names.length, 6, "list() : we expect five files file21 to file25 and one directory level3");
        harness.check(files.length, 6, "listFiles() : we expect five files file21 to file25 and one directory level3");
        harness.checkPoint("File.list(), File.listFiles() no filters : files in list");
        int i = 1;
        while (i <= 5) {
            rootfile = this.getFile(root, 2, i);
            filename = "file2" + i + FILEEND;
            harness.check(this.contains(filename, names), "checking existance of string <" + filename + ">in file names list");
            harness.check(this.contains(rootfile, files), "checking existance of file <" + rootfile + ">in files list");
            ++i;
        }
        harness.checkPoint("File.list(), File.listFiles() no filters : dir in list");
        rootfile = this.getDir(root, 3);
        filename = "level_3";
        harness.check(this.contains(filename, names), "checking existance of " + filename + "in root list");
        harness.check(this.contains(rootfile, files), "checking existance of " + rootfile + "in root list");
        this.deleteFileStructure(root, 3, 5, false);
    }

    private final void testListFilteredContents(boolean absolute) {
        String filename;
        File rootfile;
        String test = "File.list(), File.listFiles() ";
        test = test + (absolute ? "absolute path" : "relative path");
        harness.checkPoint(test + " Specified FilenameFilter instance");
        String root = absolute ? this.getCanonicalRoot() : null;
        this.buildFileStructure(root, 3, 5, false);
        NumberOneFilter ourfilter = new NumberOneFilter();
        String[] names = this.getDir(root, 2).list(ourfilter);
        File[] files = this.getDir(root, 2).listFiles(ourfilter);
        harness.checkPoint("File.list(), File.listFiles() no filters : list sizes");
        harness.check(names.length, 2, "list() : we expect the filter to list only two files file21 and  directory level3");
        harness.check(files.length, 2, "listFiles() : we expect the filter to list only two files file21 and  directory level3");
        harness.checkPoint("File.list(), File.listFiles() discrete FinenameFilter : files discarted");
        int i = 2;
        while (i <= 5) {
            rootfile = this.getFile(root, 2, i);
            filename = "file2" + i + FILEEND;
            harness.check(this.contains(filename, names) ^ true, "checking existance of " + filename + "in full list : suppressed by filter");
            harness.check(this.contains(rootfile, files) ^ true, "checking existance of " + rootfile + "in root list : suppressed by filter");
            ++i;
        }
        harness.checkPoint("File.list(), File.listFiles() discrete FinenameFilter : file retained");
        rootfile = this.getFile(root, 2, 1);
        filename = "file21.scr";
        harness.check(this.contains(filename, names), "checking existance of " + filename + "in root list");
        harness.check(this.contains(rootfile, files), "checking existance of " + rootfile + "in root list");
        harness.checkPoint("File.list(), File.listFiles() no filters : dir in list");
        rootfile = this.getDir(root, 3);
        filename = "level_3";
        harness.check(this.contains(filename, names), "checking existance of " + filename + "in root list");
        harness.check(this.contains(rootfile, files), "checking existance of " + rootfile + "in root list");
        this.deleteFileStructure(root, 3, 5, false);
    }

    private final boolean contains(File target, File[] items) {
        boolean result = false;
        int i = 0;
        while (i < items.length && !result) {
            result = target.equals(items[i]);
            ++i;
        }
        return result;
    }

    private final boolean contains(String target, String[] items) {
        boolean result = false;
        int i = 0;
        while (i < items.length && !result) {
            result = target.equals(items[i]);
            ++i;
        }
        return result;
    }

    private final String getCanonicalRoot() {
        String root = "";
        try {
            File zerodir = new File("");
            root = zerodir.getCanonicalPath();
        }
        catch (IOException iox) {
            harness.fail("IO exception constructing current dir : " + iox.toString());
        }
        return root;
    }

    private final File getCanonicalDir() {
        File root = null;
        try {
            File zerodir = new File("");
            root = zerodir.getCanonicalFile();
        }
        catch (IOException iox) {
            harness.fail("IO exception constructing current dir : " + iox.toString());
        }
        return root;
    }

    private final File getResolvedRootFile(int fileno, boolean absolute) {
        File root = null;
        try {
            String rootstring = "";
            if (absolute) {
                File zerodir = new File("");
                rootstring = zerodir.getCanonicalPath();
                rootstring = rootstring + File.separator;
            }
            rootstring = rootstring + "level_1" + File.separator;
            rootstring = rootstring + ".." + File.separator;
            rootstring = rootstring + "file0" + fileno + FILEEND;
            root = new File(rootstring);
        }
        catch (IOException iox) {
            harness.fail("IO exception constructing current dir : " + iox.toString());
        }
        return root;
    }

    private final File getResolvedRootDir(String testdir, boolean absolute) {
        File root = null;
        try {
            String rootstring = "";
            if (absolute) {
                File zerodir = new File("");
                rootstring = zerodir.getCanonicalPath();
                rootstring = rootstring + File.separator;
            }
            rootstring = rootstring + "level_1" + File.separator;
            rootstring = rootstring + ".." + File.separator;
            rootstring = rootstring + ".." + testdir;
            root = new File(rootstring);
        }
        catch (IOException iox) {
            harness.fail("IO exception constructing current dir : " + iox.toString());
        }
        return root;
    }

    private final void testListRoots() {
        if (File.separatorChar == '/') {
            harness.checkPoint("testing File.listRoots() for Unix/Linux system");
            File[] roots = File.listRoots();
            harness.check(roots.length, 1, "root for linux should return only one element");
            harness.check(roots[0].getPath(), "/", "root for linux should return '/'");
        }
    }

    public void checkBasicExisting(File testfile, boolean isdirectory) {
        harness.check(testfile.exists(), "newly created file must exist");
        if (isdirectory) {
            harness.check(testfile.isDirectory(), "explicitly created as directory");
            harness.check(testfile.isFile() ^ true, "explicitly created as directory, not as file");
        } else {
            harness.check(testfile.isDirectory() ^ true, "explicitly created as file, not as directory");
            harness.check(testfile.isFile(), "explicitly created as file");
        }
        harness.check(testfile.canRead(), "created without special read/write definitions must alow read");
        harness.check(testfile.canWrite(), "created without special read/write definitions must alow write");
        boolean bl = false;
        if (testfile.lastModified() > 0L) {
            bl = true;
        }
        harness.check(bl, "lastModified() is time in milliseconds");
        if (!isdirectory) {
            harness.check(testfile.length(), 0L, "Newly created file has length 0");
        }
    }

    public void checkBasicNonExisting(File testfile) {
        harness.check(testfile.exists() ^ true, "Deleted file can not exist");
        harness.check(testfile.isDirectory() ^ true, "isDirectory() Deleted file false by definition");
        harness.check(testfile.isFile() ^ true, "isFile() Deleted file false by definition");
        harness.check(testfile.canRead() ^ true, "canRead() Deleted file false by definition");
        harness.check(testfile.canWrite() ^ true, "canWrite() Deleted file false by definition");
        harness.check(testfile.lastModified(), 0L, "lastModified() Deleted file null by definition");
        harness.check(testfile.length(), 0L, "nonexisting file has length 0 by definition");
    }

    private final String getFilePath(String root, int levelno, int fileno) {
        String path = this.getDirPath(root, levelno);
        path = path + FILESTUB + levelno + fileno + FILEEND;
        return path;
    }

    private final String getFilePath(int levelno, int fileno) {
        return this.getFilePath(null, levelno, fileno);
    }

    private final File getFile(String root, int levelno, int fileno, boolean create) {
        File testfile = null;
        try {
            testfile = new File(this.getFilePath(root, levelno, fileno));
            if (create) {
                testfile.createNewFile();
            }
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
        return testfile;
    }

    private final File getFile(int levelno, int fileno, boolean create) {
        return this.getFile(null, levelno, fileno, create);
    }

    private final File getFile(String root, int levelno, int fileno) {
        return this.getFile(root, levelno, fileno, false);
    }

    private final File getFile(int levelno, int fileno) {
        return this.getFile(null, levelno, fileno, false);
    }

    private final String getDirPath(String root, int levelno) {
        String path = this.updateRoot(root);
        int i = 1;
        while (i <= levelno) {
            path = path + DIRSTUB + i + File.separator;
            ++i;
        }
        return path;
    }

    private final String getDirPath(int levelno) {
        return this.getDirPath(null, levelno);
    }

    private final File getDir(String root, int levelno, boolean create) {
        File testdir = null;
        try {
            testdir = new File(this.getDirPath(root, levelno));
            if (create) {
                testdir.mkdir();
            }
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
        return testdir;
    }

    private final File getDir(int levelno, boolean create) {
        return this.getDir(null, levelno, create);
    }

    private final File getDir(String root, int levelno) {
        return this.getDir(root, levelno, false);
    }

    private final File getDir(int levelno) {
        return this.getDir(null, levelno, false);
    }

    private final String updateRoot(String root) {
        String path = "";
        if (root != null) {
            path = root.trim();
            if (path.equals(File.separator)) {
                path = "";
            } else if (path.length() > 0 && !path.endsWith(File.separator)) {
                path = path + File.separator;
            }
        }
        return path;
    }

    public void buildFileStructure(int endlevel, int filesperlevel, boolean checkexists) {
        this.buildFileStructure(null, 1, endlevel, filesperlevel, checkexists);
    }

    public void buildFileStructure(String root, int endlevel, int filesperlevel, boolean checkexists) {
        this.buildFileStructure(root, 1, endlevel, filesperlevel, checkexists);
    }

    public void buildFileStructure(String root, int currentlevel, int endlevel, int filesperlevel, boolean checkexists) {
        this.mkdir(this.getDir(root, currentlevel), checkexists);
        int i = 1;
        while (i <= filesperlevel) {
            this.createNewFile(this.getFile(root, currentlevel, i), checkexists);
            ++i;
        }
        if (currentlevel < endlevel) {
            this.buildFileStructure(root, currentlevel + 1, endlevel, filesperlevel, checkexists);
        }
    }

    public void deleteFileStructure(int currentlevel, int filesperlevel, boolean checkexists) {
        this.deleteFileStructure(null, 1, currentlevel, filesperlevel, checkexists);
    }

    public void deleteFileStructure(String root, int currentlevel, int filesperlevel, boolean checkexists) {
        this.deleteFileStructure(root, 1, currentlevel, filesperlevel, checkexists);
    }

    public void deleteFileStructure(String root, int stoplevel, int currentlevel, int filesperlevel, boolean checkexists) {
        int i = 1;
        while (i <= filesperlevel) {
            this.delete(this.getFile(root, currentlevel, i), checkexists);
            ++i;
        }
        this.delete(this.getDir(root, currentlevel), checkexists);
        if (currentlevel > stoplevel) {
            this.deleteFileStructure(root, stoplevel, currentlevel - 1, filesperlevel, checkexists);
        }
    }

    private final void mkdir(File target, boolean checkexists) {
        boolean result = target.mkdir();
        if (checkexists) {
            harness.check(result, "directory <" + target + "> already existing");
        }
    }

    private final void createNewFile(File target, boolean checkexists) {
        try {
            boolean result = target.createNewFile();
            if (checkexists) {
                harness.check(result, "File <" + target + "> already existing");
            }
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
    }

    private final void delete(File target, boolean checkexists) {
        boolean result = target.delete();
        if (checkexists) {
            harness.check(result, "File or directory <" + target + "> already deleted");
        }
    }

    public void test(TestHarness newharness) {
        harness = newharness;
        harness.setclass("java.io.File");
        File onexittest = null;
        harness.checkPoint("deleteonexit: building and marking file");
        try {
            onexittest = new File("existswhilerunning.txt");
            harness.check(onexittest.exists() ^ true, "should be deleted by last time program was running");
            harness.check(onexittest.createNewFile(), "Creating non-existing file");
            onexittest.deleteOnExit();
            harness.check(onexittest.exists(), "marked for deletion, but not yet deleted");
        }
        catch (Exception e) {
            harness.fail(e.toString());
        }
        this.testClass();
        this.testConstruction(true);
        this.testConstruction(false);
        this.testCanonicalConstruction();
        this.testDeleting(true);
        this.testDeleting(false);
        this.testRenameFile(true);
        this.testRenameFile(false);
        harness.fail("File.createTempFile() not yet defined for Wonka");
        this.testListContents(false, true);
        this.testListContents(false, false);
        this.testListContents(true, true);
        this.testListContents(true, false);
        this.testListFilteredContents(true);
        this.testListFilteredContents(false);
        this.testListRoots();
        harness.checkPoint("deleteonexit: last check on marked file");
        harness.check(onexittest.exists(), "marked for deletion, but not yet deleted");
        this.testListFilteredContents(true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class NumberOneFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            boolean bl = false;
            if (name.endsWith("1.scr") || name.startsWith("level")) {
                bl = true;
            }
            return bl;
        }

        NumberOneFilter() {
        }
    }
}

