/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.io.CharArrayReader;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.io.CharArrayReader.SMExCharArrayReader;
import gnu.testlet.wonka.io.CharArrayReader.SMlockCharArrayReader;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMCharArrayReaderTest
implements Testlet {
    protected TestHarness th;
    protected int accesed;
    protected char[] ca;
    private Thread t;
    private volatile boolean f1;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.io.CharArrayReader");
        this.test_CharArrayReader();
        this.test_mark();
        this.test_markSupported();
        this.test_reset();
        this.test_read();
        this.test_skip();
        this.test_close();
        this.test_ready();
        this.test_lock();
    }

    public void inc() {
        ++this.accesed;
    }

    public void test_CharArrayReader() {
        this.th.checkPoint("CharArrayReader(char[])");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        boolean bl = false;
        if (xar.getcount() == this.ca.length) {
            bl = true;
        }
        this.th.check(bl, "all chars are used -- 1");
        boolean bl2 = false;
        if (xar.getbuf() == this.ca) {
            bl2 = true;
        }
        this.th.check(bl2, "reference is used, not a copy -- 1");
        boolean bl3 = false;
        if (xar.getpos() == 0) {
            bl3 = true;
        }
        this.th.check(bl3, "start reading at pos 0 -- 1");
        boolean bl4 = false;
        if (xar.getmpos() == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "markedPos is 0 -- 1");
        try {
            new SMExCharArrayReader(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        char[] ca1 = new char[]{};
        xar = new SMExCharArrayReader(ca1);
        boolean bl5 = false;
        if (xar.getcount() == ca1.length) {
            bl5 = true;
        }
        this.th.check(bl5, "all chars are used -- 2");
        boolean bl6 = false;
        if (xar.getbuf() == ca1) {
            bl6 = true;
        }
        this.th.check(bl6, "reference is used, not a copy -- 2");
        boolean bl7 = false;
        if (xar.getpos() == 0) {
            bl7 = true;
        }
        this.th.check(bl7, "start reading at pos 0 -- 2");
        boolean bl8 = false;
        if (xar.getmpos() == 0) {
            bl8 = true;
        }
        this.th.check(bl8, "markedPos is 0 -- 2");
        this.th.checkPoint("CharArrayReader(char[],int,int)");
        xar = new SMExCharArrayReader(this.ca, 10, 10);
        boolean bl9 = false;
        if (xar.getcount() == 20) {
            bl9 = true;
        }
        this.th.check(bl9, "this.count = offset+count -- 1");
        boolean bl10 = false;
        if (xar.getbuf() == this.ca) {
            bl10 = true;
        }
        this.th.check(bl10, "reference is used, not a copy -- 1");
        boolean bl11 = false;
        if (xar.getpos() == 10) {
            bl11 = true;
        }
        this.th.check(bl11, "start reading at pos 10 -- 1");
        boolean bl12 = false;
        if (xar.getmpos() == 10) {
            bl12 = true;
        }
        this.th.check(bl12, "markedPos is 10 -- 1");
        xar = new SMExCharArrayReader(this.ca, 10, 100);
        boolean bl13 = false;
        if (xar.getcount() == this.ca.length) {
            bl13 = true;
        }
        this.th.check(bl13, "this.count = offset+count -- 2");
        boolean bl14 = false;
        if (xar.getbuf() == this.ca) {
            bl14 = true;
        }
        this.th.check(bl14, "reference is used, not a copy -- 2");
        boolean bl15 = false;
        if (xar.getpos() == 10) {
            bl15 = true;
        }
        this.th.check(bl15, "start reading at pos 10 -- 2");
        boolean bl16 = false;
        if (xar.getmpos() == 10) {
            bl16 = true;
        }
        this.th.check(bl16, "markedPos is 10 -- 2");
        try {
            xar = new SMExCharArrayReader(this.ca, 100, 100);
            this.th.fail("should throw an ?????-Exception");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        try {
            xar = new SMExCharArrayReader(this.ca, -1, 100);
            this.th.fail("should throw an ?????-Exception");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        try {
            xar = new SMExCharArrayReader(this.ca, 1, -10);
            this.th.fail("should throw an ?????-Exception");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        try {
            new SMExCharArrayReader(null, 1, 2);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_mark() {
        this.th.checkPoint("mark(int)void");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        try {
            xar.skip(5);
            xar.mark(123456);
            boolean bl = false;
            if (xar.getpos() == xar.getmpos()) {
                bl = true;
            }
            this.th.check(bl, "pos == markedPos after a mark");
            boolean bl2 = false;
            if (xar.getmpos() == 5) {
                bl2 = true;
            }
            this.th.check(bl2, "makerdPos should be 5");
            xar.read();
            xar.mark(-123456);
            boolean bl3 = false;
            if (xar.getmpos() == 6) {
                bl3 = true;
            }
            this.th.check(bl3, "makerdPos should be 6");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e);
        }
    }

    public void test_markSupported() {
        this.th.checkPoint("markSupported()boolean");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        this.th.check(xar.markSupported(), "always returns true");
    }

    public void test_reset() {
        this.th.checkPoint("reset()void");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        try {
            xar.skip(5);
            xar.reset();
            boolean bl = false;
            if (xar.getpos() == 0) {
                bl = true;
            }
            this.th.check(bl, "pos should be 0");
            xar.skip(5);
            xar.mark(123456);
            xar.skip(15L);
            xar.reset();
            boolean bl2 = false;
            if (xar.getpos() == 5) {
                bl2 = true;
            }
            this.th.check(bl2, "pos should be 5");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
        xar = new SMExCharArrayReader(this.ca, 13, 33);
        try {
            xar.skip(5);
            xar.reset();
            boolean bl = false;
            if (xar.getpos() == 13) {
                bl = true;
            }
            this.th.check(bl, "pos should be 13");
            xar.skip(5);
            xar.mark(123456);
            xar.skip(15L);
            xar.reset();
            boolean bl3 = false;
            if (xar.getpos() == 18) {
                bl3 = true;
            }
            this.th.check(bl3, "pos should be 18");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
    }

    public void test_read() {
        int i;
        this.th.checkPoint("read()int");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        try {
            char c = (char)xar.read();
            boolean bl = false;
            if (xar.getpos() == 1) {
                bl = true;
            }
            this.th.check(bl, "pos should be 1");
            boolean bl2 = false;
            if (c == 'a') {
                bl2 = true;
            }
            this.th.check(bl2, "check char value got:" + c);
            c = (char)xar.read();
            boolean bl3 = false;
            if (xar.getpos() == 2) {
                bl3 = true;
            }
            this.th.check(bl3, "pos should be 1");
            boolean bl4 = false;
            if (c == 'b') {
                bl4 = true;
            }
            this.th.check(bl4, "check char value got:" + c);
            xar.skip(5);
            c = (char)xar.read();
            boolean bl5 = false;
            if (c == '\n') {
                bl5 = true;
            }
            this.th.check(bl5, "check char value got:" + c);
            xar.skip(50L);
            i = xar.read();
            boolean bl6 = false;
            if (i == -1) {
                bl6 = true;
            }
            this.th.check(bl6, "check char value got:" + i);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
        this.th.checkPoint("read(char[],int,int)int");
        xar = new SMExCharArrayReader(this.ca);
        char[] ca1 = new char[15];
        try {
            i = xar.read(ca1, 0, 15);
            boolean bl = false;
            if (i == 15) {
                bl = true;
            }
            this.th.check(bl, "15 chars should be read, got:" + i);
            boolean bl7 = false;
            if (xar.getpos() == 15) {
                bl7 = true;
            }
            this.th.check(bl7, "pos should be 15, got:" + xar.getpos());
            this.th.check("abcdefg\nhijklmn".equals(new String(ca1)), "checking contents of char[] -- 1 :" + new String(ca1));
            i = xar.read(ca1, 5, 5);
            boolean bl8 = false;
            if (xar.getpos() == 20) {
                bl8 = true;
            }
            this.th.check(bl8, "pos should be 20, got:" + xar.getpos());
            this.th.check("abcdeop\nqrjklmn".equals(new String(ca1)), "checking contents of char[] -- 2 :" + new String(ca1));
            boolean bl9 = false;
            if (i == 5) {
                bl9 = true;
            }
            this.th.check(bl9, "5 chars should be read, got:" + i);
            i = xar.read(ca1, 2, 13);
            boolean bl10 = false;
            if (xar.getpos() == this.ca.length) {
                bl10 = true;
            }
            this.th.check(bl10, "pos should be 29, got:" + xar.getpos());
            this.th.check("abstuvwxyz\nklmn".equals(new String(ca1)), "checking contents of char[] -- 3 :" + new String(ca1));
            boolean bl11 = false;
            if (i == 9) {
                bl11 = true;
            }
            this.th.check(bl11, "9 chars should be read, got:" + i);
            i = xar.read(ca1, 2, 5);
            boolean bl12 = false;
            if (xar.getpos() == this.ca.length) {
                bl12 = true;
            }
            this.th.check(bl12, "pos should be 29, got:" + xar.getpos());
            this.th.check("abstuvwxyz\nklmn".equals(new String(ca1)), "checking contents of char[] -- 4 :" + new String(ca1));
            boolean bl13 = false;
            if (i == -1) {
                bl13 = true;
            }
            this.th.check(bl13, "no chars should be read, got:" + i);
            xar.reset();
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
        try {
            xar.read(null, 0, 15);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 2");
        }
        try {
            xar.read(ca1, 16, 0);
            this.th.fail("should throw a IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 3");
        }
        try {
            xar.read(ca1, -1, 5);
            this.th.fail("should throw a IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 4");
        }
        try {
            xar.read(ca1, 1, -5);
            this.th.fail("should throw a IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 5");
        }
        try {
            xar.read(ca1, 10, 6);
            this.th.fail("should throw a IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ne) {
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 6");
        }
    }

    public void test_skip() {
        this.th.checkPoint("skip(long)long");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        try {
            long l = xar.skip(5);
            boolean bl = false;
            if (xar.getpos() == 5) {
                bl = true;
            }
            this.th.check(bl, "pos should be 5");
            boolean bl2 = false;
            if (l == (long)5) {
                bl2 = true;
            }
            this.th.check(bl2, "l should be 5 -- 1");
            l = xar.skip(5);
            boolean bl3 = false;
            if (xar.getpos() == 10) {
                bl3 = true;
            }
            this.th.check(bl3, "pos should be 10");
            boolean bl4 = false;
            if (l == (long)5) {
                bl4 = true;
            }
            this.th.check(bl4, "l should be 5 -- 2");
            l = xar.skip(15L);
            boolean bl5 = false;
            if (xar.getpos() == 25) {
                bl5 = true;
            }
            this.th.check(bl5, "pos should be 25");
            boolean bl6 = false;
            if (l == 15L) {
                bl6 = true;
            }
            this.th.check(bl6, "l should be 15");
            l = xar.skip(15L);
            boolean bl7 = false;
            if (xar.getpos() == 29) {
                bl7 = true;
            }
            this.th.check(bl7, "pos should be 29 -- 1");
            boolean bl8 = false;
            if (l == (long)4) {
                bl8 = true;
            }
            this.th.check(bl8, "l should be 4");
            l = xar.skip(15L);
            boolean bl9 = false;
            if (xar.getpos() == 29) {
                bl9 = true;
            }
            this.th.check(bl9, "pos should be 29 -- 2");
            boolean bl10 = false;
            if (l == 0L) {
                bl10 = true;
            }
            this.th.check(bl10, "l should be 0 -- 1");
            xar.reset();
            l = xar.skip(-15L);
            boolean bl11 = false;
            if (l == 0L) {
                bl11 = true;
            }
            this.th.check(bl11, "l should be 0 -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
    }

    public void test_close() {
        this.th.checkPoint("close()void");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        try {
            xar.close();
            xar.close();
            xar.close();
            xar.close();
            this.th.check(true);
            boolean bl = false;
            if (xar.getbuf() == null) {
                bl = true;
            }
            this.th.check(bl, "make sure resources are released");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
        try {
            xar.read();
            this.th.fail("should throw IOException after close -- read() 1");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.read(new char[6], 1, 3);
            this.th.fail("should throw IOException after close -- read() 2");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.skip(3);
            this.th.fail("should throw IOException after close -- skip()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.mark(23);
            this.th.fail("should throw IOException after close -- mark()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.reset();
            this.th.fail("should throw IOException after close -- reset()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
        try {
            xar.ready();
            this.th.fail("should throw IOException after close -- ready()");
        }
        catch (IOException ioe) {
            this.th.check(true);
        }
    }

    public void test_ready() {
        this.th.checkPoint("ready()boolean");
        SMExCharArrayReader xar = new SMExCharArrayReader(this.ca);
        try {
            this.th.check(xar.ready(), "returns true -- 1");
            xar.skip(45L);
            this.th.check(xar.ready() ^ true, "returns false EOF reached -- 2");
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception: " + e + " -- 1");
        }
    }

    public void test_lock() {
        this.th.checkPoint("lock(protected)java.lang.Object");
        SMlockCharArrayReader lt = new SMlockCharArrayReader();
        SMExCharArrayReader xr = new SMExCharArrayReader(this.ca);
        int i = this.setupLockThread(lt, xr);
        try {
            xr.mark(2);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = false;
        if (i + 1 == this.accesed) {
            bl = true;
        }
        this.th.check(bl, "accesed xr before lock was released -- mark");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockCharArrayReader();
        i = this.setupLockThread(lt, xr);
        try {
            xr.reset();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl2 = false;
        if (i + 1 == this.accesed) {
            bl2 = true;
        }
        this.th.check(bl2, "accesed xr before lock was released -- reset");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockCharArrayReader();
        i = this.setupLockThread(lt, xr);
        try {
            xr.read();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl3 = false;
        if (i + 1 == this.accesed) {
            bl3 = true;
        }
        this.th.check(bl3, "accesed xr before lock was released -- read()");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockCharArrayReader();
        i = this.setupLockThread(lt, xr);
        try {
            xr.read(new char[2]);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl4 = false;
        if (i + 1 == this.accesed) {
            bl4 = true;
        }
        this.th.check(bl4, "accesed xr before lock was released -- read(char[])");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockCharArrayReader();
        i = this.setupLockThread(lt, xr);
        try {
            xr.read(new char[2], 0, 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl5 = false;
        if (i + 1 == this.accesed) {
            bl5 = true;
        }
        this.th.check(bl5, "accesed xr before lock was released -- read(char[],int,int)");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockCharArrayReader();
        i = this.setupLockThread(lt, xr);
        try {
            xr.ready();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl6 = false;
        if (i + 1 == this.accesed) {
            bl6 = true;
        }
        this.th.check(bl6, "accesed xr before lock was released -- ready");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockCharArrayReader();
        i = this.setupLockThread(lt, xr);
        try {
            xr.skip(30L);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl7 = false;
        if (i + 1 == this.accesed) {
            bl7 = true;
        }
        this.th.check(bl7, "accesed xr before lock was released -- skip");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lt = new SMlockCharArrayReader();
        i = this.setupLockThread(lt, xr);
        try {
            xr.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl8 = false;
        if (i + 1 == this.accesed) {
            bl8 = true;
        }
        this.th.check(bl8, "accesed xr before lock was released -- close");
        try {
            this.t.join(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int setupLockThread(SMlockCharArrayReader lt, SMExCharArrayReader xr) {
        this.f1 = false;
        lt.setXReader(xr);
        lt.setTestHarness(this.th);
        lt.setRT(this);
        this.t = new Thread(lt);
        this.t.start();
        while (!this.f1) {
            Thread.yield();
        }
        return this.accesed;
    }

    public void set1() {
        this.f1 = true;
    }

    private final /* synthetic */ void this() {
        this.accesed = 0;
        this.ca = "abcdefg\nhijklmnop\nqrstuvwxyz\n".toCharArray();
        this.t = null;
        this.f1 = false;
    }

    public SMCharArrayReaderTest() {
        this.this();
    }
}

