/*
 * Decompiled with CFR 0.152.
 */
package JUnitTests;

import gnu.testlet.Mv_Assert;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TEST_BufferedInputStream
extends Mv_Assert {
    private InputStream getDataSource(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(i % 255);
        }
        return new ByteArrayInputStream(buf);
    }

    public void testRead1() throws Exception {
        byte[] buf = new byte[100];
        BufferedInputStream bis = new BufferedInputStream(this.getDataSource(buf), 10);
        for (int i = 0; i < buf.length; ++i) {
            int readed = bis.read();
            if (readed == buf[i]) continue;
            TEST_BufferedInputStream.fail("wrong byte read - read:" + readed + ", buf[" + i + "]:" + buf[i]);
        }
        if (bis.read() != -1) {
            TEST_BufferedInputStream.fail("failed (read() didn't return -1 at end of stream");
        }
    }

    public void testRead2() throws Exception {
        int readed;
        byte[] buf = new byte[100];
        BufferedInputStream bis = new BufferedInputStream(this.getDataSource(buf), 10);
        int len = 30;
        byte[] b = new byte[buf.length + len];
        for (int offset = 0; offset < buf.length; offset += readed) {
            readed = bis.read(b, offset, len);
            if (readed == -1) {
                TEST_BufferedInputStream.fail("EOF reached too soon, offset=" + offset);
            }
            for (int i = offset; i < offset + readed; ++i) {
                if (b[i] == buf[i]) continue;
                TEST_BufferedInputStream.fail("wrong byte read - b[" + i + "]=" + b[i] + ", buf[" + i);
            }
        }
        if (bis.read() != -1) {
            TEST_BufferedInputStream.fail("EOF no thrown in time");
        }
    }

    public void testSkip1() throws Exception {
        byte[] buf = new byte[100];
        BufferedInputStream bis = new BufferedInputStream(this.getDataSource(buf), 10);
        int skipped = 20;
        for (long toSkip = (long)skipped; toSkip > 0L; toSkip -= bis.skip(toSkip)) {
        }
        int readed = bis.read();
        if ((byte)readed != buf[skipped]) {
            TEST_BufferedInputStream.fail("Wrong byte read after skip - read:" + readed + ", expected:" + buf[skipped]);
        }
    }

    public void testMark1() throws Exception {
        byte[] buf = new byte[100];
        BufferedInputStream bis = new BufferedInputStream(this.getDataSource(buf), 10);
        int markPos = 10;
        for (int i = 0; i < markPos; ++i) {
            bis.read();
        }
        int readLimit = 89;
        bis.mark(readLimit);
        for (int i = 0; i < readLimit / 2; ++i) {
            bis.read();
        }
        bis.reset();
        int readed = bis.read();
        if ((byte)readed != buf[markPos]) {
            TEST_BufferedInputStream.fail("Stream not reset at right position");
        }
        bis.reset();
        for (int i = 0; i < readLimit + 1; ++i) {
            bis.read();
        }
        try {
            bis.reset();
            TEST_BufferedInputStream.fail("No exception thrown when resetting after readLimit");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

