/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.misc;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class MemoryUsage
extends VisualTestImpl {
    private static int history = 100;
    private static int f1 = 1;
    private static int f2 = 50;
    private static LinkedList ll1;
    private static LinkedList ll2;
    private static LinkedList ll3;
    private static LinkedList ll4;
    private static long totalMem;
    private static long minMem;
    private static long maxMem;
    private static int count;
    private static Color c1;
    private static Color c2;
    private static Color c3;
    private static Color c4;

    public MemoryUsage() {
        long avg;
        long max;
        long min;
        long mem = totalMem - Runtime.getRuntime().freeMemory();
        minMem = mem < minMem ? mem : minMem;
        long l = maxMem = mem > maxMem ? mem : maxMem;
        if (count % f1 == 0) {
            ll1.addLast(new Long(mem));
            if (ll1.size() > history) {
                ll1.removeFirst();
            }
        }
        if (count % f2 == 0) {
            ll2.addLast(new Long(mem));
            if (ll2.size() > history) {
                ll2.removeFirst();
            }
        }
        if (count % (f1 * history) == 0) {
            min = (Long)Collections.min(ll1);
            max = (Long)Collections.max(ll1);
            avg = (max + min) / 2L;
            ll3.addLast(new Long(avg));
            if (ll3.size() > history) {
                ll3.removeFirst();
            }
        }
        if (count % (f2 * history) == 0) {
            min = (Long)Collections.min(ll2);
            max = (Long)Collections.max(ll2);
            avg = (max + min) / 2L;
            ll4.addLast(new Long(avg));
            if (ll4.size() > history) {
                ll4.removeFirst();
            }
        }
        ++count;
    }

    public void grid(Graphics g) {
        long min = minMem;
        long max = maxMem;
        int sw1 = g.getFontMetrics().stringWidth("000000000000");
        int sw2 = g.getFontMetrics().stringWidth("Maximal memory usage: 000000000000 bytes");
        int sh = g.getFontMetrics().getHeight();
        int topmargin = sh * 4;
        int bottommargin = this.getHeight() - sh;
        int height = bottommargin - topmargin;
        int w = this.getWidth();
        int mega = 0x100000;
        g.setColor(Color.blue.brighter());
        int y = topmargin;
        g.drawLine(0, y, w - 1, y);
        g.drawString(totalMem / (long)mega + "M", 5, y - 1);
        y = (3 * topmargin + bottommargin) / 4;
        g.drawLine(0, y, w - 1, y);
        g.drawString(totalMem * 3L / 4L / (long)mega + "M", 5, y - 1);
        y = (topmargin + bottommargin) / 2;
        g.drawLine(0, y, w - 1, y);
        g.drawString(totalMem / 2L / (long)mega + "M", 5, y - 1);
        y = (topmargin + 3 * bottommargin) / 4;
        g.drawLine(0, y, w - 1, y);
        g.drawString(totalMem / 4L / (long)mega + "M", 5, y - 1);
        y = bottommargin;
        g.drawLine(0, y, w - 1, y);
        g.drawString("0", 5, y - 1);
        g.setColor(Color.red.brighter());
        y = (int)((long)bottommargin - maxMem * (long)height / totalMem);
        g.drawLine(0, y, w - 1, y);
        g.drawString("" + maxMem, w - sw1, y - 1);
        g.setColor(Color.green.darker());
        y = (int)((long)bottommargin - minMem * (long)height / totalMem);
        g.drawLine(0, y, w - 1, y);
        g.drawString("" + minMem, w - sw1, y + sh);
        g.setColor(Color.black);
        g.drawString("Ran " + count + " times.", 5, sh);
        g.drawString("x-axis: time", 5, sh * 2);
        g.drawString("y-axis: memory in use", 5, sh * 3);
        g.drawString("Minimal memory usage: " + minMem + " bytes.", w - sw2 - 5, sh * 2);
        g.drawString("Maximal memory usage: " + maxMem + " bytes.", w - sw2 - 5, sh * 3);
    }

    public void plot(LinkedList ll, Graphics g, Color c, String s) {
        int i = 0;
        int x0 = 0;
        int y0 = 0;
        int w = this.getWidth();
        int sw = g.getFontMetrics().stringWidth(s + "  ");
        int sh = g.getFontMetrics().getHeight();
        if (ll.size() > 0) {
            long n;
            int topmargin = sh * 4;
            int bottommargin = this.getHeight() - sh;
            int height = bottommargin - topmargin;
            g.setColor(c);
            Iterator iterator = ll.iterator();
            if (iterator.hasNext()) {
                n = (Long)iterator.next();
                y0 = (int)((long)bottommargin - n * (long)height / totalMem);
            }
            while (iterator.hasNext()) {
                int x1 = (w - 1) * i / history;
                n = (Long)iterator.next();
                int y1 = (int)((long)bottommargin - n * (long)height / totalMem);
                g.drawLine(x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
                ++i;
            }
        }
        g.drawString(s, x0 > sw ? x0 - sw : 0, y0);
    }

    public void paint(Graphics g) {
        this.grid(g);
        this.plot(ll1, g, c1, "last " + history * f1);
        this.plot(ll2, g, c2, "last " + history * f2);
        this.plot(ll3, g, c3, "average over " + history * f1);
        this.plot(ll4, g, c4, "average over " + history * f2);
    }

    public String getHelpText() {
        return "Plots the memory usage into a chart.";
    }

    static {
        count = 1;
        totalMem = Runtime.getRuntime().totalMemory();
        maxMem = minMem = totalMem - Runtime.getRuntime().freeMemory();
        ll1 = new LinkedList();
        ll2 = new LinkedList();
        ll3 = new LinkedList();
        ll4 = new LinkedList();
        c1 = Color.red.darker();
        c2 = Color.yellow.darker();
        c3 = Color.green.darker();
        c4 = Color.blue.darker();
    }
}

