/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.misc;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;

public class BenchRect
extends VisualTestImpl {
    public String getHelpText() {
        return "A microbenchmark to benchmark the performance of Rudolph's rendering engine, in particular by using java.awt.Graphics.DrawRect().";
    }

    public Panel getPanel(VisualTester vt) {
        this.vt = vt;
        return new BCanvas();
    }

    public void start(Panel p, boolean autorun) {
        try {
            new Thread((Runnable)((BCanvas)p), "BenchRect thread").start();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void stop(Panel p) {
        try {
            ((BCanvas)p).stop = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    class BCanvas
    extends Panel
    implements Runnable {
        boolean stop = false;
        long rate;
        long prev;
        long next;
        int x;

        public void paint(Graphics g) {
            this.x = (this.x + 3) % this.getWidth();
            g.setColor(Color.red);
            g.fillRect(this.x, 20, 20, this.getHeight() - 20);
            ++this.next;
            if (System.currentTimeMillis() > this.prev + 1000L) {
                this.prev = System.currentTimeMillis();
                this.rate = this.next;
                this.next = 0L;
            }
            g.drawString(this.rate + " frames/rectangles per second", 10, 10);
        }

        public void run() {
            System.out.println("started");
            try {
                int w1 = 0;
                int h1 = 0;
                int w2 = 400;
                int h2 = 234;
                while (w1 == 0 || h1 == 0 || w1 != w2 || h1 != h2) {
                    w2 = w1;
                    h2 = h1;
                    Thread.sleep(80L);
                    w1 = this.getBounds().width;
                    h1 = this.getBounds().height;
                }
                while (!this.stop) {
                    this.repaint();
                }
                System.out.println("stopped");
            }
            catch (InterruptedException e) {
                System.out.println("caught Interrupted Exception " + e);
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

