/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.layout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;

public class ValidateCheckLayout
extends VisualTestImpl
implements LayoutManager {
    private LayoutManager mngr = new FlowLayout();
    private int counter = 0;
    private Label label;
    private String result = "TEST PASSES: ";
    private String message = " validate is only called once!";
    private boolean autorunning;

    public ValidateCheckLayout() {
        this.setLayout(this);
    }

    public void start(Panel p, boolean b) {
        this.autorunning = b;
        this.label = new Label(this.result);
        this.add(this.label);
        this.remove(this.label);
        this.add(this.label);
        this.add(new Label(this.message));
        this.label.setText(this.result);
        this.validate();
    }

    public void addLayoutComponent(String name, Component comp) {
        ++this.counter;
        this.mngr.addLayoutComponent(name, comp);
    }

    public void layoutContainer(Container parent) {
        if (this.counter > 0) {
            this.result = "TEST FAILED: ";
            this.message = "validate is called to soon!";
            if (!this.autorunning) {
                this.vt.log("Test failed.  The method Container.validate() is called too soon: Container.addImpl() and Container.remove() should not call validate() themselves.", this);
            }
        }
        this.mngr.layoutContainer(parent);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.mngr.minimumLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.mngr.preferredLayoutSize(parent);
    }

    public void removeLayoutComponent(Component comp) {
        this.mngr.removeLayoutComponent(comp);
    }

    public String getHelpText() {
        return "This test tries to see if a validate is called after an Panel.add(comp)\nif the test fails the labels will be set to show this, otherwise test passed is displayed";
    }
}

