/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.AWTEventDisplay;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TextMulticastTest
extends VisualTestImpl
implements ActionListener {
    private Button[] add;
    private Button[] remove;
    private TextDisplay[] display;
    private NamedTextArea area;
    private Button append;
    private Button delete;
    private Button reset;
    private int count;
    static final int LISTENERS = 5;

    public TextMulticastTest() {
        this.setForeground(new Color(80, 32, 32));
        this.setBackground(new Color(128, 64, 64));
        int step = 20;
        int red = 155;
        int shade = 100;
        this.setLayout(new BorderLayout());
        Panel buttons = new Panel(new GridLayout(1, 3));
        this.append = new Button("Add one Oompa-Loompa");
        this.append.addActionListener(this);
        this.append.setBackground(new Color(red - step, shade, shade));
        buttons.add(this.append);
        this.delete = new Button("remove one Oompa-Loompa");
        this.delete.addActionListener(this);
        buttons.add(this.delete);
        this.reset = new Button("reset Oompa-Loompas");
        this.reset.addActionListener(this);
        this.reset.setBackground(new Color(red, shade - step, shade - step));
        buttons.add(this.reset);
        this.add((Component)buttons, "North");
        this.area = new NamedTextArea("<TextArea>", "1 Oompa-Loompa..... ");
        this.count = 2;
        this.add((Component)this.area, "Center");
        Panel listeners = new Panel(new GridLayout(5, 1));
        Panel[] row = new Panel[5];
        this.add = new Button[5];
        this.display = new TextDisplay[5];
        this.remove = new Button[5];
        for (int i = 0; i < 5; ++i) {
            row[i] = new Panel(new BorderLayout());
            this.display[i] = new TextDisplay("Press <add> to add a listener to this panel", new Color(red, shade, shade), this.getForeground());
            row[i].add((Component)this.display[i], "Center");
            this.add[i] = new Button("Add");
            this.add[i].setBackground(new Color(red += step, shade, shade));
            this.add[i].addActionListener(this);
            row[i].add((Component)this.add[i], "West");
            this.remove[i] = new Button("Remove");
            this.remove[i].setBackground(new Color(red, shade, shade));
            this.remove[i].addActionListener(this);
            row[i].add((Component)this.remove[i], "East");
            shade += step;
            listeners.add(row[i]);
        }
        this.add((Component)listeners, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        boolean found = false;
        Object source = evt.getSource();
        for (int i = 0; i < 5 && !found; ++i) {
            if (source == this.add[i]) {
                this.area.addTextListener(this.display[i]);
                this.display[i].displayMessage("Listener added. press <remove> to remove it again");
                found = true;
                continue;
            }
            if (source != this.remove[i]) continue;
            this.area.removeTextListener(this.display[i]);
            this.display[i].displayMessage("Listener removed. press <add> to add it again");
            found = true;
        }
        if (!found) {
            if (source == this.append) {
                this.area.append(this.count + " Oompa-Loompas.... ");
                ++this.count;
            } else if (source == this.delete) {
                this.area.replaceRange("", 0, 20);
            } else if (source == this.reset) {
                this.area.setText("1 Oompa-Loompa..... ");
                this.count = 2;
            }
        }
    }

    public void displayMessage(String[] messagestrings) {
    }

    public String getHelpText() {
        return "The aim: test the throwing of TextEvents through the AWTEventMulticaster functions:\n\nThe screen consists out a TextArea, a row of buttons and 5 ItemDisplay panels. Each of this panels is flanked by an <add> and a <remove> button.\nThe TextArea throws a TextEvent every time the text inside it is changed, either through the keyboard or through the three buttons. Using the Add/Delete buttons next to the panels you can add a TextListener to that panel in order to get the textEvents displayed on that panel, or you can remove this listener again\n.(Adding and removing of TextListeners is done by calls to the static AWTEventMulticaster.Add()and -remove() functions)\nThe top row buttons: <Add one Oompa-Loompa> adds one string <oompa-loompa> to the textarea, <remove one oompa-loompa> removes the first of that strings from the textarea, <reset oompa-loompas> resets the text to its original string. All of these actions throw a TextEvent \n\n Items to test : \n -------------\n => Pressing <add> for a panel and subsequently clicking the buttons to check if a TextEvent is thrown and displayed on the newly selected panel, as well as on all other previously selected panels\n => Pressing <remove> for a panel and subsequently clicking a button to check if the TextEvent thrown is no longer displayed on that panel, nor on the panels previously deselected, yet remains displayed on all other panels still selected\n => Pressing <add> for the same panel over and over again to see that the panel is not added twice\n => Pressing <remove> for the same panel over and over again, or pressing <remove> on a panel to which no listener is added yet to check that a panel is not removed twice\n \n ps. as the Add and remove routines have a slightly different algorithm for the first and second listener then for all subsequent listeners, specially check the behavior when \n    - adding the first panel, adding the second panel, adding the third panel\n    - removing the third-last panel, removing the second-last panel, removing the last panel\n    - giving a remove-command when no panels are selected\n Disclaimer : No Oompa-Loompas were harmed during the making of this test.";
    }

    class NamedTextArea
    extends TextArea {
        private String name;

        public NamedTextArea(String name, String text) {
            super(text, 3, 30, 2);
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    class TextDisplay
    extends AWTEventDisplay
    implements TextListener {
        private int eventNo = 1;

        public TextDisplay(String title, Color back, Color front) {
            super(title, back, front);
        }

        public void textValueChanged(TextEvent evt) {
            this.message = this.displayTextEventShortcut(evt);
            this.repaint();
        }

        public String displayTextEventShortcut(TextEvent evt) {
            String line = "(event no." + this.eventNo + ") ";
            ++this.eventNo;
            Object source = evt.getSource();
            line = source == null ? line + "Source() == NULL" : line + "Source() = " + source;
            int id = evt.getID();
            line = id == 900 ? line + " : TEXT_VALUE_CHANGED (" + id + ")" : line + " unknown Id (" + id + ")";
            return line;
        }
    }
}

