/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.event.CollectsEvents;
import com.acunia.wonka.test.awt.event.MouseGeneratorComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;

public class MouseEventTest
extends VisualTestImpl
implements CollectsEvents {
    private List display;
    private MouseGeneratorComponent trigger1 = new MouseGeneratorComponent("<COPPER>", MouseGeneratorComponent.COPPER, MouseGeneratorComponent.DARKGREEN, this);
    private MouseGeneratorComponent trigger2;
    private MouseGeneratorComponent trigger3;
    static final Color COPPER = new Color(200, 200, 120);
    static final Color DARKSAND = new Color(96, 96, 48);
    static final Color DUSTGREEN = new Color(128, 192, 128);
    static final Color DARKGREEN = new Color(64, 96, 64);

    public MouseEventTest() {
        this.trigger1.addMouseListener(this.trigger1);
        this.trigger1.addMouseMotionListener(this.trigger1);
        this.trigger2 = new MouseGeneratorComponent("<DARK>", MouseGeneratorComponent.DARKSAND, MouseGeneratorComponent.DUSTGREEN, this);
        this.trigger2.addMouseListener(this.trigger2);
        this.trigger2.addMouseMotionListener(this.trigger2);
        this.trigger3 = new MouseGeneratorComponent("<GREEN>", MouseGeneratorComponent.DARKGREEN, MouseGeneratorComponent.COPPER, this);
        this.trigger3.addMouseListener(this.trigger3);
        this.trigger3.addMouseMotionListener(this.trigger3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.trigger1, "North");
        Panel p = new Panel(new GridLayout(1, 2));
        p.add(this.trigger2);
        p.add(this.trigger3);
        this.add((Component)p, "Center");
        this.display = new List();
        this.display.add("Click or drag the mouse");
        this.display.add("and see the events events");
        this.display.add("        HERE");
        this.add((Component)this.display, "South");
    }

    public void displayMessage(String[] message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        for (int i = message.length - 1; i >= 0; --i) {
            this.display.add(message[i], 0);
        }
    }

    public String getHelpText() {
        return "The test displays three mouse event fields and a list. Click or drag on any of the fields and see a display of the MouseEvent thrown appear in the list below.\n The mouse event is analysed and displayed in a four-line text. For the correct behavior of the MouseAdapter and MouseEvent class, each event should be tested on the following items: \n\n Items to test:\n --------------\n=> Reaction: the events should be thrown in response to a mouse event thrown as the mouse experiences one of these cases :\n  - the mouse entered one of the three fields\n  - the mouse left one of the three fields\n  - One of the mouse buttons was pressed\n  - that mouse buttons was released again\n  - one of the mouse buttons was clicked\n=> Source: the mouse event should display the correct 'source' the event originated. This is the field the mouse action was taken in.( either COPPER, DARK, or GREEN, depending on wether the event happened in the copper, dark grey or green field) as originating from that field and catched by the main testing class\n=> time: the second line should display the system time in milliseconds on which the event was thrown=> action: the second line should also display the correct mouse action. Once as a number between500 and   506 and once in text=> Position: the third line should display the mouse position IN THE CURRENT FIELD. Move the mouse over the borders of several fields and see the positions change=> Number of clicks: when clicked, the third line shouls also detect the number of clicks as a means to distinguish between single and double-clicks\n=> Modifiers and buttons: The fourth line should show the mouse modifiers and detect from there which of the mouse buttons was clicked, or of more were clicked at the same time\n=> Popup menu: The fourth line should show also show wether the mouse event triggered a popup menu=> multiple events: As Java defines a mouse click as a mouse-pressed event followed by a mouse-release event, clicking the mouse will trigger three events at once: a mouse-pressed, mouse-clicked and mouse-released. Similar, releasing a pressed button will trigger a mouse-clicked event as well as a mouse-released\n current issues (version 0.7.2 / oct. 11 2001:\n -------------------------\n=> event reaction: the mouse driver does not throw a mouse-moved item when the mouse is moved\n=> time: the event time call <MouseEvent.getWhen()> always returns a zero\n=> Number of clicks: <MouseEvent.getClickCount()> always returns a zero\n=> Modifiers/buttons: <ItemEvent.getModifiers()> always returns a zero\n\n\nPs: the behavior of the event fields to the mouse events is described below:\n\n" + this.trigger1.getHelpText();
    }

    public String toString() {
        return "MouseEventTest";
    }
}

