/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.event;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ContainerMulticastTest
extends VisualTestImpl
implements ItemListener,
ActionListener {
    private Checkbox displayLeft;
    private FillComponent left;
    private Checkbox displayCenter;
    private FillComponent center;
    private Checkbox displayRight;
    private FillComponent right;
    private NamedPanel display;
    private Button[] add;
    private Button[] remove;
    private ListenerLabel[] listener;
    int step = 16;
    static final int LISTENERS = 6;

    public ContainerMulticastTest() {
        int clear = 155;
        this.setBackground(new Color(64, clear, clear));
        this.setForeground(Color.white);
        this.setLayout(new BorderLayout());
        this.display = new NamedPanel("<display panel>", new BorderLayout());
        Label displaylabel = new Label("display panel", 1);
        displaylabel.setBackground(new Color(64, 64, clear += this.step));
        this.display.add((Component)displaylabel, "North");
        Panel boxes = new Panel(new GridLayout(1, 3));
        boxes.setBackground(new Color(64, 64, clear += this.step));
        this.displayLeft = new Checkbox("component left", false);
        this.displayLeft.addItemListener(this);
        boxes.add(this.displayLeft);
        this.displayCenter = new Checkbox("component center", false);
        this.displayCenter.addItemListener(this);
        boxes.add(this.displayCenter);
        this.displayRight = new Checkbox("component right", false);
        this.displayRight.addItemListener(this);
        boxes.add(this.displayRight);
        this.display.add((Component)boxes, "South");
        this.add((Component)this.display, "Center");
        this.left = new FillComponent("<Left>", new Color(128, 64, clear += this.step), new Color(128, clear, 128), Color.white);
        this.center = new FillComponent("<Center>", new Color(96, 96, clear += this.step), new Color(128, clear, 128), Color.white);
        this.right = new FillComponent("<Right>", new Color(64, 128, clear += this.step), new Color(128, clear, 128), Color.white);
        clear = 155;
        Panel listeners = new Panel(new GridLayout(6, 1));
        Panel[] row = new Panel[6];
        this.add = new Button[6];
        this.listener = new ListenerLabel[6];
        this.remove = new Button[6];
        for (int i = 0; i < 6; ++i) {
            row[i] = new Panel(new BorderLayout());
            this.listener[i] = new ListenerLabel("Press <add> to add a listener to this panel", new Color(128, 128, clear));
            row[i].add((Component)this.listener[i], "Center");
            this.add[i] = new Button("Add");
            this.add[i].setBackground(new Color(100, 100, clear));
            this.add[i].addActionListener(this);
            row[i].add((Component)this.add[i], "West");
            this.remove[i] = new Button("Remove");
            this.remove[i].setBackground(new Color(155, 155, clear));
            this.remove[i].addActionListener(this);
            row[i].add((Component)this.remove[i], "East");
            clear += this.step;
            listeners.add(row[i]);
        }
        this.add((Component)listeners, "South");
    }

    public void itemStateChanged(ItemEvent evt) {
        Checkbox source = (Checkbox)evt.getSource();
        if (source == this.displayLeft && source.getState()) {
            this.display.add((Component)this.left, "West");
            this.validate();
        } else if (source == this.displayLeft) {
            this.display.remove(this.left);
            this.validate();
        } else if (source == this.displayCenter && source.getState()) {
            this.display.add((Component)this.center, "Center");
            this.validate();
        } else if (source == this.displayCenter) {
            this.display.remove(this.center);
            this.validate();
        } else if (source == this.displayRight && source.getState()) {
            this.display.add((Component)this.right, "East");
            this.validate();
        } else if (source == this.displayRight) {
            this.display.remove(this.right);
            this.validate();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        boolean found = false;
        Object source = evt.getSource();
        for (int i = 0; i < 6 && !found; ++i) {
            if (source == this.add[i]) {
                this.display.addContainerListener(this.listener[i]);
                this.listener[i].setText("Listener added. press <remove> to remove it again");
                found = true;
                continue;
            }
            if (source != this.remove[i]) continue;
            this.display.removeContainerListener(this.listener[i]);
            this.listener[i].setText("Listener removed. press <add> to add it again");
            found = true;
        }
    }

    public String getHelpText() {
        return "The aim: test the throwing of ContainerEvents through the AWTEventMulticaster functions:\n\nThe top of the screen consists out a panel with title and a row of checkboxes.\n The lower part out of 6 display labels. Each of this panels is flanked by an <add> and a <remove> button.\nClicking the buttons, you can add a component to the left, center or right of the display panel, and remove them again. Every time a component is added or removed, the panel throws a ContainerEvent. Using the Add/Delete buttons next to the labels you can add a ComponentListener to that label in order to get this events displayed on that label, or you can remove this listener again\n.(Adding and removing of containerListeners is done by calls to the static AWTEventMulticaster.Add()and -remove() functions)\n\n Items to test : \n -------------\n => Pressing <add> for a label and subsequently adding or removing a component to check if a ComponentEvent is thrown and displayed on the newly selected label, as well as on all other previously selected labels\n => Pressing <remove> for a label and subsequently adding or removing a component to check if the ComponentEvent thrown is no longer displayed on that label, nor on the labels previously deselected, yet remains displayed on all other labels still selected\n => Pressing <add> for the same label over and over again to see that the listener for that label is not added twice\n => Pressing <remove> for the same label over and over again, or pressing <remove> on a label to which no listener is added yet to check that a listener is not removed twice\n \n ps. as the Add and remove routines have a slightly different algorithm for the first and second listener then for all subsequent listeners, specially check the behavior when \n    - adding the first label, adding the second label, adding the third label\n    - removing the third-last label, removing the second-last label, removing the last label\n    - giving a remove-command when no labels are selected";
    }

    public static void main(String[] args) {
        ContainerMulticastTest ce = new ContainerMulticastTest();
        ce.show();
    }

    class ListenerLabel
    extends Label
    implements ContainerListener {
        public ListenerLabel(String text, Color background) {
            super(text, 1);
            this.setBackground(background);
        }

        public void componentAdded(ContainerEvent evt) {
            this.setText("ComponentAdded " + evt.getChild() + " to " + evt.getComponent());
        }

        public void componentRemoved(ContainerEvent evt) {
            this.setText("ComponentRemoved " + evt.getChild() + " from " + evt.getComponent());
        }
    }

    class NamedPanel
    extends Panel {
        public NamedPanel(String name, LayoutManager layout) {
            super(layout);
            this.setName(name);
        }

        public String toString() {
            return this.getName();
        }
    }

    class FillComponent
    extends Container {
        private Dimension bounds;
        private Rectangle innerRect;
        private Color innerColor;
        private Color textColor;
        private int middle;

        public FillComponent(String name, Color background, Color rectangle, Color text) {
            this.setBackground(background);
            this.setName(name);
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, 60, 25);
            this.innerColor = rectangle;
            this.textColor = text;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.bounds.equals(this.getSize())) {
                this.bounds.setSize(this.getSize());
                this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
                this.middle = this.getSize().height / 2;
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.bounds.width - 1, this.bounds.height - 1);
            g.setColor(this.innerColor);
            g.drawRect(this.innerRect.x, this.innerRect.y, this.innerRect.width - 1, this.innerRect.height - 1);
            g.fillRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 4, this.innerRect.height - 4);
            g.setColor(this.textColor);
            g.drawString(this.getName(), this.innerRect.x, this.middle + 3);
        }

        public String toString() {
            return this.getName();
        }
    }
}

