/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.dnd;

import java.awt.TextField;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringBufferInputStream;

class DragDropText
extends TextField
implements Transferable,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static DataFlavor[] dataFlavors = new DataFlavor[]{DragDropText.createDataFlavor(), DataFlavor.plainTextFlavor, DataFlavor.stringFlavor};
    private transient int dropAction;

    private static DataFlavor createDataFlavor() {
        try {
            return new DataFlavor("text/plain; charset=iso8859-1", "String");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    DragDropText(String txt) {
        super(txt);
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this, 1, this);
        this.setDropTarget(new DropTarget(this, this));
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        System.out.println("DragDropText.dragGestureRecognized");
        try {
            dge.startDrag(null, this, null);
        }
        catch (InvalidDnDOperationException idndoe) {
            System.out.println("InvalidDnDOperationException: " + idndoe.getMessage());
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        System.out.println("DragDropText.dragEnter");
        dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
    }

    public void dragOver(DragSourceDragEvent dsde) {
        System.out.println("DragDropText.dragOver");
    }

    public void dragGestureChanged(DragSourceDragEvent dsde) {
        System.out.println("DragDropText.dragGestureChanged");
    }

    public void dragExit(DragSourceEvent dse) {
        System.out.println("DragDropText.dragExit");
        dse.getDragSourceContext().setCursor(null);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        System.out.println("DragDropText.dragDropEnd");
        Thread.dumpStack();
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        System.out.println("DragDropText.dropActionChanged");
        Thread.dumpStack();
    }

    public DataFlavor[] getTransferDataFlavors() {
        System.out.println("DragDropText.getTransferDataFlavors");
        return dataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        System.out.println("DragDropText.isDataFlavorSupported");
        for (int i = 0; i < dataFlavors.length; ++i) {
            if (!dataFlavors[i].equals(df)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor transferdf) throws UnsupportedFlavorException, IOException {
        System.out.println("DragDropText.getTransferData");
        if (!this.isDataFlavorSupported(transferdf)) {
            throw new UnsupportedFlavorException(transferdf);
        }
        String originalText = this.getText();
        if (DataFlavor.stringFlavor.equals(transferdf)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(originalText);
            }
            catch (Exception e) {
                throw new IOException();
            }
            return new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        }
        StringBufferInputStream sbis = new StringBufferInputStream(originalText);
        return sbis;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        System.out.println("DragDropText.dragEnter");
        dtde.acceptDrag(1);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        System.out.println("DragDropText.dragOver");
        dtde.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent dtde) {
        System.out.println("DragDropText.dragExit");
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dtde) {
        System.out.println("DragDropText.drop");
        DropTargetContext dtc = dtde.getDropTargetContext();
        boolean outcome = false;
        if ((dtde.getSourceActions() & 1) == 0) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(1);
        DataFlavor[] dataflavors = dtde.getCurrentDataFlavors();
        DataFlavor currentDataflavor = null;
        for (int i = 0; i < dataflavors.length; ++i) {
            if (!DataFlavor.plainTextFlavor.equals(dataflavors[i])) continue;
            currentDataflavor = dataflavors[i];
            break;
        }
        if (currentDataflavor != null) {
            Transferable transf = dtde.getTransferable();
            InputStream is = null;
            try {
                is = (InputStream)transf.getTransferData(currentDataflavor);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                dtc.dropComplete(false);
                return;
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                dtc.dropComplete(false);
                this.repaint();
                return;
            }
            if (is != null) {
                String newText = this.getText();
                try {
                    int length = is.available();
                    byte[] string = new byte[length];
                    is.read(string, 0, length);
                    for (int i = 0; i < length; ++i) {
                        if (string[i] != 0) continue;
                        length = i;
                        break;
                    }
                    newText = new String(string, 0, length);
                    outcome = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dtc.dropComplete(false);
                    this.repaint();
                    return;
                }
                finally {
                    this.setText(newText);
                }
            } else {
                outcome = false;
            }
        }
        this.repaint();
        this.validate();
        System.out.println("outcome = " + outcome);
        dtc.dropComplete(outcome);
    }

    public void dragScroll(DropTargetDragEvent dtde) {
        System.out.println("DragDropText.dragScroll");
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        System.out.println("DragDropText.dropActionChanged");
    }
}

