/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Window;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WindowVisibleTest
extends VisualTestImpl
implements ActionListener {
    private Window leftWindow = null;
    private Window rightWindow;
    private Button buildLeft;
    private Button killLeft;
    private Button showLeft;
    private Button hideLeft;
    private Button frontLeft;
    private Button backLeft;
    private Button focusLeft;
    private Label leftAnchor;
    private Label rightAnchor;
    private Button buildRight;
    private Button killRight;
    private Button showRight;
    private Button hideRight;
    private Button frontRight;
    private Button backRight;
    private Button focusRight;
    private List display;

    public WindowVisibleTest() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(128, 32, 128));
        this.setForeground(Color.white);
        this.display = new List(3, false);
        this.display.add("Dialog outcome dispayed here");
        this.add((Component)this.display, "South");
        Panel anchors = new Panel(new GridLayout(1, 4));
        Panel leftbuttons = new Panel(new GridLayout(8, 1));
        leftbuttons.setBackground(new Color(80, 32, 32));
        leftbuttons.add(new Label("Left Window:"));
        this.buildLeft = new Button("[ ] build window");
        this.buildLeft.setBackground(new Color(96, 32, 48));
        this.buildLeft.addActionListener(this);
        leftbuttons.add(this.buildLeft);
        this.killLeft = new Button("[x] dispose window");
        this.killLeft.setBackground(new Color(112, 32, 64));
        this.killLeft.addActionListener(this);
        leftbuttons.add(this.killLeft);
        this.showLeft = new Button("<= show window =>");
        this.showLeft.setBackground(new Color(128, 32, 80));
        this.showLeft.addActionListener(this);
        leftbuttons.add(this.showLeft);
        this.hideLeft = new Button("=> hide window <=");
        this.hideLeft.setBackground(new Color(144, 32, 96));
        this.hideLeft.addActionListener(this);
        leftbuttons.add(this.hideLeft);
        this.frontLeft = new Button("=> to front =>");
        this.frontLeft.setBackground(new Color(160, 32, 112));
        this.frontLeft.addActionListener(this);
        leftbuttons.add(this.frontLeft);
        this.backLeft = new Button("<= to back <=");
        this.backLeft.setBackground(new Color(176, 32, 128));
        this.backLeft.addActionListener(this);
        leftbuttons.add(this.backLeft);
        this.focusLeft = new Button("request focus");
        this.focusLeft.setBackground(new Color(192, 32, 144));
        this.focusLeft.addActionListener(this);
        leftbuttons.add(this.focusLeft);
        anchors.add(leftbuttons);
        this.leftAnchor = new Label("Left window area");
        this.leftAnchor.setBackground(new Color(224, 0, 144));
        anchors.add(this.leftAnchor);
        this.rightAnchor = new Label("Right window area");
        this.rightAnchor.setBackground(new Color(144, 0, 224));
        anchors.add(this.rightAnchor);
        Panel rightbuttons = new Panel(new GridLayout(8, 1));
        rightbuttons.setBackground(new Color(32, 32, 80));
        rightbuttons.add(new Label("Right Window:"));
        this.buildRight = new Button("[ ] build window");
        this.buildRight.setBackground(new Color(48, 32, 96));
        this.buildRight.addActionListener(this);
        rightbuttons.add(this.buildRight);
        this.killRight = new Button("[X] dispose window");
        this.killRight.setBackground(new Color(64, 32, 112));
        this.killRight.addActionListener(this);
        rightbuttons.add(this.killRight);
        this.showRight = new Button("<= show window =>");
        this.showRight.setBackground(new Color(80, 32, 128));
        this.showRight.addActionListener(this);
        rightbuttons.add(this.showRight);
        this.hideRight = new Button("=> hide window <=");
        this.hideRight.setBackground(new Color(96, 32, 144));
        this.hideRight.addActionListener(this);
        rightbuttons.add(this.hideRight);
        this.frontRight = new Button("=> to front =>");
        this.frontRight.setBackground(new Color(112, 32, 160));
        this.frontRight.addActionListener(this);
        rightbuttons.add(this.frontRight);
        this.backRight = new Button("<= to back <=");
        this.backRight.setBackground(new Color(128, 32, 176));
        this.backRight.addActionListener(this);
        rightbuttons.add(this.backRight);
        this.focusRight = new Button("request focus");
        this.focusRight.setBackground(new Color(144, 32, 192));
        this.focusRight.addActionListener(this);
        rightbuttons.add(this.focusRight);
        anchors.add(rightbuttons);
        this.add((Component)anchors, "Center");
    }

    public void stop(Panel p) {
        if (this.leftWindow != null) {
            this.leftWindow.dispose();
            this.leftWindow = null;
        }
        if (this.rightWindow != null) {
            this.rightWindow.dispose();
            this.rightWindow = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.buildLeft && this.leftWindow == null) {
            this.leftWindow = this.buildWindow(Color.red, "R E D", this.leftAnchor.getLocationOnScreen());
            this.displayText("... Left-window constructed");
        } else if (source == this.buildLeft) {
            this.displayText("!! skipped build of left window !!", "!! Left window was already constructed !!");
        } else if (source == this.killLeft && this.leftWindow != null) {
            this.leftWindow.dispose();
            this.leftWindow = null;
            this.displayText("... Left-window.dispose() called");
        } else if (source == this.killLeft) {
            this.displayText("!! skipped Left-window.dispose() !!", "!! Left window is not built yet !!");
        } else if (source == this.showLeft && this.leftWindow != null) {
            this.leftWindow.setVisible(true);
            this.displayText("... Left-window.setVisible(true) called");
        } else if (source == this.showLeft) {
            this.displayText("!! skipped Left-window.setVisible() !!", "!! Left window is not built yet !!");
        } else if (source == this.hideLeft && this.leftWindow != null) {
            this.leftWindow.setVisible(false);
            this.displayText("Left-window.setVisible(false) called");
        } else if (source == this.hideLeft) {
            this.displayText("!! skipped Left-window.setVisible() !!", "!! Left window is not built yet !!");
        } else if (source == this.frontLeft && this.leftWindow != null) {
            this.leftWindow.toFront();
            this.displayText("... Left-window.toFront() called");
        } else if (source == this.frontLeft) {
            this.displayText("!! skipped Left-window.toFront() !!", "!! Left window is not built yet !!");
        } else if (source == this.backLeft && this.leftWindow != null) {
            this.leftWindow.toBack();
            this.displayText("Left-window.toBack() called");
        } else if (source == this.backLeft) {
            this.displayText("!! skipped Left-window.toBack() !!", "!! Left window is not built yet !!");
        } else if (source == this.focusLeft && this.leftWindow != null) {
            this.leftWindow.requestFocus();
            this.displayText("Left-window.requestFocus called");
        } else if (source == this.focusLeft) {
            this.displayText("!! skipped Left-window.requestFocus() !!", "!! Left window is not built yet !!");
        } else if (source == this.buildRight && this.rightWindow == null) {
            this.rightWindow = this.buildWindow(Color.blue, "B L U E", this.rightAnchor.getLocationOnScreen());
            this.displayText("... Right-window constructed");
        } else if (source == this.buildRight) {
            this.displayText("!! skipped build of right window !!", "!! Right window was already constructed !!");
        } else if (source == this.killRight && this.rightWindow != null) {
            this.rightWindow.dispose();
            this.rightWindow = null;
            this.displayText("... Right-window.dispose() called");
        } else if (source == this.killRight) {
            this.displayText("!! skipped Right-window.dispose() !!", "!! Right window is not built yet !!");
        } else if (source == this.showRight && this.rightWindow != null) {
            this.rightWindow.setVisible(true);
            this.displayText("... Right-window.setVisible(true) called");
        } else if (source == this.showRight) {
            this.displayText("!! skipped Right-window.show() !!", "!! Right window is not built yet !!");
        } else if (source == this.hideRight && this.rightWindow != null) {
            this.rightWindow.setVisible(false);
            this.displayText("Right-window.setVisible(false) called");
        } else if (source == this.hideRight) {
            this.displayText("!! skipped Right-window.setVisible(false) !!", "!! Right window is not built yet !!");
        } else if (source == this.frontRight && this.rightWindow != null) {
            this.rightWindow.toFront();
            this.displayText("... Right-window.toFront() called");
        } else if (source == this.frontRight) {
            this.displayText("!! skipped Right-window.toFront() !!", "!! Right window is not built yet !!");
        } else if (source == this.backRight && this.rightWindow != null) {
            this.rightWindow.toBack();
            this.displayText("Right-window.toBack() called");
        } else if (source == this.backRight) {
            this.displayText("!! skipped Right-window.toBack() !!", "!! Right window is not built yet !!");
        } else if (source == this.focusRight && this.rightWindow != null) {
            this.rightWindow.requestFocus();
            this.displayText("Right-window.requestFocus called");
        } else if (source == this.focusRight) {
            this.displayText("!! skipped Right-window.requestFocus() !!", "!! Right window is not built yet !!");
        }
    }

    private void displayText(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(text, 0);
        System.out.println(text);
    }

    private void displayText(String line1, String line2) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(line2, 0);
        this.display.add(line1, 0);
        System.out.println(line1);
        System.out.println(line2);
    }

    private Window buildWindow(Color backcolor, String albumcolor, Point anchor) {
        Window target = null;
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
        } else {
            target = new Window(vtframe);
            target.setLayout(new GridLayout(6, 3));
            target.setBackground(backcolor);
            target.setForeground(Color.white);
            target.add(new Label("The Beatles", 2));
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label("the", 1));
            target.add(new Label());
            target.add(new Label());
            target.add(new Label(albumcolor, 1));
            target.add(new Label());
            target.add(new Label());
            target.add(new Label("album", 1));
            target.add(new Label());
            target.pack();
            target.setLocation(anchor.x, anchor.y);
            this.displayText("Build new window " + target);
        }
        return target;
    }

    public String getHelpText() {
        return "Test on the visibility of Windows\nUsing the buttons on the screen, this tests builds, shows and hides one of two possible Windows, brings it to back and to frontAll events done will be logged in the event list on the bottom of the screen\n\nthe  buttons:\n-> <build> constructs a new window. the window isn't shown yet. (Use <show> to do so )\n-> <dispose> disposes and deletes the window\n-> <show> shows the window  calling setVisible(true)\n-> <hide> calls setVisible(false) to hide the window again\n-> <to front> calls Window.toFront() to bring this window on top of all others\n   (in this case, over the other window, if present)\n-> <to back> calls Window.toBack(), to place this window below all others\n   (in this case, below the other window, if present)\n-> <request focus> to request focus for the window\n\n There are two rows of buttons, one for each of the two windows. The left buttons relate to the left, red window, the right buttons to the right, blue one.\nThe left, red window is shown with its upper left corner aligned to the upper left corner of the left inner anchor panel, the right, blue window is shown with its upper left corner aligned to that of the inner right anchor panel";
    }

    public static void main(String[] args) {
        new WindowVisibleTest();
    }
}

