/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Window;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WindowLocationTest
extends VisualTestImpl
implements ActionListener {
    private Window leftWindow = null;
    private Button buildLeft;
    private Button killLeft;
    private Button showLeft;
    private Button hideLeft;
    private Button setLeftLocation;
    private Button setRightLocation;
    private Label leftAnchor;
    private Label rightAnchor;
    private List display;

    public WindowLocationTest() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(220, 255, 185));
        this.display = new List(3, false);
        this.display.add("Dialog outcome dispayed here");
        this.add((Component)this.display, "South");
        this.add((Component)new PlaceholderComponent(40, 50), "East");
        this.add((Component)new PlaceholderComponent(40, 50), "West");
        Panel anchors = new Panel(new GridLayout(1, 3));
        anchors.setBackground(new Color(245, 205, 64));
        this.leftAnchor = new Label("Left window area", 1);
        anchors.add(this.leftAnchor);
        Panel leftbuttons = new Panel(new GridLayout(6, 1));
        this.buildLeft = new Button("build window");
        this.buildLeft.addActionListener(this);
        this.buildLeft.setBackground(new Color(255, 205, 64));
        leftbuttons.add(this.buildLeft);
        this.killLeft = new Button("dispose window");
        this.killLeft.addActionListener(this);
        this.killLeft.setBackground(new Color(250, 215, 84));
        leftbuttons.add(this.killLeft);
        this.showLeft = new Button("show window");
        this.showLeft.addActionListener(this);
        this.showLeft.setBackground(new Color(245, 225, 105));
        leftbuttons.add(this.showLeft);
        this.hideLeft = new Button("hide window");
        this.hideLeft.addActionListener(this);
        this.hideLeft.setBackground(new Color(240, 235, 125));
        leftbuttons.add(this.hideLeft);
        this.setLeftLocation = new Button("<-- move to left");
        this.setLeftLocation.addActionListener(this);
        this.setLeftLocation.setBackground(new Color(235, 245, 145));
        leftbuttons.add(this.setLeftLocation);
        this.setRightLocation = new Button("move to right -->");
        this.setRightLocation.addActionListener(this);
        this.setRightLocation.setBackground(new Color(230, 255, 165));
        leftbuttons.add(this.setRightLocation);
        anchors.add(leftbuttons);
        this.rightAnchor = new Label("right window area", 1);
        anchors.add(this.rightAnchor);
        this.add((Component)anchors, "Center");
    }

    public void stop(Panel p) {
        if (this.leftWindow != null) {
            this.leftWindow.dispose();
            this.leftWindow = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.buildLeft && this.leftWindow == null) {
            this.leftWindow = this.buildWindow(Color.red, "R E D");
            this.displayText("... new window constructed");
        } else if (source == this.buildLeft) {
            this.displayText("!! skipped build of new window !!", "!! window was already constructed !!");
        } else if (source == this.killLeft && this.leftWindow != null) {
            this.leftWindow.dispose();
            this.leftWindow = null;
            this.displayText("... window.dispose() called");
        } else if (source == this.killLeft) {
            this.displayText("!! skipped window.dispose() !!", "!! window is not built yet !!");
        } else if (source == this.showLeft && this.leftWindow != null) {
            this.leftWindow.show();
            this.displayText("... window.show() called");
        } else if (source == this.showLeft) {
            this.displayText("!! skipped window.show() !!", "!! window is not built yet !!");
        } else if (source == this.hideLeft && this.leftWindow != null) {
            this.leftWindow.setVisible(false);
            this.displayText("window.setVisible(false) called");
        } else if (source == this.hideLeft) {
            this.displayText("!! skipped window.setVisible(false) !!", "!! window is not built yet !!");
        } else if (source == this.setLeftLocation && this.leftWindow != null) {
            Point p = this.leftAnchor.getLocationOnScreen();
            this.leftWindow.setLocation(p.x, p.y);
            this.displayText("... window.setLocation() to left panel top=(" + p.x + ", " + p.y + ")");
        } else if (source == this.setLeftLocation) {
            this.displayText("!! skipped window.setLocation() !!", "!! window is not built yet !!");
        } else if (source == this.setRightLocation && this.leftWindow != null) {
            Point p = this.rightAnchor.getLocationOnScreen();
            this.leftWindow.setLocation(p.x, p.y);
            this.displayText("... window.setLocation() to right panel top=(" + p.x + ", " + p.y + ")");
        } else if (source == this.setRightLocation) {
            this.displayText("!! skipped window.setLocation() !!", "!! window is not built yet !!");
        }
    }

    private void displayText(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(text, 0);
        System.out.println(text);
    }

    private void displayText(String line1, String line2) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(line2, 0);
        this.display.add(line1, 0);
        System.out.println(line1);
        System.out.println(line2);
    }

    private Window buildWindow(Color backcolor, String albumcolor) {
        Window target = null;
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
        } else {
            target = new Window(vtframe);
            target.setLayout(new GridLayout(6, 3));
            target.setBackground(backcolor);
            target.setForeground(Color.white);
            target.add(new Label("The Beatles", 2));
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label());
            target.add(new Label("the", 1));
            target.add(new Label());
            target.add(new Label());
            target.add(new Label(albumcolor, 1));
            target.add(new Label());
            target.add(new Label());
            target.add(new Label("album", 1));
            target.add(new Label());
            target.pack();
            this.displayText("Build new window " + target);
        }
        return target;
    }

    public String getHelpText() {
        return "Test on the visibility and placement of windows\nUsing the buttons on the screen, this tests builds, shows and moves a Window. Therefore testing the Window classes' redraw and update functions. All events done will be logged in the event list on the bottom of the screen\n\nthe  buttons:\n-> <build> constructs a new window. the window isn't shown yet. (Use <show> to do so )\n-> <dispose> disposes and deletes the window\n-> <show> shows the window \n-> <hide> hides the window again (using setVisible(false) )\n-> <move to left> moves the window to the top-left of the inner left yellow anchor panel\n-> <move to right> moves the window to the top-left of the inner right yellow anchor panel\n   The test uses Component.getLocationOnScreen() to retrieve\n\n current issues: \n-> getLocationOnScreen() still retrieves the relative location to the next higher component instead of the absolute location\n-> setVisible(false) redraws the main frame; but not the subPanels: pressing <hide> makes the test delete the part of thewindow that overlaps the upper memory bar of the test, but leaces the part that is inside the actual test panel. ";
    }

    public static void main(String[] args) {
        new WindowLocationTest();
    }

    class PlaceholderComponent
    extends Component {
        int width;
        int height;

        public PlaceholderComponent(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public PlaceholderComponent(int w, int h, Color c) {
            this.width = w;
            this.height = h;
            this.setBackground(c);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.width, this.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }
    }
}

