/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Window;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PackBorderLayoutTest
extends VisualTestImpl
implements ActionListener {
    private Window firstWindow = null;
    private Button showFirst;
    private Button hideFirst;
    private Window secondWindow = null;
    private Button showSecond;
    private Button hideSecond;
    private Window thirdWindow = null;
    private Button showThird;
    private Button hideThird;
    private Window fourthWindow = null;
    private Button showFourth;
    private Button hideFourth;
    private List display;

    public PackBorderLayoutTest() {
        this.setLayout(new BorderLayout());
        this.display = new List(3, false);
        this.display.add("Dialog outcome dispayed here");
        this.add((Component)this.display, "South");
        Panel buttons = new Panel(new GridLayout(6, 2));
        buttons.add(new Label("NORTH panel Window:"));
        buttons.add(new Label("WEST panel Window:"));
        this.showFirst = new Button("build Window");
        this.showFirst.addActionListener(this);
        buttons.add(this.showFirst);
        this.showSecond = new Button("build Window");
        this.showSecond.addActionListener(this);
        buttons.add(this.showSecond);
        this.hideFirst = new Button("dispose Window");
        this.hideFirst.addActionListener(this);
        buttons.add(this.hideFirst);
        this.hideSecond = new Button("dispose Window");
        this.hideSecond.addActionListener(this);
        buttons.add(this.hideSecond);
        buttons.add(new Label("CENTER panel Window:"));
        buttons.add(new Label("default layout Window:"));
        this.showThird = new Button("build Window");
        this.showThird.addActionListener(this);
        buttons.add(this.showThird);
        this.showFourth = new Button("build Window");
        this.showFourth.addActionListener(this);
        buttons.add(this.showFourth);
        this.hideThird = new Button("dispose Window");
        this.hideThird.addActionListener(this);
        buttons.add(this.hideThird);
        this.hideFourth = new Button("dispose Window");
        this.hideFourth.addActionListener(this);
        buttons.add(this.hideFourth);
        this.add((Component)buttons, "Center");
    }

    public void stop(Panel p) {
        if (this.firstWindow != null) {
            this.firstWindow.dispose();
            this.firstWindow = null;
        }
        if (this.secondWindow != null) {
            this.secondWindow.dispose();
            this.secondWindow = null;
        }
        if (this.thirdWindow != null) {
            this.thirdWindow.dispose();
            this.thirdWindow = null;
        }
        if (this.fourthWindow != null) {
            this.fourthWindow.dispose();
            this.fourthWindow = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Component source = (Component)evt.getSource();
        if (source == this.showFirst) {
            if (this.checkFirst()) {
                this.firstWindow.show();
                this.displayText("first (NORTH aligned) Window shown");
            }
        } else if (source == this.hideFirst) {
            if (this.firstWindow != null) {
                this.firstWindow.dispose();
                this.firstWindow = null;
                this.displayText("first (NORTH aligned) Window disposed");
            }
        } else if (source == this.showSecond) {
            if (this.checkSecond()) {
                this.secondWindow.show();
                this.displayText("second (WEST aligned) Window shown");
            }
        } else if (source == this.hideSecond) {
            if (this.secondWindow != null) {
                this.secondWindow.dispose();
                this.secondWindow = null;
                this.displayText("second (WEST aligned) Window disposed");
            }
        } else if (source == this.showThird) {
            if (this.checkThird()) {
                this.thirdWindow.show();
                this.displayText("third (CENTER aligned) Window shown");
            }
        } else if (source == this.hideThird) {
            if (this.thirdWindow != null) {
                this.thirdWindow.dispose();
                this.thirdWindow = null;
                this.displayText("third (CENTER aligned) Window disposed");
            }
        } else if (source == this.showFourth) {
            if (this.checkFourth()) {
                this.fourthWindow.show();
                this.displayText("fourth (no alignment) Window shown");
            }
        } else if (source == this.hideFourth && this.fourthWindow != null) {
            this.fourthWindow.dispose();
            this.fourthWindow = null;
            this.displayText("fourth (no alignment) Window disposed");
        }
    }

    private void displayText(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(text, 0);
        System.out.println(text);
    }

    private boolean checkFirst() {
        this.displayText("Checking first Window: " + this.firstWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.firstWindow == null) {
            this.firstWindow = new Window(vtframe);
            this.firstWindow.setLayout(new BorderLayout());
            this.firstWindow.setBackground(Color.red);
            this.firstWindow.setForeground(Color.white);
            this.firstWindow.add((Component)new Label("The first (NORTH aligned) Window", 1), "North");
            this.firstWindow.pack();
            this.displayText("Build first Window " + this.firstWindow);
            return true;
        }
        return true;
    }

    private boolean checkSecond() {
        this.displayText("Checking second Window: " + this.secondWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.secondWindow == null) {
            this.secondWindow = new Window(vtframe);
            this.secondWindow.setLayout(new BorderLayout());
            this.secondWindow.setBackground(Color.blue);
            this.secondWindow.setForeground(Color.white);
            this.secondWindow.add((Component)new Label("The second (WEST aligned) Window", 1), "West");
            this.secondWindow.pack();
            this.displayText("Build second Window " + this.secondWindow);
            return true;
        }
        return true;
    }

    private boolean checkThird() {
        this.displayText("Checking third Window: " + this.thirdWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.thirdWindow == null) {
            this.thirdWindow = new Window(vtframe);
            this.thirdWindow.setLayout(new BorderLayout());
            this.thirdWindow.setBackground(Color.green);
            this.thirdWindow.setForeground(Color.white);
            this.thirdWindow.add((Component)new Label("The third (CENTER aligned) Window", 1), "Center");
            this.thirdWindow.pack();
            this.displayText("Build third Window " + this.thirdWindow);
            return true;
        }
        return true;
    }

    private boolean checkFourth() {
        this.displayText("Checking fourth Window: " + this.fourthWindow);
        Frame vtframe = this.vt.getFrame();
        if (vtframe == null) {
            this.displayText("Skipped command for vt.getFrame() not available yet");
            return false;
        }
        if (this.fourthWindow == null) {
            this.fourthWindow = new Window(vtframe);
            this.fourthWindow.setLayout(new BorderLayout());
            this.fourthWindow.setBackground(Color.black);
            this.fourthWindow.setForeground(Color.white);
            this.fourthWindow.add(new Label("The fourth (no alignment) Window", 1));
            this.fourthWindow.pack();
            this.displayText("Build fourth Window " + this.fourthWindow);
            return true;
        }
        return true;
    }

    public String getHelpText() {
        return "Test on the construction and behavior of the java.awt.Window class:\nEach of the four groups of buttons will construct a Window, add a label to it and calculate its size (using Window.pack() )\nthe four Windows are aligned using a BorderLayout, where the label is aligned-> to the NORTH \n-> to the WEST\n-> to the CENTER\n-> at no specific position (using a simple add(component) )\nCheck the correct size calculation and the correct display in all of the cases\n\nCURRENT ISSUE:\n constructing the fourth Window causes the application to hang. This is because the label is added to the BorderLayout using the simple form Container.add(Component) instead of the propper Container.add(Component, BorderLayout.alignment)\n(see also PackSizeTest on this subject)";
    }

    public static void main(String[] args) {
        new PackBorderLayoutTest();
    }
}

