/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt;

import com.acunia.wonka.test.awt.VisualTest;
import com.acunia.wonka.test.awt.VisualTestEngine;
import java.awt.Panel;
import java.io.CharArrayWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class VTELogger
implements Runnable {
    private static Runtime rt = Runtime.getRuntime();
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd\tkk:mm:ss zzz");
    private static FieldPosition position = new FieldPosition(0);
    private String log;

    private static void formatAndLogMessage(String message, String event, boolean doWrite) {
        StringBuffer b = new StringBuffer(256);
        dateFormatter.format(new Date(), b, position);
        b.append("\nEvent: ");
        b.append(event);
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        b.append("\nMemory status: used ");
        b.append(total - free);
        b.append(" out of total ");
        b.append(total);
        b.append("\nLog message:\n");
        b.append(message);
        b.append("\nEnd of log message\n\n");
        if (doWrite) {
            VTELogger.writeLogMessage(b.toString());
        } else {
            new VTELogger(b.toString());
        }
    }

    static void reportException(String msg, Throwable t, boolean doWrite) {
        System.out.println("reportException is called");
        StringBuffer b = new StringBuffer(256);
        b.append(msg);
        b.append('\n');
        b.append(VTELogger.logStackTrace(t));
        VTELogger.formatAndLogMessage(b.toString(), "reporting Exception", doWrite);
    }

    static void logMessage(String message, boolean doWrite) {
        System.out.println("logMessage is called");
        VTELogger.formatAndLogMessage(message, "reporting internal VTE mesage", doWrite);
    }

    static void logTestResult(boolean r, String name, VisualTest vtest, Panel testPanel) {
        System.out.println("logTestResult is called");
        StringBuffer b = new StringBuffer(256);
        b.append(vtest.getClass().getName());
        b.append("\nMessage: ");
        b.append(vtest.getLogInfo(testPanel, r));
        VTELogger.formatAndLogMessage(b.toString(), "reporting result for test " + name + " " + (r ? "PASS" : "FAIL"), false);
    }

    static void log(String log, VisualTest v) {
        System.out.println("log is called");
        StringBuffer b = new StringBuffer(256);
        b.append(v.getClass().getName());
        b.append('\n');
        b.append(log);
        VTELogger.formatAndLogMessage(b.toString(), "logging message from test", false);
    }

    static void logException(String log, VisualTest v, Throwable ex) {
        System.out.println("logException is called");
        StringBuffer b = new StringBuffer(256);
        b.append(v.getClass().getName());
        b.append("\nMessage: ");
        b.append(log);
        b.append("\n");
        b.append(VTELogger.logStackTrace(ex));
        VTELogger.formatAndLogMessage(b.toString(), "reporting Exception in test", false);
    }

    private static char[] logStackTrace(Throwable t) {
        try {
            CharArrayWriter cw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(cw);
            t.printStackTrace(pw);
            pw.close();
            return cw.toCharArray();
        }
        catch (Exception e) {
            return ("FAILED TO PRINT A STACKTRACE OF " + t + "\n\tDUE TO :" + e + "\n").toCharArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized void writeLogMessage(String error) {
        block13: {
            FileWriter fw = null;
            fw = new FileWriter("vte.log", true);
            fw.write(error);
            Object var4_2 = null;
            if (fw == null) break block13;
            try {
                fw.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                fw.close();
            }
            catch (IOException e) {}
            break block13;
            {
                catch (IOException iOException) {
                    Object var4_3 = null;
                    if (fw == null) break block13;
                    try {
                        fw.flush();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        fw.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (fw != null) {
                    try {
                        fw.flush();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private VTELogger(String l) {
        this.log = l;
        new Thread(VisualTestEngine.tg, this, "Logger thread " + this).start();
    }

    public void run() {
        VTELogger.writeLogMessage(this.log);
    }

    static {
        try {
            dateFormatter.setTimeZone(TimeZone.getTimeZone("ECT"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

