/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.TextArea;

import com.acunia.wonka.test.awt.VisualTest;
import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.io.Writer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TextAreaBothFixed
extends VisualTestImpl
implements VisualTest,
ActionListener,
TextListener {
    private TextField TF;
    private TextArea RTA;
    private Button toField;
    private Button toArea;
    private Button reset;
    private String areaText;
    private Font cour14;
    private Font helv14;
    private String logString;

    public void actionPerformed(ActionEvent e) {
        String currenttext = this.RTA.getSelectedText();
        int pos = this.RTA.getCaretPosition();
        int start = this.RTA.getSelectionStart();
        int stop = this.RTA.getSelectionEnd();
        String fieldtext = this.TF.getText();
        if (e.getSource() == this.reset) {
            System.out.println("=> Test engine: resetting text of textarea");
            this.RTA.setText(this.areaText);
        } else if (e.getSource() == this.toField) {
            System.out.println("=> Test engine: Copying <" + currenttext + "> to textfield");
            this.TF.setText(currenttext);
            Dimension size = this.RTA.getMinimumSize();
            System.out.println("minimum size = " + size + " pixels");
            size = this.RTA.getPreferredSize();
            System.out.println("Preferred size = " + size + " pixels");
        } else if (start == stop) {
            System.out.println("=> Test engine: inserting <" + fieldtext + "> at position (" + pos + ')');
            this.RTA.insert(fieldtext, pos);
        } else {
            System.out.println("=> Test engine: Caret replacing <" + currenttext + "> by  <" + fieldtext + '>');
            this.RTA.replaceRange(fieldtext, start, stop);
        }
    }

    public void textValueChanged(TextEvent e) {
        System.out.println(e.toString());
    }

    public Panel getPanel() {
        return this;
    }

    public String getTitle() {
        return "TextAreaTest";
    }

    public String getHelpText() {
        String help = "Displays a text area with horizontal and vertical bars, fixed width font (Courier 14 pt)\nItems to test: \n => Scrolling along horizontal scrollbars:\n    -  pressing the arrow boxes should advance one character, keeping the boxes pressed should continue moving the bar\n    -  pressing the spaces between boxes and scrollbox should advance one screen width, keeping the mouse down should continue moving the bar\n    -  the scrollbox can be moved by clicking and dragging it\n also test that the text moves along with the scrollbox\n => Scrolling along vertical scrollbars:\n    -  pressing the arrow boxes should advance one line, keeping the boxes pressed should continue moving the bar\n    -  pressing the spaces between boxes and scrollbox should advance one page, keeping the mouse down should continue moving the bar\n    -  the scrollbox can be moved by clicking and dragging it\n also test that the text moves along with the scrollbox\n => Scrolling by text dragging\n   - selecting and dragging over the right border of the text area should move the scrollbar right. The scrolling can be stopped by moving left again\n   - selecting and dragging over the left border of the text area should move the scrollbar right. The scrolling can be stopped by moving right again\n   - selecting and dragging over the upper border of the text area should move the scrollbar right. The scrolling can be stopped by moving down again\n   - selecting and dragging over the lower border of the text area should move the scrollbar right. The scrolling can be stopped by moving up again\n also test that the scrollboxes move along with the text\n => Text selection\n   - Dragging over a text should select that text. Pressing the <DOWN> button should copy that text into the lower TextField\n => Text insert and replace\n   - Pressing the <UP> button should insert the contents of the TextField into the text area at cursor position\n   - If a part of the TextArea textis selected, pressing the button should replace that text with the contents of the TexField\n";
        return help;
    }

    public void log(Panel p, Writer w) throws IOException {
        w.write(this.logString);
        this.logString = "";
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        int preference = 0;
        if (args.length > 0) {
            if (args[0].startsWith("n") || args[0].startsWith("N")) {
                preference = 3;
            } else if (args[0].startsWith("h") || args[0].startsWith("H")) {
                preference = 2;
            } else if (args[0].startsWith("v") || args[0].startsWith("V")) {
                preference = 1;
            }
        }
        boolean fixedwidth = true;
        if (args.length > 1) {
            fixedwidth = false;
        }
        System.out.println(" building TextArea Example, scrollbars:" + preference + " , fixed width?" + fixedwidth);
        new TextAreaBothFixed(preference, fixedwidth);
    }

    private final /* synthetic */ void this() {
        this.areaText = new String("I) Here Comes Charly\n====================\n\nThese two very old people are the father and mother of Mr Bucket. Their names are Grandpa Joe and Grandma Josephine.\nAnd these two very old people are the father and mother of Mrs Bucket. Their names are Grandpa George and Grandma Georgina.\nThis is Mr Bucket. This is Mrs Bucket.\nMr and Mrs Bucket have a small boy whose name is Charly Bucket.\n\nThis is Charly.\nHow d'you do? And how d'you do?. And how d'you do again? he is pleased to meet you.");
        this.cour14 = new Font("courR14", 0, 14);
        this.helv14 = new Font("helvR14", 0, 14);
    }

    public TextAreaBothFixed() {
        this(0, true);
    }

    public TextAreaBothFixed(int scrollbarmode, boolean fixed) {
        this.this();
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(200, 200, 120));
        this.setForeground(new Color(90, 90, 180));
        this.RTA = new TextArea(this.areaText, 5, 20, scrollbarmode);
        this.RTA.setFont(fixed ? this.cour14 : this.helv14);
        this.add((Component)this.RTA, "Center");
        this.TF = new TextField();
        this.add((Component)this.TF, "South");
        this.reset = new Button("RESET");
        this.reset.addActionListener(this);
        this.add((Component)this.reset, "North");
        this.toField = new Button("DOWN");
        this.toField.addActionListener(this);
        this.add((Component)this.toField, "East");
        this.toArea = new Button(" UP ");
        this.toArea.addActionListener(this);
        this.add((Component)this.toArea, "West");
        this.RTA.addTextListener(this);
        this.setSize(399, 199);
        this.show();
    }
}

