/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.ScrollPane;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ScrollbarDisplay
extends VisualTestImpl
implements ActionListener {
    private PaneButton higher;
    private PaneButton lower;
    private int upperHeight;
    private PaneButton largerLeft;
    private PaneButton largerRight;
    private PaneButton leanerLeft;
    private PaneButton leanerRight;
    private int sideWidth;
    private List display;
    static final int NUMBEROFBUTTONS = 12;

    public ScrollbarDisplay() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        this.upperHeight = 30;
        Panel header = new Panel(new GridLayout(1, 4));
        header.add(new Label());
        this.higher = new PaneButton("Scrollpane HIGHER", 50, this.upperHeight);
        this.higher.addActionListener(this);
        header.add(this.higher);
        this.lower = new PaneButton("Scrollpane LOWER", 50, this.upperHeight);
        this.lower.addActionListener(this);
        header.add(this.lower);
        header.add(new Label());
        this.add((Component)header, "North");
        this.sideWidth = 30;
        Panel left = new Panel(new GridLayout(2, 1));
        Panel right = new Panel(new GridLayout(2, 1));
        this.largerLeft = new PaneButton("<==", this.sideWidth, 50);
        this.largerLeft.addActionListener(this);
        left.add(this.largerLeft);
        this.largerRight = new PaneButton("==>", this.sideWidth, 50);
        this.largerRight.addActionListener(this);
        right.add(this.largerRight);
        this.leanerLeft = new PaneButton("==>", this.sideWidth, 50);
        this.leanerLeft.addActionListener(this);
        left.add(this.leanerLeft);
        this.leanerRight = new PaneButton("<==", this.sideWidth, 50);
        this.leanerRight.addActionListener(this);
        right.add(this.leanerRight);
        this.add((Component)left, "West");
        this.add((Component)right, "East");
        ScrollPane asneededpane = new ScrollPane();
        asneededpane.setBackground(Color.blue);
        int saturation = 128;
        Panel asneeded = new Panel(new GridLayout(3, 4));
        PaneButton[] asneededbuttons = new PaneButton[12];
        for (int i = 0; i < 12; ++i) {
            asneededbuttons[i] = new PaneButton(" Button no." + i, 60, 30, 64, 64, saturation += 8);
            asneededbuttons[i].addActionListener(this);
            asneeded.add(asneededbuttons[i]);
        }
        asneededpane.add(asneeded);
        this.add((Component)asneededpane, "Center");
        this.display = new List(3, false);
        this.display.add("your button events displayed here");
        this.add((Component)this.display, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        if (source == this.lower) {
            if (this.upperHeight < 100) {
                this.upperHeight += 10;
                this.higher.setEnabled(true);
                System.out.println("Lowering ScrollPane: Setting upper height to " + this.upperHeight);
                this.higher.setHeight(this.upperHeight);
                this.lower.setHeight(this.upperHeight);
                this.validate();
                this.repaint();
            } else {
                this.lower.setEnabled(false);
            }
        } else if (source == this.higher) {
            if (this.upperHeight > 20) {
                this.upperHeight -= 10;
                System.out.println("ScrollPane higher: Setting upper height to " + this.upperHeight);
                this.higher.setHeight(this.upperHeight);
                this.lower.setHeight(this.upperHeight);
                this.lower.setEnabled(true);
                this.validate();
                this.repaint();
            } else {
                this.higher.setEnabled(false);
            }
        } else if (source == this.leanerLeft || source == this.leanerRight) {
            if (this.sideWidth < 100) {
                this.sideWidth += 10;
                System.out.println("ScrollPane leaner: Setting side width to " + this.sideWidth);
                this.largerLeft.setWidth(this.sideWidth);
                this.leanerLeft.setWidth(this.sideWidth);
                this.largerRight.setWidth(this.sideWidth);
                this.leanerRight.setWidth(this.sideWidth);
                this.largerLeft.setEnabled(true);
                this.largerRight.setEnabled(true);
                this.validate();
                this.repaint();
            } else {
                this.leanerLeft.setEnabled(false);
                this.leanerRight.setEnabled(false);
            }
        } else if (source == this.largerLeft || source == this.largerRight) {
            if (this.sideWidth > 30) {
                this.sideWidth -= 10;
                System.out.println("ScrollPane larger: Setting side width to " + this.sideWidth);
                this.largerLeft.setWidth(this.sideWidth);
                this.leanerLeft.setWidth(this.sideWidth);
                this.largerRight.setWidth(this.sideWidth);
                this.leanerRight.setWidth(this.sideWidth);
                this.leanerLeft.setEnabled(true);
                this.leanerRight.setEnabled(true);
                this.validate();
                this.repaint();
            } else {
                this.largerLeft.setEnabled(false);
                this.largerRight.setEnabled(false);
            }
        } else {
            this.displayMessage("Pressed : " + source.getActionCommand());
        }
    }

    public void displayMessage(String message) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        this.display.add(message, 0);
    }

    public String getHelpText() {
        return "Tests the layout of the ScrollPane screen and the display of the Scrollbars in a default ScrollPane with default lauout policy ScrollPane.SCROLLBARS_AS_NEEDED\nThe scrollbar is located in the center of the screen. Using the higher/lower buttons and the <== ==> buttons, you can resize the surrounding buttons, leaving more or less space for the display. Like this, it is possible to obtain all of the four cases: no scrollbars, only horizontal scrollbar, only vertical scrollbar and both bars.\n in all of the cases, make sure that when selecting a button from the ScrollPane, the event for that button is displayed in the list below, regardless of the scrollbars and scrollbar offset shown";
    }

    class PaneButton
    extends Button {
        private int preferredWidth;
        private int preferredHeight;

        public PaneButton(String text, int width, int height) {
            super(text);
            this.setActionCommand(text);
            this.preferredWidth = width;
            this.preferredHeight = height;
            this.setSize(width, height);
        }

        public PaneButton(String text, int width, int height, int red, int green, int blue) {
            super(text);
            this.setBackground(new Color(red, green, blue));
            this.setActionCommand(text);
            this.preferredWidth = width;
            this.preferredHeight = height;
            this.setSize(width, height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }

        public void setWidth(int width) {
            this.preferredWidth = width;
            this.setSize(width, this.preferredHeight);
        }

        public void setHeight(int height) {
            this.preferredHeight = height;
            this.setSize(this.preferredWidth, height);
        }
    }
}

