/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;

public class ImageFilter
extends VisualTestImpl {
    private Image original;
    private Image trans;
    private Image flip1;
    private Image flip2;
    private Image flip3;

    public ImageFilter() {
        String path = System.getProperty("property.path", "/test");
        this.original = Toolkit.getDefaultToolkit().getImage(path + "/lena1.png");
        this.trans = this.createImage(new FilteredImageSource(this.original.getSource(), new TransFilter()));
        this.flip1 = this.createImage(new FilteredImageSource(this.original.getSource(), new FlipFilter(true, false)));
        this.flip2 = this.createImage(new FilteredImageSource(this.original.getSource(), new FlipFilter(false, true)));
        this.flip3 = this.createImage(new FilteredImageSource(this.original.getSource(), new FlipFilter(true, true)));
        this.setBackground(Color.black);
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.drawImage(this.original, 10, 10, null);
        g.drawString("   Original   ", 45, 85);
        g.drawImage(this.flip1, 150, 10, null);
        g.drawString("  Horizontal  ", 185, 85);
        g.drawImage(this.flip2, 10, 100, null);
        g.drawString("   Vertical   ", 45, 175);
        g.drawImage(this.flip3, 150, 100, null);
        g.drawString("     Both     ", 185, 175);
        g.drawImage(this.trans, 290, 10, null);
        g.drawString("  Transposed  ", 295, 140);
    }

    public String getHelpText() {
        return "";
    }

    public class FlipFilter
    extends java.awt.image.ImageFilter {
        private boolean hor;
        private boolean ver;
        private int width;
        private int height;

        public FlipFilter(boolean hor, boolean ver) {
            this.hor = hor;
            this.ver = ver;
        }

        public void setDimensions(int w, int h) {
            super.setDimensions(w, h);
            this.width = w;
            this.height = h;
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            int[] newpixels = new int[pixels.length];
            int nx = this.hor ? this.width - x - w : x;
            int ny = this.ver ? this.height - y - h : y;
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[(this.ver ? h - 1 - i : i) * w + (this.hor ? w - 1 - j : j)] = pixels[i * scansize + j + off];
                }
            }
            super.setPixels(nx, ny, w, h, model, newpixels, 0, w);
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int[] newpixels = new int[pixels.length];
            int nx = this.hor ? this.width - x - w : x;
            int ny = this.ver ? this.height - y - h : y;
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[(this.ver ? h - 1 - i : i) * w + (this.hor ? w - 1 - j : j)] = pixels[i * scansize + j + off];
                }
            }
            super.setPixels(nx, ny, w, h, model, newpixels, 0, w);
        }
    }

    public class TransFilter
    extends java.awt.image.ImageFilter {
        public void setDimensions(int w, int h) {
            super.setDimensions(h, w);
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            int[] newpixels = new int[pixels.length];
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[j * h + i] = pixels[i * scansize + j + off];
                }
            }
            super.setPixels(y, x, h, w, model, newpixels, 0, h);
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int[] newpixels = new int[pixels.length];
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[j * h + i] = pixels[i * scansize + j + off];
                }
            }
            super.setPixels(y, x, h, w, model, newpixels, 0, h);
        }
    }
}

