/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.Random;

public class DisplayPNG
extends VisualTestImpl {
    int cellSize = 50;

    public DisplayPNG() {
        Dimension dim = new Dimension(400, 234);
        Random rand_nr = new Random();
        int number = 0;
        String pathname = "/png/";
        File dir = new File(pathname);
        String[] png_names = dir.list();
        for (int i = 0; i < 28; ++i) {
            number = Math.abs(rand_nr.nextInt()) % png_names.length;
            if (!png_names[number].endsWith(".png") && !png_names[number].endsWith(".jpg") && !png_names[number].endsWith(".gif")) continue;
            Thumbnail thumby = new Thumbnail(Toolkit.getDefaultToolkit().getImage(dir.getAbsolutePath() + File.separator + png_names[number]), png_names[number]);
            thumby.setSize(this.cellSize, this.cellSize);
            this.add(thumby);
        }
        this.setLayout(new FlowLayout());
        this.setSize(dim);
        this.setVisible(true);
    }

    public String getHelpText() {
        return "This test randomly return images (.jpg, .png or .gif) from a directory and displays them in a FlowLayout on the screen.";
    }

    class Thumbnail
    extends Canvas {
        Image image;
        String name;

        Thumbnail(Image image, String name) {
            this.image = image;
            this.name = name;
        }

        public Dimension getPreferredSize() {
            return new Dimension(50, 50);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            int iw = this.image.getWidth(this);
            int ih = this.image.getHeight(this);
            if (iw > 0 && ih > 0) {
                if (iw > h) {
                    ih = ih * w / iw;
                    iw = w;
                }
                if (ih > h && ih > 0) {
                    iw = iw * h / ih;
                    ih = h;
                }
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, w, h);
                g.drawImage(this.image, (w - iw) / 2, (h - ih) / 2, iw, ih, this);
            }
        }
    }
}

