/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;

public class CropImageFilter
extends VisualTestImpl
implements MouseListener,
MouseMotionListener {
    private Image original;
    private Image cropped;
    private java.awt.image.CropImageFilter filter;
    private FilteredImageSource source;
    private Rectangle crop;
    private Point lastClick;
    private boolean pressed = false;

    public CropImageFilter() {
        this.setBackground(Color.black);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.crop = new Rectangle(72, 59, 77, 18);
        this.lastClick = new Point();
        String path = System.getProperty("property.path", "/test");
        this.original = Toolkit.getDefaultToolkit().getImage(path + "/lena2.png");
        this.repaint();
    }

    public void update(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 500, 500);
        g.drawImage(this.original, 10, 10, null);
        g.setColor(Color.white);
        g.drawRect(10 + this.crop.x, 10 + this.crop.y, this.crop.width, this.crop.height);
        if (!this.pressed) {
            this.filter = new java.awt.image.CropImageFilter(this.crop.x, this.crop.y, this.crop.width, this.crop.height);
            this.source = new FilteredImageSource(this.original.getSource(), this.filter);
            this.cropped = this.createImage(this.source);
            g.drawImage(this.cropped, 220, 10, null);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public String getHelpText() {
        return "";
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.pressed = true;
        this.lastClick.setLocation(event.getX() - 10, event.getY() - 10);
        this.crop.setBounds(this.lastClick.x, this.lastClick.y, 0, 0);
        this.repaint();
    }

    public void mouseReleased(MouseEvent event) {
        this.pressed = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent event) {
        int x1 = this.lastClick.x;
        int y1 = this.lastClick.y;
        int x2 = event.getX() - 10;
        int y2 = event.getY() - 10;
        this.crop.setBounds(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
        this.repaint();
    }

    public void mouseMoved(MouseEvent event) {
    }
}

