/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Image;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;

public class AnimatedGif
extends VisualTestImpl {
    private ImageComponent pic1;
    private ImageComponent pic2;
    private ImageComponent pic3;

    public AnimatedGif() {
        String path = System.getProperty("property.path", "/test");
        Image img = Toolkit.getDefaultToolkit().getImage(path + "/rudolph3.gif");
        if (img == null) {
            return;
        }
        MediaTracker m = new MediaTracker(this);
        m.addImage(img, 0);
        try {
            m.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Toolkit.getDefaultToolkit().prepareImage(img, -1, -1, null);
        this.pic1 = new ImageComponent(img);
        this.pic2 = new ImageComponent(img, 0.75, 0.75);
        this.pic3 = new ImageComponent(img, 0.5, 0.5);
        Label copyright = new Label("image (c) Kitty Roach");
        copyright.setForeground(new Color(180, 180, 180));
        this.setLayout(null);
        this.add(this.pic1);
        this.add(this.pic2);
        this.add(this.pic3);
        this.add(copyright);
        this.setBackground(Color.white);
        this.pic1.setBounds(10, 10, this.pic1.getPreferredSize().width, this.pic1.getPreferredSize().height);
        this.pic2.setBounds(140, 10, this.pic2.getPreferredSize().width, this.pic2.getPreferredSize().height);
        this.pic3.setBounds(240, 10, this.pic3.getPreferredSize().width, this.pic3.getPreferredSize().height);
        copyright.setBounds(10, 90, copyright.getPreferredSize().width, copyright.getPreferredSize().height);
        this.validate();
    }

    public String getHelpText() {
        return "";
    }

    public class ImageComponent
    extends Component {
        Image img;
        double scale_x;
        double scale_y;

        public ImageComponent(Image img) {
            this(img, 1.0, 1.0);
        }

        public ImageComponent(Image img, double sx, double sy) {
            this.scale_x = sx;
            this.scale_y = sy;
            this.img = img;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)((double)this.img.getWidth(null) * this.scale_x), (int)((double)this.img.getHeight(null) * this.scale_y));
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, (int)((double)this.img.getWidth(null) * this.scale_x), (int)((double)this.img.getHeight(null) * this.scale_y), this);
            }
        }
    }
}

