/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.GridBagLayout;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class MinimumSizeBorder
extends VisualTestImpl {
    private static final int LAMPWIDTH = 20;
    private static final int LAMPHEIGHT = 20;
    private List display;

    public MinimumSizeBorder() {
        int gray = 32;
        this.setLayout(new BorderLayout());
        this.setForeground(Color.white);
        this.setBackground(new Color(gray, gray, gray));
        gray += 16;
        this.display = new List(2, false);
        this.display.add("Observer ImageUpdate() dispayed here");
        this.add((Component)this.display, "South");
        Panel panels = new Panel(new GridLayout(1, 4));
        Panel none = new Panel(new BorderLayout());
        none.add((Component)new TrafficLightComponent("Vertical layout, No size definitions, EAST", new Color(gray += 16, gray, gray)), "North");
        none.add((Component)new TrafficLightComponent("Vertical layout, No size definitions, WEST", new Color(gray += 16, gray, gray)), "West");
        none.add((Component)new RainbowComponent("horizontal layout, No size definitions, SOUTH", new Color(gray += 16, gray, gray)), "South");
        none.add((Component)new RainbowComponent("horizontal layout, No size definitions, EAST", new Color(gray += 16, gray, gray)), "East");
        gray += 16;
        panels.add(none);
        Panel min = new Panel(new BorderLayout());
        min.add((Component)new MinTrafficLight("Vertical layout, Minimum size definition, EAST", new Color(gray += 16, gray, gray)), "North");
        min.add((Component)new MinTrafficLight("Vertical layout, Minimum size definition, WEST", new Color(gray += 16, gray, gray)), "West");
        min.add((Component)new MinRainbow("horizontal layout, Minimum size definition, SOUTH", new Color(gray += 16, gray, gray)), "South");
        min.add((Component)new MinRainbow("horizontal layout, Minimum size definition, EAST", new Color(gray += 16, gray, gray)), "East");
        gray += 16;
        panels.add(min);
        Panel pref = new Panel(new BorderLayout());
        pref.add((Component)new PrefTrafficLight("Vertical layout, Preferred size definition, EAST", new Color(gray -= 16, gray, gray)), "North");
        pref.add((Component)new PrefTrafficLight("Vertical layout, Preferred size definition, WEST", new Color(gray -= 16, gray, gray)), "West");
        pref.add((Component)new PrefRainbow("horizontal layout, Preferred size definition, SOUTH", new Color(gray -= 16, gray, gray)), "South");
        pref.add((Component)new PrefRainbow("horizontal layout, Preferred size definition, EAST", new Color(gray -= 16, gray, gray)), "East");
        gray -= 16;
        panels.add(pref);
        Panel max = new Panel(new BorderLayout());
        max.add((Component)new MaxTrafficLight("Vertical layout, Maximum size definition, EAST", new Color(gray -= 16, gray, gray)), "North");
        max.add((Component)new MaxTrafficLight("Vertical layout, Maximum size definition, WEST", new Color(gray -= 16, gray, gray)), "West");
        max.add((Component)new MaxRainbow("horizontal layout,Maximum  size definition, SOUTH", new Color(gray -= 16, gray, gray)), "South");
        max.add((Component)new MaxRainbow("horizontal layout,Maximum  size definition, EAST", new Color(gray -= 16, gray, gray)), "East");
        gray -= 16;
        panels.add(max);
        this.add((Component)panels, "Center");
    }

    private void displayMessage(String text) {
        if (this.display.getItemCount() > 40) {
            this.display.removeAll();
        }
        System.out.println(text);
        this.display.add(text, 0);
    }

    public String getHelpText() {
        return "A test to verify Rudolph's GridbagLayout implementation\nThe main screen is devided into four parts, each having a borderlayout to which are added two horizontal and two vertical elements\nThe horizontal and vertical elements again consist out of three colored rectangles (graphic Components), added to the element in a gridbagLayout similar to the layout uded by the IAA demo scrollbar\nThe four parts of the main screen each have..\n-> a vertical element added NORTH (forces the element to be layed out to its minimum height)\n-> a vertical element added WEST (allows the element to be layed out using the available spare height)\n-> a horizontal element added SOUTH (allows the element to be layed out using the available panel width)\n-> a horizontal element added EAST (forces the element to be layed out to its minimum width)\nFor all four panels, a different subclass of the elements is used, each defining a minimum, maximum or preferred size. The defined size is the smallest size showing all three rectangles, ergo rectangle width and three times rectangle height for the vertical element and three times rectangle width/one time rectangle height for the horizontal one.\n-> for the most left panel, the elements have NO minimum, maximum or preferred size at all\n-> for the inner left panel, the elements have a minimum size defined\n-> for the inner right panel, the elements have a preferred size defined\n-> for the outer right panel, the elements have a maximum size defined\nClicking on one of the element, shows the type, layout and size definition for that element in the list below";
    }

    public static void main(String[] args) {
        MinimumSizeBorder tf = new MinimumSizeBorder();
        tf.show();
    }

    static /* synthetic */ void access$200(MinimumSizeBorder x0, String x1) {
        x0.displayMessage(x1);
    }

    class FillComponent
    extends Component {
        private Dimension bounds;
        private Rectangle innerRect;
        private int middle;
        private String name;
        private Color background;

        public FillComponent(String parent, int width, int height, Color back) {
            this.background = back;
            this.name = parent;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ FillComponent this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent evt) {
                    MinimumSizeBorder.access$200(FillComponent.access$100(this.this$1), FillComponent.access$000(this.this$1));
                }
            });
            this.bounds = new Dimension();
            this.innerRect = new Rectangle(0, 0, width - 4, height - 4);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.innerRect.width, this.innerRect.height);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.bounds.equals(this.getSize())) {
                this.bounds.setSize(this.getSize());
                this.innerRect.setLocation((this.bounds.width - this.innerRect.width) / 2, (this.bounds.height - this.innerRect.height) / 2);
                this.middle = this.getSize().height / 2;
            }
            g.setColor(this.background);
            g.fillRect(1, 1, this.bounds.width - 1, this.bounds.height - 1);
            g.setColor(this.getBackground());
            g.drawRect(this.innerRect.x + 2, this.innerRect.y + 2, this.innerRect.width - 4, this.innerRect.height - 4);
            g.drawLine(this.innerRect.x, this.innerRect.y, this.innerRect.x + this.innerRect.width, this.innerRect.y + this.innerRect.height);
            g.drawLine(this.innerRect.x, this.innerRect.y + this.innerRect.height, this.innerRect.x + this.innerRect.width, this.innerRect.y);
        }

        static /* synthetic */ String access$000(FillComponent x0) {
            return x0.name;
        }

        static /* synthetic */ MinimumSizeBorder access$100(FillComponent x0) {
            return x0.MinimumSizeBorder.this;
        }
    }

    class PrefRainbow
    extends RainbowComponent {
        public PrefRainbow(String name, Color background) {
            super(name, background);
        }

        public Dimension getPreferredSize() {
            return new Dimension(60, 20);
        }
    }

    class MaxRainbow
    extends RainbowComponent {
        public MaxRainbow(String name, Color background) {
            super(name, background);
        }

        public Dimension getMaximumSize() {
            return new Dimension(60, 20);
        }
    }

    class MinRainbow
    extends RainbowComponent {
        public MinRainbow(String name, Color background) {
            super(name, background);
        }

        public Dimension getMinimumSize() {
            return new Dimension(60, 20);
        }
    }

    class RainbowComponent
    extends Panel {
        protected FillComponent red;
        protected FillComponent green;
        protected FillComponent blue;

        public RainbowComponent(String name, Color background) {
            this.setBackground(background);
            this.red = new FillComponent(name, 20, 20, Color.red);
            this.green = new FillComponent(name, 20, 20, Color.green);
            this.blue = new FillComponent(name, 20, 20, Color.blue);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.add((Component)this.red, gbc);
            this.add((Component)this.green, gbc);
            this.add((Component)this.blue, gbc);
        }
    }

    class PrefTrafficLight
    extends TrafficLightComponent {
        public PrefTrafficLight(String name, Color background) {
            super(name, background);
        }

        public Dimension getPreferredSize() {
            return new Dimension(20, 60);
        }
    }

    class MaxTrafficLight
    extends TrafficLightComponent {
        public MaxTrafficLight(String name, Color background) {
            super(name, background);
        }

        public Dimension getMaximumSize() {
            return new Dimension(20, 60);
        }
    }

    class MinTrafficLight
    extends TrafficLightComponent {
        public MinTrafficLight(String name, Color background) {
            super(name, background);
        }

        public Dimension getMinimumSize() {
            return new Dimension(20, 60);
        }
    }

    class TrafficLightComponent
    extends Panel {
        protected FillComponent red;
        protected FillComponent yellow;
        protected FillComponent green;

        public TrafficLightComponent(String name, Color background) {
            this.setBackground(background);
            this.red = new FillComponent(name, 20, 20, Color.red);
            this.yellow = new FillComponent(name, 20, 20, Color.yellow);
            this.green = new FillComponent(name, 20, 20, Color.green);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            this.add((Component)this.red, gbc);
            this.add((Component)this.yellow, gbc);
            this.add((Component)this.green, gbc);
        }
    }
}

