/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class DrawImage
extends VisualTestImpl {
    public Panel getPanel(VisualTester vte) {
        this.vt = vte;
        return new MCanvas();
    }

    public String getHelpText() {
        return "Basis for this test is an image, composed of concentric rectangular planes, each filled with different colors. Furthermore the image is divided in 8 rectangle of equal size. The borders of these rectangles are drawn in red. These borders are used to show a violation of the sun specs by the sun java awt: a 1 pixel wide right and bottom border, is never drawn by some versions of the method \"Graphics.drawImage()\". The image is first displayed as a whole, with the inscription \"SOURCE IMAGE\". After that, the image is displayed 6 times with different origins, as a sequence of 8 sub-images of equal size. The first time of this series of 6, the origin is (0,0) and each subimage is, in turn, displayed and erased. The second, third, forth, fifth and sixt time, subimages are erased only after all subimages have become visible. The second time the origin is still (0,0). The third time the origin is shifted to about (-50,-50). The forth time the origin is shifted to about (50,-50). The fifth time the origin is (50,50) and the sixth time it is (-50, 50).";
    }

    public void start(Panel p, boolean autorun) {
        try {
            new Thread((Runnable)((MCanvas)p), "DrawImage Thread").start();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void stop(Panel p) {
        try {
            ((MCanvas)p).stop = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new DrawImage();
    }

    class MCanvas
    extends Panel
    implements Runnable {
        Image backBuffer = null;
        Graphics backG = null;
        int nbrRect = 10;
        int R = 256 / this.nbrRect;
        int G = 256 / this.nbrRect;
        int B = 255 / this.nbrRect;
        int x;
        int y;
        boolean stop = false;
        int step = 0;

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            block29: {
                try {
                    int W = this.getBounds().width;
                    int H = this.getBounds().height;
                    int w4 = W / 4;
                    int h2 = H / 2;
                    int w = 4 * w4;
                    int h = 2 * h2;
                    g.setFont(new Font("HelvB24", 1, 30));
                    FontMetrics fm = g.getFontMetrics();
                    if (this.backBuffer == null || this.backBuffer.getWidth(null) != w || this.backBuffer.getHeight(null) != h) {
                        int x = w / (2 * this.nbrRect);
                        int y = h / (2 * this.nbrRect);
                        this.backBuffer = this.createImage(w, h);
                        if (this.backBuffer != null) {
                            this.backG = this.backBuffer.getGraphics();
                            for (int i = 0; i < this.nbrRect; ++i) {
                                this.backG.setColor(new Color(255 - this.R * i, 255 - this.G * i, this.B * i));
                                this.backG.fillRect(x * i, y * i, w - x * 2 * i, h - y * 2 * i);
                            }
                            this.backG.setColor(Color.red);
                            for (int j = 0; j < h - 2; j += h2) {
                                for (int i = 0; i < w - 4; i += w4) {
                                    this.backG.drawRect(i, j, w4 - 1, h2 - 1);
                                }
                            }
                        }
                    }
                    if (this.backBuffer == null) break block29;
                    switch (this.step) {
                        case 0: {
                            g.clearRect(0, 0, W, H);
                            g.drawImage(this.backBuffer, 0, 0, w, h, null);
                            g.setColor(Color.white);
                            g.drawString("SOURCE IMAGE", (w - fm.stringWidth("SOURCE IMAGE")) / 2, h2 + fm.getAscent() / 2);
                            break;
                        }
                        case 1: {
                            int i;
                            int j;
                            g.clearRect(0, 0, W, H);
                            for (j = 0; j < h - 2; j += h2) {
                                for (i = 0; i < w - 4; i += w4) {
                                    g.drawImage(this.backBuffer, i, j, i + w4 - 1, j + h2 - 1, i, j, i + w4 - 1, j + h2 - 1, null);
                                    Thread.sleep(100L);
                                    g.clearRect(i, j, i + w4, j + h2);
                                }
                            }
                            break;
                        }
                        case 2: {
                            int i;
                            int j;
                            g.clearRect(0, 0, W, H);
                            for (j = 0; j < h - 2; j += h2) {
                                for (i = 0; i < w - 4; i += w4) {
                                    g.drawImage(this.backBuffer, i, j, i + w4 - 1, j + h2 - 1, i, j, i + w4 - 1, j + h2 - 1, null);
                                    Thread.sleep(50L);
                                }
                            }
                            break;
                        }
                        case 3: {
                            int i;
                            int j;
                            g.clearRect(0, 0, W, H);
                            for (j = 0; j < h - 2; j += h2) {
                                for (i = 0; i < w - 4; i += w4) {
                                    g.drawImage(this.backBuffer, i - w / 8, j - h / 4, i - w / 8 + w4 - 1, j + h2 - h / 4 - 1, i, j, i + w4 - 1, j + h2 - 1, null);
                                    Thread.sleep(50L);
                                }
                            }
                            break;
                        }
                        case 4: {
                            int i;
                            int j;
                            g.clearRect(0, 0, W, H);
                            for (j = 0; j < h - 2; j += h2) {
                                for (i = 0; i < w - 4; i += w4) {
                                    g.drawImage(this.backBuffer, i + w / 8, j - h / 4, i + w / 8 + w4 - 1, j + h2 - h / 4 - 1, i, j, i + w4 - 1, j + h2 - 1, null);
                                    Thread.sleep(50L);
                                }
                            }
                            break;
                        }
                        case 5: {
                            int i;
                            int j;
                            g.clearRect(0, 0, W, H);
                            for (j = 0; j < h - 2; j += h2) {
                                for (i = 0; i < w - 4; i += w4) {
                                    g.drawImage(this.backBuffer, i + w / 8, j + h / 4, i + w / 8 + w4 - 1, j + h2 + h / 4 - 1, i, j, i + w4 - 1, j + h2 - 1, null);
                                    Thread.sleep(50L);
                                }
                            }
                            break;
                        }
                        case 6: {
                            int i;
                            int j;
                            g.clearRect(0, 0, W, H);
                            for (j = 0; j < h - 2; j += h2) {
                                for (i = 0; i < w - 4; i += w4) {
                                    g.drawImage(this.backBuffer, i - w / 8, j + h / 4, i - w / 8 + w4 - 1, j + h2 + h / 4 - 1, i, j, i + w4 - 1, j + h2 - 1, null);
                                    Thread.sleep(50L);
                                }
                            }
                            break;
                        }
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("caught Interrupted Exception " + e);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void run() {
            try {
                int w1 = 0;
                int h1 = 0;
                int w2 = 400;
                int h2 = 234;
                while (w1 == 0 || h1 == 0 || w1 != w2 || h1 != h2) {
                    w2 = w1;
                    h2 = h1;
                    Thread.sleep(80L);
                    w1 = this.getBounds().width;
                    h1 = this.getBounds().height;
                }
                while (!this.stop) {
                    this.repaint();
                    Thread.sleep(1000L);
                    this.step = (this.step + 1) % 7;
                }
            }
            catch (InterruptedException e) {
                DrawImage.this.vt.logException("caught Interrupted Exception ", DrawImage.this, e);
                e.printStackTrace();
            }
            catch (Throwable t) {
                DrawImage.this.vt.logException("caught Throwable Exception", DrawImage.this, t);
                t.printStackTrace();
            }
        }
    }
}

