/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.TextField;

public class DrawColor
extends VisualTestImpl {
    static Color LIGHTBLUE = new Color(160, 160, 255);
    static Color INDIGO = new Color(0, 0, 192);
    static Color VIOLET = new Color(128, 0, 128);
    private TextTester tester;
    private TextField messenger;
    String logString;

    public DrawColor() {
        this.setLayout(new BorderLayout());
        this.tester = new TextTester();
        this.messenger = new TextField();
        this.add((Component)this.tester, "Center");
        this.add((Component)this.messenger, "South");
        this.logString = "ComponentGraphics log:";
    }

    public String getLogInfo(Panel p, boolean b) {
        String result = this.logString;
        this.logString = "    (Written to log):";
        return result;
    }

    public String getTitle() {
        return "ComponentGraphics";
    }

    public String getHelpText() {
        return "";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        new DrawColor();
    }

    class TextTester
    extends Component {
        private Dimension canvas = new Dimension();
        private int seventh;
        private int half;
        private Font f1 = new Font("courP14", 0, 14);
        private Font f2 = new Font("helvP14", 0, 18);
        private Font f3 = new Font("courP24", 0, 24);

        TextTester() {
        }

        public void paint(Graphics g) {
            if (!this.canvas.equals(this.getSize())) {
                this.setSize(this.getSize());
            }
            int current = 5;
            for (int i = 0; i < 7; ++i) {
                g.setColor(this.getColor(i));
                g.drawLine(this.half - 5, current, this.half + 5, current + this.seventh - 7);
                g.drawLine(this.half + 5, current, this.half - 5, current + this.seventh - 7);
                g.drawRect(5, current, this.half - 10, this.seventh - 7);
                g.fillRect(this.half + 5, current, this.half - 10, this.seventh - 7);
                g.setFont(this.f2);
                g.drawString(this.getColorName(i), 20, current + 17);
                current += this.seventh;
            }
        }

        public void setSize(Dimension newsize) {
            this.seventh = newsize.height / 7;
            this.half = newsize.width / 2;
            this.canvas.setSize(newsize);
        }

        private Color getColor(int i) {
            if (i < 0) {
                return Color.black;
            }
            if ((i %= 7) < 1) {
                return Color.red;
            }
            if (i < 2) {
                return Color.orange;
            }
            if (i < 3) {
                return Color.yellow;
            }
            if (i < 4) {
                return Color.green;
            }
            if (i < 5) {
                return LIGHTBLUE;
            }
            if (i < 6) {
                return INDIGO;
            }
            return VIOLET;
        }

        private String getColorName(int i) {
            if (i < 0) {
                return "(black)";
            }
            if ((i %= 7) < 1) {
                return "<RED>";
            }
            if (i < 2) {
                return "<ORANGE>";
            }
            if (i < 3) {
                return "<YELLOW>";
            }
            if (i < 4) {
                return "<GREEN>";
            }
            if (i < 5) {
                return "<BLUE>";
            }
            if (i < 6) {
                return "<INDIGO>";
            }
            return "<VIOLET>";
        }
    }
}

