/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class CopyArea
extends VisualTestImpl {
    public Panel getPanel(VisualTester vte) {
        this.vt = vte;
        return new MCanvas();
    }

    public String getHelpText() {
        return "Test for method \"Graphics.copyArea()\". \n Four times a part of the screen is replicated several times horizontally and vertically such that the screen is completely filled. Each time, the screen part that is replicated is a rectangular area consisting of two smaller rectangles, filled with different colors.\n 1) in the first run, the rectangular area is located in the top-center part of the screen, with its upper half colored dark-yellow, and its lower half colored light-yellow.The screen is filled from left to right and from top to bottom with copies of that rectangle. Vertical copies are half overlapping. The result should be that the whole screen area is colored dark-yellow.\n 2) The 2nd run: the rectangular area is located in the bottom-center part of the screen, with its upper half colored dark-yellow, and its lower half colored light-yellow,like in the first run. The screen is filled from right to left and from bottom to top with copies of that rectangle. Vertical copies are half overlapping. The result should be that the whole screen area is colored light-yellow.\n 3) The 3rd run: the rectangular area is located in the center-left part of the screen, with its left half colored light-purple, and its right half colored dark-purple. The screen is filled from top to bottom and from left to right with copies of that rectangle. Horizontal copies are half overlapping. The result should be that the whole screen area is colored light-purple.\n 4) The 4th run: the rectangular area is located in the center-right part of the screen, with its left half colored light-purple, and its right half colored dark-purple,like in the 3rd run. The screen is filled from bottom to top and from right to left with copies of that rectangle. Horizontal copies are half overlapping. The result should be that the whole screen area is colored dark-purple.\n ";
    }

    public void start(Panel p, boolean autorun) {
        try {
            new Thread((Runnable)((MCanvas)p), "CopyArea Thread").start();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void stop(Panel p) {
        try {
            ((MCanvas)p).stop = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new CopyArea();
    }

    class MCanvas
    extends Panel
    implements Runnable {
        Image backBuffer = null;
        Graphics backG = null;
        int nbrRect = 10;
        int R = 256 / this.nbrRect;
        int G = 256 / this.nbrRect;
        int B = 255 / this.nbrRect;
        int x;
        int y;
        boolean stop = false;
        int step = 0;

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            try {
                int W = this.getBounds().width;
                int H = this.getBounds().height;
                int w4 = W / 4;
                int h4 = H / 4;
                int w2 = w4 + w4;
                int h2 = h4 + h4;
                switch (this.step) {
                    case 0: {
                        g.clearRect(0, 0, W, H);
                        g.setColor(new Color(255, 200, 0));
                        g.fillRect(w4, 0, w2, h4);
                        g.setColor(new Color(255, 255, 0));
                        g.fillRect(w4, h4, w2, h4);
                        for (int j = 0; j < 3; ++j) {
                            for (int i = -1; i < 2; ++i) {
                                Thread.sleep(50L);
                                g.copyArea(w4, 0, w2, h2, w2 * i, h4 * j);
                            }
                        }
                        break;
                    }
                    case 1: {
                        g.clearRect(0, 0, W, H);
                        g.setColor(new Color(255, 200, 0));
                        g.fillRect(w4, h2, w2, h4);
                        g.setColor(new Color(255, 255, 0));
                        g.fillRect(w4, h2 + h4, w2, h4);
                        for (int j = 0; j > -3; --j) {
                            for (int i = 1; i > -2; --i) {
                                Thread.sleep(50L);
                                g.copyArea(w4, h2, w2, h2, w2 * i, h4 * j);
                            }
                        }
                        break;
                    }
                    case 2: {
                        g.clearRect(0, 0, W, H);
                        g.setColor(new Color(255, 0, 255));
                        g.fillRect(0, h4, w4, h2);
                        g.setColor(new Color(200, 0, 255));
                        g.fillRect(w4, h4, w4, h2);
                        for (int i = 0; i < 3; ++i) {
                            for (int j = -1; j < 2; ++j) {
                                Thread.sleep(50L);
                                g.copyArea(0, h4, w2, h2, w4 * i, h2 * j);
                            }
                        }
                        break;
                    }
                    case 3: {
                        g.clearRect(0, 0, W, H);
                        g.setColor(new Color(255, 0, 255));
                        g.fillRect(w2, h4, w4, h2);
                        g.setColor(new Color(200, 0, 255));
                        g.fillRect(w2 + w4, h4, w4, h2);
                        for (int i = 0; i > -3; --i) {
                            for (int j = 1; j > -2; --j) {
                                Thread.sleep(50L);
                                g.copyArea(w2, h4, w2, h2, w4 * i, h2 * j);
                            }
                        }
                        break;
                    }
                    default: {
                        g.clearRect(0, 0, W, H);
                    }
                }
            }
            catch (InterruptedException e) {
                System.out.println("caught Interrupted Exception " + e);
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void run() {
            try {
                int w1 = 0;
                int h1 = 0;
                int w2 = 400;
                int h2 = 234;
                while (w1 == 0 || h1 == 0 || w1 != w2 || h1 != h2) {
                    w2 = w1;
                    h2 = h1;
                    Thread.sleep(80L);
                    w1 = this.getBounds().width;
                    h1 = this.getBounds().height;
                }
                this.step = 4;
                this.repaint();
                this.step = 0;
                while (!this.stop) {
                    Thread.sleep(2000L);
                    this.repaint();
                    this.step = (this.step + 1) % 4;
                }
            }
            catch (InterruptedException e) {
                System.out.println("caught Interrupted Exception " + e);
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

