/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Graphics;

import com.acunia.wonka.test.awt.VisualTestImpl;
import com.acunia.wonka.test.awt.VisualTester;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Writer;

public class ClipPoly
extends VisualTestImpl
implements ActionListener {
    ClipPolygonPanel blackboard = new ClipPolygonPanel();
    Button left;
    Button right;
    Button up;
    Button down;
    Button center;
    Button mode;

    public ClipPoly() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.blackboard, "Center");
        this.left = new Button("left");
        this.left.addActionListener(this);
        this.up = new Button("up");
        this.up.addActionListener(this);
        this.right = new Button("right");
        this.right.addActionListener(this);
        this.center = new Button("Center image");
        this.center.addActionListener(this);
        this.down = new Button("down");
        this.down.addActionListener(this);
        this.mode = new Button(this.blackboard.isFillMode() ? "draw" : "fill");
        this.mode.addActionListener(this);
        Panel buttonrow = new Panel(new GridLayout(2, 3));
        buttonrow.add(this.left);
        buttonrow.add(this.up);
        buttonrow.add(this.right);
        buttonrow.add(this.center);
        buttonrow.add(this.down);
        buttonrow.add(this.mode);
        this.add((Component)buttonrow, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.left) {
            this.blackboard.translate(-1, 0);
        } else if (evt.getSource() == this.right) {
            this.blackboard.translate(1, 0);
        } else if (evt.getSource() == this.up) {
            this.blackboard.translate(0, -1);
        } else if (evt.getSource() == this.down) {
            this.blackboard.translate(0, 1);
        } else if (evt.getSource() == this.center) {
            this.blackboard.center();
        } else if (evt.getSource() == this.mode) {
            this.blackboard.swapFillMode();
            this.mode.setLabel(this.blackboard.isFillMode() ? "draw" : "fill");
        }
    }

    public void log(Panel p, Writer w, boolean b) throws IOException {
        w.write("ClipPoly ");
    }

    public String getTitle() {
        return "Polygon clipping test";
    }

    public String getHelpText() {
        return "Clipping test for Polygon class and functions g.drawPolygon() and g.fillPolygon() \nmove the java.awt.Polygon figure over the screen, either using the up/down/left/right buttons \nor by clicking in the figure and dragging it\n\nTest issues:\n=> When moving the polygon over the screen, watch the correct clipping, both in its filled as in its drawn form=> the clicking is also a test for Polygon.contains() When clicking on any blue area of the Polygon, the polygon should change color.The white areas of the rectangle are NOT part of the polygon, so clicking them should leave the polygon as it is";
    }

    public Panel getPanel(VisualTester vt) {
        return this;
    }

    public void start(Panel p, boolean b) {
    }

    public void stop(Panel p) {
    }

    public static void main(String[] args) {
        new ClipPoly();
    }

    class ClipPolygonPanel
    extends Container
    implements MouseListener,
    MouseMotionListener {
        private Polygon refPoly;
        private Polygon screenPoly;
        private Point currentPoint;
        private boolean dragging = false;
        private boolean fill = false;
        private Dimension viewport = new Dimension();

        public ClipPolygonPanel() {
            this.currentPoint = new Point();
            int[] px = new int[]{6, 8, 8, 6, 4, 4, 6, 7, 5, 7, 5};
            int[] py = new int[]{1, 2, 4, 5, 4, 2, 1, 4, 2, 2, 4};
            this.refPoly = new Polygon(px, py, px.length);
            this.screenPoly = new Polygon();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void translate(int dx, int dy) {
            this.screenPoly.translate(this.viewport.width * dx / 12, this.viewport.height * dy / 6);
            this.repaint();
        }

        public void center() {
            this.setScreen(this.viewport);
            this.repaint();
        }

        public boolean isFillMode() {
            return this.fill;
        }

        public void swapFillMode() {
            this.fill = !this.fill;
            this.repaint();
        }

        public void setFillMode(boolean newmode) {
            if (this.fill != newmode) {
                this.fill = newmode;
                this.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (this.screenPoly.contains(e.getX(), e.getY())) {
                System.out.println("Point inside polygon, dragging mode = " + this.dragging);
                if (!this.dragging) {
                    this.dragging = true;
                    this.currentPoint.setLocation(e.getX(), e.getY());
                    this.repaint();
                }
            } else if (this.dragging) {
                System.out.println("Point outside polygon, dragging mode = " + this.dragging);
                this.dragging = false;
                this.repaint();
            } else {
                System.out.println("Point outside polygon, dragging mode = " + this.dragging);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragging) {
                this.screenPoly.translate(e.getX() - this.currentPoint.x, e.getY() - this.currentPoint.y);
                this.currentPoint.setLocation(e.getX(), e.getY());
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.dragging = false;
            this.repaint();
        }

        private void setScreen(Dimension newscreen) {
            System.out.println("Setting new screensize to <" + newscreen.width + ", " + newscreen.height + ">");
            this.screenPoly = new Polygon();
            for (int i = 0; i < this.refPoly.npoints; ++i) {
                this.screenPoly.addPoint(this.refPoly.xpoints[i] * newscreen.width / 12, this.refPoly.ypoints[i] * newscreen.height / 6);
            }
            this.viewport.setSize(newscreen);
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (!this.viewport.equals(this.getSize())) {
                this.setScreen(this.getSize());
            }
            g.setColor(Color.white);
            g.fillRect(1, 1, this.viewport.width - 2, this.viewport.height - 2);
            g.setColor(Color.black);
            g.drawLine(0, 0, this.viewport.width - 1, 0);
            g.drawLine(0, 0, 0, this.viewport.height - 1);
            g.drawLine(this.viewport.width - 1, 0, this.viewport.width - 1, this.viewport.height - 1);
            g.drawLine(0, this.viewport.height - 1, this.viewport.width - 1, this.viewport.height - 1);
            g.setColor(this.dragging ? Color.red : Color.blue);
            if (this.fill) {
                g.fillPolygon(this.screenPoly);
            } else {
                g.drawPolygon(this.screenPoly);
            }
        }
    }
}

