/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Font;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class BaseLine
extends VisualTestImpl
implements ActionListener,
MouseListener {
    private Word activeWord;
    private Button inc;
    private Button dec;

    public BaseLine() {
        Panel p_north = new Panel();
        Panel p_center = new Panel();
        this.inc = new Button("Increase");
        this.dec = new Button("Decrease");
        Word charlie = new Word("Charlie", 24);
        Word wonka = new Word("Wonka", 20);
        Word woempa = new Word("Woempa", 14);
        charlie.addMouseListener(this);
        wonka.addMouseListener(this);
        woempa.addMouseListener(this);
        Dimension dim = new Dimension(400, 234);
        this.setSize(dim);
        this.setLayout(new BorderLayout());
        p_north.setLayout(new BaseLineLayout());
        p_north.add(charlie);
        p_north.add(wonka);
        p_north.add(woempa);
        this.inc.addActionListener(this);
        this.inc.setActionCommand("inc");
        this.dec.addActionListener(this);
        this.dec.setActionCommand("dec");
        p_center.add(this.inc);
        p_center.add(this.dec);
        this.add((Component)p_north, "North");
        this.add((Component)p_center, "Center");
        this.activeWord = charlie;
        this.activeWord.setActive(true);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == "inc") {
            this.activeWord.handleButtonClick(1);
        } else {
            this.activeWord.handleButtonClick(-1);
        }
    }

    public void mouseClicked(MouseEvent me) {
        this.activeWord.setActive(false);
        this.activeWord = (Word)me.getSource();
        this.activeWord.setActive(true);
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public String getHelpText() {
        return "This is a test that lines out the baseline for fonts of different sizes. It auto-rescales so the font wouldn't clip at the top of the screen. You can change the font's size by focusing it and clicking \"Increase\" or \"Decrease\" afterwards.";
    }

    class BaseLineLayout
    implements LayoutManager2 {
        int maxAscent = -1;
        int maxDescent = 0;

        BaseLineLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension layoutSize(Container parent_cont, int size) {
            Insets insets = parent_cont.getInsets();
            int width = 0;
            Object object = parent_cont.getTreeLock();
            synchronized (object) {
                Dimension d = new Dimension(0, 0);
                this.maxAscent = 0;
                this.maxDescent = 0;
                for (int i = 0; i < parent_cont.getComponentCount(); ++i) {
                    Component c = parent_cont.getComponent(i);
                    switch (size) {
                        case 0: {
                            d = c.getMinimumSize();
                            break;
                        }
                        case 1: {
                            d = c.getPreferredSize();
                            break;
                        }
                        case 2: {
                            d = c.getMaximumSize();
                        }
                    }
                    int a = (int)(c.getAlignmentY() * (float)d.height);
                    this.maxAscent = Math.max(this.maxAscent, a);
                    this.maxDescent = Math.max(this.maxDescent, d.height - a);
                    width += d.width;
                }
                return new Dimension(insets.left + insets.right + width, insets.top + insets.bottom + this.maxAscent + this.maxDescent);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent_cont) {
            Insets insets = parent_cont.getInsets();
            if (this.maxAscent < 0) {
                this.layoutSize(parent_cont, 1);
            }
            Object object = parent_cont.getTreeLock();
            synchronized (object) {
                int l = insets.left;
                for (int i = 0; i < parent_cont.getComponentCount(); ++i) {
                    Component c = parent_cont.getComponent(i);
                    Dimension d = c.getPreferredSize();
                    c.setBounds(l, insets.top + (int)((float)this.maxAscent - (float)d.height * c.getAlignmentY()), d.width, d.height);
                    l += d.width;
                }
            }
        }

        public Dimension minimumLayoutSize(Container parent_cont) {
            return this.layoutSize(parent_cont, 0);
        }

        public Dimension preferredLayoutSize(Container parent_cont) {
            return this.layoutSize(parent_cont, 1);
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container parent_cont) {
            if (this.maxAscent < 0) {
                this.layoutSize(parent_cont, 1);
            }
            if (this.maxAscent > 0) {
                return (float)this.maxAscent / (float)(this.maxAscent + this.maxDescent);
            }
            return 0.5f;
        }

        public void invalidateLayout(Container target) {
            this.maxAscent = -1;
        }

        public Dimension maximumLayoutSize(Container parent_cont) {
            return this.layoutSize(parent_cont, 2);
        }
    }

    class Word
    extends Canvas {
        String word;
        Font font;
        FontMetrics f_metrics;
        int fontSize = 0;
        int index = 0;
        boolean clicked = false;
        float[] alignments = new float[]{-1.0f, 0.5f, 0.0f, 1.0f};

        Word(String word, int size) {
            this.word = word;
            this.fontSize = size;
            this.font = new Font("Serif", 0, size);
            this.f_metrics = this.getFontMetrics(this.font);
        }

        public float getAlignmentY() {
            if (this.alignments[this.index] == -1.0f) {
                return (float)this.f_metrics.getAscent() / (float)this.f_metrics.getHeight();
            }
            return this.alignments[this.index];
        }

        public Dimension getPreferredSize() {
            int space = this.f_metrics.charWidth(' ');
            return new Dimension(space + this.f_metrics.stringWidth(this.word), this.f_metrics.getHeight());
        }

        public void setActive(boolean clicked) {
            this.clicked = clicked;
            this.repaint();
        }

        public void paint(Graphics g) {
            if (this.clicked) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.lightGray);
            }
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.black);
            g.setFont(this.font);
            FontMetrics f_metrics = g.getFontMetrics();
            g.drawString(this.word, f_metrics.charWidth(' '), f_metrics.getAscent());
            g.drawLine(0, f_metrics.getAscent(), this.getSize().width, f_metrics.getAscent());
        }

        public void handleButtonClick(int dec_inc) {
            this.fontSize += dec_inc;
            this.font = new Font(this.font.getFamily(), this.font.getStyle(), this.fontSize);
            this.f_metrics = this.getFontMetrics(this.font);
            this.invalidate();
            this.getParent().getParent().validate();
            this.repaint();
        }
    }
}

