/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.Component.ComponentUpdate;
import com.acunia.wonka.test.awt.Component.PaintComponent;
import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ComponentUpdateDefault
extends VisualTestImpl
implements ActionListener {
    private PaintUpdateComponent paintUpdateComponent;
    private DefaultPaintComponent defaultPaintComponent;
    private DefaultUpdateComponent defaultUpdateComponent;
    private Button repaint;
    private List display;

    public ComponentUpdateDefault() {
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(48, 16, 16));
        this.setForeground(Color.white);
        Panel top = new Panel(new FlowLayout());
        this.repaint = new Button("repaint()...");
        this.repaint.addActionListener(this);
        top.add(this.repaint);
        this.add((Component)top, "North");
        this.display = new List(5, false);
        this.add((Component)this.display, "South");
        Panel components = new Panel(new GridLayout(1, 3));
        this.paintUpdateComponent = new PaintUpdateComponent();
        components.add(this.paintUpdateComponent);
        this.defaultPaintComponent = new DefaultPaintComponent();
        components.add(this.defaultPaintComponent);
        this.defaultUpdateComponent = new DefaultUpdateComponent();
        components.add(this.defaultUpdateComponent);
        this.add((Component)components, "Center");
    }

    public void actionPerformed(ActionEvent evt) {
        this.display.removeAll();
        this.display.add("Sending repaint()-command without bounds for whole screen");
        this.paintUpdateComponent.repaint();
        this.defaultPaintComponent.repaint();
        this.defaultUpdateComponent.repaint();
    }

    private void paintArea(Dimension size, String name, String action, int paints, int updates, Color background, Color foreground, Graphics g) {
        Rectangle bounds = g.getClipBounds();
        if (bounds == null) {
            bounds = new Rectangle(1, 1, size.width - 3, size.height - 3);
            this.display.add(name + " NULL bounds");
        } else {
            this.display.add(name + " bounds (" + bounds.x + ", " + bounds.y + ", " + bounds.width + ", " + bounds.height + ")");
            bounds.grow(-1, -1);
        }
        g.setColor(background);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setColor(foreground);
        g.drawString(name, 10, 20);
        g.drawString(action, 10, 35);
        g.drawString("paints = " + paints, 10, 50);
        g.drawString("updates " + updates, 10, 65);
    }

    public String getHelpText() {
        return "A test on the default implementation of update() and paint() commands\n The main part of this test are the three central Components. All components have their paint() and an update() commands implemented differently: \n => By default, both update() and paint() paint the current clipping bound in a given background color and also display  the number of paints and updates made. With each paint() or update() the background color changes along the colors of the rainbow (red, orange, yellow....). Paint commands display white text on dark colors, update-commands black text on light colors. Like this it is possible to see wether the clipping area is being paint()-ed or update()-ed \n(If the clipping area is <NULL>, it is being replaced by the complete screen)\n\n => The left 'paint & update' Component has its paint() and update() functions fully implemented as described above\n => The center 'default paint' Component has its update() functin fully implemented, but its paint() function maps to the default Component.paint().\n => Likewise the right 'default update' Component has its paint() function implemented but maps its update() function to the default Component.update()";
    }

    public void main(String[] args) {
        Frame main = new Frame("Component paint test");
        main.setSize(400, 234);
        main.add(new ComponentUpdate());
        main.show();
    }

    class DefaultPaintComponent
    extends Panel {
        protected Rectangle frameRect = new Rectangle();
        protected Rectangle bounds;
        protected int updateCount = 0;
        protected int paintCount = 0;
        private String action = "(updating)";

        public void paint(Graphics g) {
            ComponentUpdateDefault.this.display.add("default paint: Received call to (super.)paint()");
            ++this.paintCount;
            this.action = "(painting)";
            super.paint(g);
            ComponentUpdateDefault.this.display.add("default paint: paint() executed, total paints = " + this.paintCount);
            this.action = "(updating)";
        }

        public void update(Graphics g) {
            ComponentUpdateDefault.this.display.add("default paint: Received call to update()");
            ++this.updateCount;
            ComponentUpdateDefault.this.paintArea(this.getSize(), "default Paint", this.action, this.paintCount, this.updateCount, PaintComponent.LIGHTCOLORS[(this.updateCount - 1) % PaintComponent.COLORCOUNT], Color.black, g);
            ComponentUpdateDefault.this.display.add("default paint: update() executed, total updates = " + this.updateCount);
        }
    }

    class DefaultUpdateComponent
    extends Panel {
        protected Rectangle frameRect = new Rectangle();
        protected Rectangle bounds;
        protected int updateCount = 0;
        protected int paintCount = 0;
        private String action = "(Painting)";

        public void paint(Graphics g) {
            ComponentUpdateDefault.this.display.add("default update: Received call to paint()");
            ++this.paintCount;
            ComponentUpdateDefault.this.paintArea(this.getSize(), "default update", this.action, this.paintCount, this.updateCount, PaintComponent.DARKCOLORS[(this.paintCount - 1) % PaintComponent.COLORCOUNT], Color.white, g);
            ComponentUpdateDefault.this.display.add("default update: paint() executed, total paints = " + this.paintCount);
        }

        public void update(Graphics g) {
            ComponentUpdateDefault.this.display.add("default update: Received call to (super.)update()");
            ++this.updateCount;
            this.action = "(Updating)";
            super.update(g);
            ComponentUpdateDefault.this.display.add("default update: update() executed, total updates = " + this.updateCount);
            this.action = "(Painting)";
        }
    }

    class PaintUpdateComponent
    extends Panel {
        protected Rectangle frameRect = new Rectangle();
        protected Rectangle bounds;
        protected int updateCount = 0;
        protected int paintCount = 0;

        public void paint(Graphics g) {
            ComponentUpdateDefault.this.display.add("Paint & update: Received call to paint()");
            ++this.paintCount;
            ComponentUpdateDefault.this.paintArea(this.getSize(), "Paint & update", "(painting)", this.paintCount, this.updateCount, PaintComponent.DARKCOLORS[(this.paintCount - 1) % PaintComponent.COLORCOUNT], Color.white, g);
            ComponentUpdateDefault.this.display.add("Paint & update: paint() executed, total paints = " + this.paintCount);
        }

        public void update(Graphics g) {
            ComponentUpdateDefault.this.display.add("Paint & update: Received call to update()");
            ++this.updateCount;
            ComponentUpdateDefault.this.paintArea(this.getSize(), "Paint & update", "(updating)", this.paintCount, this.updateCount, PaintComponent.LIGHTCOLORS[(this.updateCount - 1) % PaintComponent.COLORCOUNT], Color.black, g);
            ComponentUpdateDefault.this.display.add("Paint & update: update() executed, total updates = " + this.updateCount);
        }
    }
}

