/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Component;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ComponentRepaint
extends VisualTestImpl
implements ItemListener {
    private InnerMouseComponent mouseComponent;
    private InnerMouseContainer mouseContainer;
    private Button update;
    private Button noupdate;
    private Checkbox showOnButton;
    private static final Color[] colors = new Color[]{new Color(128, 0, 128), new Color(0, 0, 128), new Color(96, 96, 255), Color.green, Color.yellow, Color.orange, Color.red};
    private static final Color COPPER = new Color(200, 200, 120);
    private static final Color DARKSAND = new Color(90, 90, 60);

    public ComponentRepaint() {
        this.setLayout(new BorderLayout());
        Panel p1 = new Panel(new GridLayout(3, 1));
        this.mouseComponent = new InnerMouseComponent("<Event listener, Component based>");
        p1.add(this.mouseComponent);
        this.update = new Button("Clicking this button also redraws the Component field above");
        p1.add((Component)this.update, "Center");
        this.mouseContainer = new InnerMouseContainer("<Event listener, Container based>");
        p1.add(this.mouseContainer);
        this.add((Component)p1, "Center");
        Panel p2 = new Panel(new GridLayout(2, 1));
        this.showOnButton = new Checkbox("Show messages on buttons", false);
        this.showOnButton.addItemListener(this);
        p2.add(this.showOnButton);
        this.noupdate = new Button("Clicking on this button doesn't help");
        p2.add(this.noupdate);
        this.add((Component)p2, "South");
    }

    public void itemStateChanged(ItemEvent evt) {
        if (this.showOnButton.getState()) {
            this.update.setLabel("Displaying the messages here triggers a repaint");
            this.noupdate.setLabel("messages will be displayed here just as well");
        } else {
            this.update.setLabel("Clicking this button also redraws the Component field above");
            this.noupdate.setLabel("Clicking on this button doesn't help");
        }
    }

    private void displayEvent(String eventstring) {
        this.mouseComponent.setText(eventstring);
        this.mouseContainer.setText(eventstring);
        if (this.showOnButton.getState()) {
            this.update.setLabel(eventstring);
            this.noupdate.setLabel(eventstring);
        }
        System.out.println(eventstring);
    }

    public String getHelpText() {
        return "A test on painting and repainting component members of a frame. The test shows\n1) a mouse event field based on a Component,\n2) a <redraw> button,\n3)a mouse event field based on a Container, all this three components added to the same GridLayout Container4) a <mirror> checkbox where you can ask to mirror the mouse events on the <redraw> button(2)\n 5) another button but not in the same Container as the mouse fields\n\n What the test should do...\n=> the component based and Container based mouse fields both have a MouseListener and FocusListener interface. Whenever one of this listeners throws an event an event description message is displayed on both Containers.\n=> If the mirror checkbox is active, the text is also displayed on the middle and lower button\n\n What the test actually does \n(list of bugs this test was build to demonstrate / Wonka7.1, 7-10-2001)...\n=> All mouse events(from both mouse fields) are correctly displayed on the upper Frame-based field. The lower component-based one does throw the events and appearantly does react to them, but is not redrawn\n=> When pressing the middle <redraw> button, the component-based field is suddenly redrawn in the state it should be in. this is because the <redraw> button and the component field are assigned to the same Gridlayout Container. Pressing the lower button(that is not in the Container) doesn't do anything\n=> When the checkbox is pressed and all messages are mirrored to the <message>button, the button is redrawn on every event and so is the component field. as a consequence this test suddenly starts to work\n\n(The mouse event fields are variations on the MouseEvent classes from the event-tests. Their expected behavior is explainrd below)\n=> the test shows two squares: a <from> square resting on its side and a <to> square standing on its corner\n. The squares and the field boundaries are drawn in one of the seven colors of the rainbow. At startup: from and to squares are drawn at the same position in the upper-left corner\n=> Mouse pressed: the to-square is drawn at mouse-position and a line is drawn between from and to-square\n=> Mouse released: the from-square is set to the same position as the to-square\n=> Mouse clicked: the drawing color shifts to the next color of the rainbow\n=> mouse entered: the from-square is moved to the point where the mouse has entered (it can't be drawn however, since half of it is outside the screen)\n=> mouse exited: the to-square is moved to the point where the mouse has exited(can't be drawn however) and a line is drawn between the two points\n";
    }

    class InnerMouseContainer
    extends Container
    implements canSetText,
    MouseListener,
    FocusListener {
        private String message;
        private String name;
        private Point toPoint;
        private Point fromPoint;
        private boolean connected;
        private int currentColor;
        private Rectangle bounds;
        private Rectangle inside;

        public InnerMouseContainer(String panelname) {
            this.name = panelname;
            this.message = "No events to display yet";
            this.toPoint = new Point(8, 8);
            this.fromPoint = new Point(8, 8);
            this.connected = false;
            this.currentColor = colors.length - 1;
            this.bounds = new Rectangle(0, 0, 0, 0);
            this.inside = new Rectangle(0, 0, 0, 0);
            this.addMouseListener(this);
            this.addFocusListener(this);
        }

        public Dimension getMinimumSize() {
            return new Dimension(70, 50);
        }

        public Dimension getPreferredSize() {
            return new Dimension(70, 50);
        }

        public void mouseClicked(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function " + this.name + ".mouseClicked()");
            this.currentColor = this.currentColor > 0 ? --this.currentColor : colors.length - 1;
            this.repaint();
        }

        public void mouseEntered(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mouseEntered()");
            this.fromPoint.setLocation(event.getX(), event.getY());
            this.connected = false;
            this.repaint();
        }

        public void mouseExited(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mouseExited()");
            this.toPoint.setLocation(event.getX(), event.getY());
            this.connected = true;
            this.repaint();
        }

        public void mousePressed(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mousePressed()");
            this.toPoint.setLocation(event.getX(), event.getY());
            this.connected = true;
            this.repaint();
        }

        public void mouseReleased(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mouseReleased()");
            this.fromPoint.setLocation(this.toPoint);
            this.connected = false;
            this.repaint();
        }

        public void focusGained(FocusEvent event) {
            ComponentRepaint.this.displayEvent("Called function " + this.name + ".focusGained(FocusEvent.isTemporary()=" + event.isTemporary() + ")");
        }

        public void focusLost(FocusEvent event) {
            ComponentRepaint.this.displayEvent("Called function " + this.name + ".focusLost(FocusEvent.isTemporary()=" + event.isTemporary() + ")");
        }

        public void setText(String text) {
            this.message = text;
            this.repaint();
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (this.bounds.width == 0) {
                this.bounds.setBounds(1, 1, this.getSize().width - 2, this.getSize().height - 2);
                this.inside.setBounds(7, 7, this.getSize().width - 14, this.getSize().height - 14);
            }
            g.setColor(DARKSAND);
            g.fillRect(1, 1, this.bounds.width, this.bounds.height);
            g.setColor(COPPER);
            g.drawString(this.name, 10, 15);
            g.drawString(this.message, 10, 30);
            g.setColor(colors[this.currentColor]);
            g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
            if (this.inside.contains(this.fromPoint)) {
                g.drawLine(this.fromPoint.x - 7, this.fromPoint.y, this.fromPoint.x + 7, this.fromPoint.y);
                g.drawLine(this.fromPoint.x, this.fromPoint.y - 7, this.fromPoint.x, this.fromPoint.y + 7);
                g.drawLine(this.fromPoint.x - 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y + 7);
                g.drawLine(this.fromPoint.x - 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y - 7);
                g.drawLine(this.fromPoint.x + 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y + 7);
                g.drawLine(this.fromPoint.x + 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y - 7);
            }
            if (this.inside.contains(this.toPoint)) {
                g.drawLine(this.toPoint.x - 5, this.toPoint.y - 5, this.toPoint.x + 5, this.toPoint.y + 5);
                g.drawLine(this.toPoint.x - 5, this.toPoint.y + 5, this.toPoint.x + 5, this.toPoint.y - 5);
                g.drawLine(this.toPoint.x - 5, this.toPoint.y - 5, this.toPoint.x + 5, this.toPoint.y - 5);
                g.drawLine(this.toPoint.x - 5, this.toPoint.y - 5, this.toPoint.x - 5, this.toPoint.y + 5);
                g.drawLine(this.toPoint.x + 5, this.toPoint.y + 5, this.toPoint.x + 5, this.toPoint.y - 5);
                g.drawLine(this.toPoint.x + 5, this.toPoint.y + 5, this.toPoint.x - 5, this.toPoint.y + 5);
            }
            if (this.connected) {
                g.drawLine(this.toPoint.x, this.toPoint.y, this.fromPoint.x, this.fromPoint.y);
            }
        }

        public String toString() {
            return "InnerMouseContainer " + this.name;
        }
    }

    class InnerMouseComponent
    extends Component
    implements canSetText,
    MouseListener,
    FocusListener {
        private String message;
        private String name;
        private Point toPoint;
        private Point fromPoint;
        private boolean connected;
        private int currentColor;
        private Rectangle bounds;
        private Rectangle inside;

        public InnerMouseComponent(String panelname) {
            this.name = panelname;
            this.message = "No events to display yet";
            this.toPoint = new Point(8, 8);
            this.fromPoint = new Point(8, 8);
            this.connected = false;
            this.currentColor = colors.length - 1;
            this.bounds = new Rectangle(0, 0, 0, 0);
            this.inside = new Rectangle(0, 0, 0, 0);
            this.addMouseListener(this);
            this.addFocusListener(this);
        }

        public Dimension getMinimumSize() {
            return new Dimension(70, 50);
        }

        public Dimension getPreferredSize() {
            return new Dimension(70, 50);
        }

        public void mouseClicked(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function " + this.name + ".mouseClicked()");
            this.currentColor = this.currentColor > 0 ? --this.currentColor : colors.length - 1;
            this.repaint();
        }

        public void mouseEntered(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mouseEntered()");
            this.fromPoint.setLocation(event.getX(), event.getY());
            this.connected = false;
            this.repaint();
        }

        public void mouseExited(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mouseExited()");
            this.toPoint.setLocation(event.getX(), event.getY());
            this.connected = true;
            this.repaint();
        }

        public void mousePressed(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mousePressed()");
            this.toPoint.setLocation(event.getX(), event.getY());
            this.connected = true;
            this.repaint();
        }

        public void mouseReleased(MouseEvent event) {
            ComponentRepaint.this.displayEvent("Called function  " + this.name + ".mouseReleased()");
            this.fromPoint.setLocation(this.toPoint);
            this.connected = false;
            this.repaint();
        }

        public void focusGained(FocusEvent event) {
            ComponentRepaint.this.displayEvent("Called function " + this.name + ".focusGained(FocusEvent.isTemporary()=" + event.isTemporary() + ")");
        }

        public void focusLost(FocusEvent event) {
            ComponentRepaint.this.displayEvent("Called function " + this.name + ".focusLost(FocusEvent.isTemporary()=" + event.isTemporary() + ")");
        }

        public void setText(String text) {
            this.message = text;
            this.repaint();
        }

        public void paint(Graphics g) {
            this.update(g);
        }

        public void update(Graphics g) {
            if (this.bounds.width == 0) {
                this.bounds.setBounds(1, 1, this.getSize().width - 2, this.getSize().height - 2);
                this.inside.setBounds(7, 7, this.getSize().width - 14, this.getSize().height - 14);
            }
            g.setColor(COPPER);
            g.fillRect(1, 1, this.bounds.width, this.bounds.height);
            g.setColor(DARKSAND);
            g.drawString(this.name, 10, 15);
            g.drawString(this.message, 10, 30);
            g.setColor(colors[this.currentColor]);
            g.drawRect(this.inside.x, this.inside.y, this.inside.width, this.inside.height);
            if (this.inside.contains(this.fromPoint)) {
                g.drawLine(this.fromPoint.x - 7, this.fromPoint.y, this.fromPoint.x + 7, this.fromPoint.y);
                g.drawLine(this.fromPoint.x, this.fromPoint.y - 7, this.fromPoint.x, this.fromPoint.y + 7);
                g.drawLine(this.fromPoint.x - 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y + 7);
                g.drawLine(this.fromPoint.x - 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y - 7);
                g.drawLine(this.fromPoint.x + 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y + 7);
                g.drawLine(this.fromPoint.x + 7, this.fromPoint.y, this.fromPoint.x, this.fromPoint.y - 7);
            }
            if (this.inside.contains(this.toPoint)) {
                g.drawLine(this.toPoint.x - 5, this.toPoint.y - 5, this.toPoint.x + 5, this.toPoint.y + 5);
                g.drawLine(this.toPoint.x - 5, this.toPoint.y + 5, this.toPoint.x + 5, this.toPoint.y - 5);
                g.drawLine(this.toPoint.x - 5, this.toPoint.y - 5, this.toPoint.x + 5, this.toPoint.y - 5);
                g.drawLine(this.toPoint.x - 5, this.toPoint.y - 5, this.toPoint.x - 5, this.toPoint.y + 5);
                g.drawLine(this.toPoint.x + 5, this.toPoint.y + 5, this.toPoint.x + 5, this.toPoint.y - 5);
                g.drawLine(this.toPoint.x + 5, this.toPoint.y + 5, this.toPoint.x - 5, this.toPoint.y + 5);
            }
            if (this.connected) {
                g.drawLine(this.toPoint.x, this.toPoint.y, this.fromPoint.x, this.fromPoint.y);
            }
        }

        public String toString() {
            return "InnerMouseComponent " + this.name;
        }
    }

    static interface canSetText {
        public void setText(String var1);
    }
}

