/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.test.awt.Color;

import com.acunia.wonka.test.awt.VisualTestImpl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;

public class HSBandRGB
extends VisualTestImpl {
    private Image original;
    private Scrollbar slideH;
    private Scrollbar slideS;
    private Scrollbar slideB;
    private DstImagePanel dest = new DstImagePanel();

    public HSBandRGB() {
        String path = System.getProperty("property.path", "/test");
        this.original = Toolkit.getDefaultToolkit().getImage(path + "/lena1.png");
        this.setLayout(new BorderLayout());
        Panel bottom = new Panel(new BorderLayout());
        Panel sliders = new Panel(new GridLayout(3, 1));
        this.slideH = new Scrollbar(0, 200, 5, 100, 300);
        this.slideS = new Scrollbar(0, 200, 5, 0, 200);
        this.slideB = new Scrollbar(0, 200, 5, 0, 200);
        sliders.add(this.slideH);
        sliders.add(this.slideS);
        sliders.add(this.slideB);
        Button button = new Button("Repaint");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HSBandRGB.this.dest.repaint();
            }
        });
        bottom.add((Component)sliders, "Center");
        bottom.add((Component)button, "East");
        this.add((Component)this.dest, "Center");
        this.add((Component)bottom, "South");
        this.repaint();
    }

    public String getHelpText() {
        return "HSB & RGB";
    }

    public class HSBFilter
    extends RGBImageFilter {
        private boolean canFilterIndexColorModel = false;
        private ColorModel model = ColorModel.getRGBdefault();
        private int h;
        private int s;
        private int b;

        public HSBFilter(int h, int s, int b) {
            this.h = h;
            this.s = s;
            this.b = b;
        }

        public int filterRGB(int x, int y, int rgb) {
            float[] HSB = new float[3];
            Color.RGBtoHSB(this.model.getRed(rgb), this.model.getGreen(rgb), this.model.getBlue(rgb), HSB);
            HSB[0] = HSB[0] + (float)(this.h - 200) / 200.0f;
            if (HSB[0] < 0.0f) {
                HSB[0] = HSB[0] + 1.0f;
            }
            if (HSB[0] > 1.0f) {
                HSB[0] = HSB[0] - 1.0f;
            }
            HSB[1] = HSB[1] * ((float)this.s / 200.0f);
            HSB[2] = HSB[2] * ((float)this.b / 200.0f);
            return Color.HSBtoRGB(HSB[0], HSB[1], HSB[2]);
        }
    }

    public class DstImagePanel
    extends Panel {
        public DstImagePanel() {
            this.setBackground(Color.black);
        }

        public void update(Graphics g) {
            g.setColor(Color.black);
            g.fillRect(0, 0, 500, 500);
            ImageProducer ip = HSBandRGB.this.original.getSource();
            ip = new FilteredImageSource(ip, new HSBFilter(HSBandRGB.this.slideH.getValue(), HSBandRGB.this.slideS.getValue(), HSBandRGB.this.slideB.getValue()));
            g.drawImage(this.createImage(ip), 10, 10, null);
        }

        public void paint(Graphics g) {
            this.update(g);
        }
    }
}

