/*
 * Decompiled with CFR 0.152.
 */
package wonka.vm;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import wonka.vm.Finalizer;
import wonka.vm.GarbageCollector;
import wonka.vm.Heartbeat;
import wonka.vm.Wonka;

final class Init
implements Runnable {
    private static boolean debug = false;
    private static Init theInit;
    private String arch = System.getProperty("os.arch").toLowerCase(Locale.getDefault());
    private String start_command;
    private Method invoke_method;
    private Object[] invoke_args = new Object[1];
    private boolean launched;
    static /* synthetic */ Class class$java$net$URLClassLoader;

    private static void debug(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    private Init(String[] args) {
        String[] start_class_args;
        String start_class_name;
        if (theInit != null) {
            System.err.println("Init: Attempt to create a second instance foiled.");
            return;
        }
        theInit = this;
        String debugProperty = Wonka.getProperty("wonka.java.debug", "false");
        if (debugProperty.equals("true")) {
            debug = true;
        }
        this.start_command = this.getStartCommProp(this.arch);
        Class start_class = null;
        if (args != null && args.length > 0 && args[0] != null && args[0].equals("-jar")) {
            if (debug) {
                System.out.println("Init: '-jar' is used");
            }
            if (args.length < 2) {
                System.out.println("Init: -jar option is used but no JarFile is mentioned");
                System.exit(1);
            }
            start_class_name = null;
            try {
                File file = new File(args[1]);
                JarFile jf = new JarFile(file);
                Manifest man = jf.getManifest();
                if (man == null) {
                    System.out.println("Init: JarFile " + args[1] + " has no Manifest");
                    System.exit(1);
                }
                if ((start_class_name = man.getMainAttributes().getValue("Main-Class")) == null) {
                    System.out.println("Init: no Main-Class attribute in Manifest of JarFile " + args[1]);
                    System.exit(1);
                }
                URLClassLoader cl = (URLClassLoader)ClassLoader.getSystemClassLoader();
                URL url = new URL("jar:" + file.toURL() + "!/");
                Method m = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = Init.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod("addURL", new Class[]{url.getClass()});
                m.setAccessible(true);
                m.invoke(cl, new Object[]{url});
            }
            catch (Exception e) {
                System.out.println("Init: failed to load jar " + args[1] + " due to " + e);
                System.exit(1);
            }
            start_class_args = new String[args.length - 2];
            System.arraycopy(args, 2, start_class_args, 0, start_class_args.length);
        } else if (args != null && args.length > 0 && args[0] != null) {
            start_class_name = args[0];
            start_class_args = new String[args.length - 1];
            System.arraycopy(args, 1, start_class_args, 0, start_class_args.length);
        } else {
            int first_space = this.start_command.indexOf(32);
            if (first_space >= 0) {
                start_class_name = this.start_command.substring(0, first_space);
                start_class_args = this.getSysPropArgs(this.start_command.substring(first_space + 1));
            } else {
                start_class_name = this.start_command;
                start_class_args = new String[]{};
            }
        }
        this.invoke_args[0] = start_class_args;
        if (start_class_name != null) {
            try {
                start_class = Class.forName(start_class_name, false, ClassLoader.getSystemClassLoader());
                Init.debug("Init: start_class = " + start_class);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Init: no such class as " + start_class_name + "!");
            }
        }
        if (start_class == null) {
            System.err.println("Init: no start class found.  Game over.");
            return;
        }
        try {
            this.invoke_method = start_class.getMethod("main", new Class[]{Class.forName("[Ljava.lang.String;")});
            Init.debug("Init: will invoke " + this.invoke_method + " of " + start_class);
            this.invoke_method.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Init.debug("Init: starting Garbage Collector");
        GarbageCollector gc = GarbageCollector.getInstance();
        Init.debug("Init: starting Finalizer");
        Finalizer f = Finalizer.getInstance();
        Init.debug("Init: starting Heartbeat");
        Heartbeat h = Heartbeat.getInstance();
        TimeZone.setDefault(null);
        try {
            if (this.invoke_method == null) {
                System.err.println("Init: no start method found.");
            } else {
                Init.debug("Init: starting " + this.invoke_method + " ...");
                this.invoke_method.invoke(null, this.invoke_args);
                this.launched = true;
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Init: error invoking " + this.invoke_method + "! got " + e);
        }
        catch (InvocationTargetException e) {
            Thread this_thread = Thread.currentThread();
            System.err.println("Init: " + this.invoke_method + " caught " + e);
            this_thread.getThreadGroup().uncaughtException(this_thread, e.getTargetException());
        }
        finally {
            if (!this.launched) {
                System.exit(1);
            }
        }
    }

    private String[] getSysPropArgs(String command_line) {
        Vector temp_args = new Vector();
        while (command_line != "") {
            String this_arg;
            int first_space = command_line.indexOf(32);
            if (first_space >= 0) {
                this_arg = command_line.substring(0, first_space);
                command_line = command_line.substring(first_space).trim();
            } else {
                this_arg = command_line;
                command_line = "";
            }
            this.argumentOrSysProp(this_arg, temp_args);
        }
        return this.marshallArgs(temp_args);
    }

    void argumentOrSysProp(String this_arg, Vector temp_args) {
        if (this_arg.startsWith("-D")) {
            Properties sysprops = System.getProperties();
            int equals_at = this_arg.indexOf(61);
            if (equals_at < 0) {
                String key = this_arg.substring(2);
                Init.debug("Init: Deleting system property '" + key + "'");
                sysprops.remove(key);
            } else if (equals_at == 0) {
                Init.debug("Init: Ignoring nameless property in " + this_arg);
            } else if (equals_at == this_arg.length() - 1) {
                String key = this_arg.substring(2, equals_at);
                Init.debug("Init: Deleting system property '" + key + "'");
                sysprops.remove(key);
            } else {
                String key = this_arg.substring(2, equals_at);
                String value = this_arg.substring(equals_at + 1);
                Init.debug("Init: Setting system property '" + key + "' to '" + value + "'");
                sysprops.put(key, value);
            }
        } else {
            Init.debug("Init: passing argument" + this_arg);
            temp_args.addElement(this_arg);
        }
    }

    String[] marshallArgs(Vector temp_args) {
        String[] start_class_args = new String[temp_args.size()];
        for (int i = 0; i < temp_args.size(); ++i) {
            start_class_args[i] = (String)temp_args.elementAt(i);
        }
        return start_class_args;
    }

    String getStartCommProp(String arch) {
        String arch1 = "linux";
        String arch2 = null;
        Init.debug("Init: looking up System property com.acunia.wonka.Init." + arch1 + ".start");
        String command = System.getProperty("com.acunia.wonka.Init." + arch1 + ".start");
        if (command == null && arch2 != null) {
            Init.debug("Init: looking up System property com.acunia.wonka.Init." + arch2 + ".start");
            command = System.getProperty("com.acunia.wonka.Init." + arch2 + ".start");
        }
        if (command == null) {
            System.err.println("Init: no start command found.  Game over.");
            return null;
        }
        return command.trim();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

