/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamCreator;

class SocketStreamCreator
extends StreamCreator {
    private Socket socket;

    public void close() {
        this.closed = true;
        this.socket = null;
    }

    protected InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    SocketStreamCreator(Socket socket) {
        this.socket = socket;
    }

    SocketStreamCreator(String name, boolean timesout) throws ConnectionNotFoundException {
        int timeout;
        int index = name.indexOf(59);
        int n = timeout = timesout ? 60000 : 0;
        if (index != -1) {
            int idx = name.indexOf(";timeout=", index);
            if (idx != -1) {
                try {
                    int end = name.indexOf(59, idx += 9);
                    timeout = Integer.parseInt(name.substring(idx, end == -1 ? name.length() : end));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("bad option");
                }
            }
            name = name.substring(0, index);
        }
        index = name.lastIndexOf(58);
        try {
            int port = Integer.parseInt(name.substring(index + 1));
            name = name.substring(0, index);
            if (name.startsWith("//")) {
                name = name.substring(2);
            }
            this.socket = new Socket(InetAddress.getByName(name), port);
            this.socket.setSoTimeout(timeout);
        }
        catch (Exception e) {
            throw new ConnectionNotFoundException("unable to create socket");
        }
    }
}

