/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.microedition.io.BasicStreamConnection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.SocketStreamCreator;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

class ServerSocketConnection
implements StreamConnectionNotifier {
    private ServerSocket server;
    private int timeout;

    public void close() throws IOException {
        this.server = null;
    }

    public StreamConnection acceptAndOpen() throws IOException {
        if (this.server == null) {
            throw new IOException("serversocket connection is closed");
        }
        Socket s = this.server.accept();
        s.setSoTimeout(this.timeout);
        return new BasicStreamConnection(new SocketStreamCreator(s));
    }

    ServerSocketConnection(String name, boolean timesout) throws ConnectionNotFoundException {
        int index = name.indexOf(59);
        int n = this.timeout = timesout ? 60000 : 0;
        if (index != -1) {
            int timeindex = name.indexOf(";timeout=", index);
            if (timeindex != -1) {
                try {
                    int end = name.indexOf(59, timeindex += 9);
                    this.timeout = Integer.parseInt(name.substring(timeindex, end == -1 ? name.length() : end));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("bad option");
                }
            }
            name = name.substring(0, index);
        }
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        index = name.lastIndexOf(58);
        try {
            if (index == -1) {
                this.server = new ServerSocket(Integer.parseInt(name));
            } else {
                int port = Integer.parseInt(name.substring(index + 1));
                this.server = new ServerSocket(port, 50, InetAddress.getByName(name.substring(index)));
            }
            this.server.setSoTimeout(this.timeout);
        }
        catch (Exception e) {
            throw new ConnectionNotFoundException("unable to create socket due to " + e);
        }
    }
}

