/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamCreator;

class FileStreamCreator
extends StreamCreator {
    private InputStream in;
    private OutputStream out;
    private String file;
    private boolean append;

    public void close() {
        this.closed = true;
        this.out = null;
        this.in = null;
    }

    protected InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new FileInputStream(this.file);
        }
        return this.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new FileOutputStream(this.file, this.append);
        }
        return this.out;
    }

    FileStreamCreator(String name, boolean read_only) throws ConnectionNotFoundException {
        int index = name.indexOf(59);
        if (index != -1) {
            boolean bl = false;
            if (name.indexOf("append=true", index) != -1) {
                bl = true;
            }
            this.append = bl;
            this.file = name.substring(0, index);
        } else {
            this.file = name;
        }
        File f = new File(this.file);
        if (!f.exists()) {
            if (read_only) {
                throw new ConnectionNotFoundException(this.file + " does not exist");
            }
            try {
                f.createNewFile();
            }
            catch (IOException ioe) {
                throw new ConnectionNotFoundException("cannot create " + this.file);
            }
        } else if (!f.isFile()) {
            throw new ConnectionNotFoundException(this.file + " is not a file");
        }
    }
}

