/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.microedition.io.BasicDatagram;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;

class BasicDatagramConnection
implements DatagramConnection {
    private DatagramSocket dsocket;
    private InetAddress serverAddress;
    private int toPort;

    public void close() throws IOException {
        this.dsocket = null;
    }

    public int getMaximumLength() throws IOException {
        if (this.dsocket == null) {
            throw new IOException("socket is closed");
        }
        return this.dsocket.getReceiveBufferSize();
    }

    public int getNominalLength() throws IOException {
        return this.getMaximumLength();
    }

    public Datagram newDatagram(int size) throws IOException {
        return this.newDatagram(new byte[size], size);
    }

    public Datagram newDatagram(int size, String address) throws IOException {
        return this.newDatagram(new byte[size], size, address);
    }

    public Datagram newDatagram(byte[] bytes, int size) throws IOException {
        if (this.dsocket == null) {
            throw new IOException("socket is closed");
        }
        BasicDatagram bd = new BasicDatagram(bytes, size);
        if (this.serverAddress != null) {
            bd.dgram.setAddress(this.serverAddress);
            bd.dgram.setPort(this.toPort);
        }
        return bd;
    }

    public Datagram newDatagram(byte[] bytes, int size, String address) throws IOException {
        if (this.dsocket == null) {
            throw new IOException("socket is closed");
        }
        return new BasicDatagram(bytes, size, address);
    }

    public void receive(Datagram d) throws IOException {
        if (this.dsocket == null) {
            throw new IOException("socket is closed");
        }
        try {
            BasicDatagram bd = (BasicDatagram)d;
            DatagramPacket dp = bd.dgram;
            this.dsocket.receive(dp);
            bd.maxSize = dp.getLength() + dp.getOffset();
            bd.offset = bd.pointer = dp.getOffset();
        }
        catch (ClassCastException cce) {
            throw new IOException("invalid datagram class");
        }
    }

    public void send(Datagram d) throws IOException {
        if (this.dsocket == null) {
            throw new IOException("socket is closed");
        }
        try {
            BasicDatagram bd = (BasicDatagram)d;
            bd.dgram.setLength(bd.pointer - bd.offset);
            this.dsocket.send(bd.dgram);
        }
        catch (ClassCastException cce) {
            throw new IOException("invalid datagram class");
        }
    }

    BasicDatagramConnection(String name, boolean timesout) throws ConnectionNotFoundException {
        int timeout;
        int index = name.indexOf(59);
        int n = timeout = timesout ? 60000 : 0;
        if (index != -1) {
            int idx = name.indexOf(";timeout=", index);
            if (idx != -1) {
                try {
                    int end = name.indexOf(59, idx += 9);
                    timeout = Integer.parseInt(name.substring(idx, end == -1 ? name.length() : end));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("bad option");
                }
            }
            name = name.substring(0, index);
        }
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        index = name.lastIndexOf(58);
        try {
            if (index == -1) {
                this.dsocket = new DatagramSocket(Integer.parseInt(name));
            } else {
                int port = Integer.parseInt(name.substring(index + 1));
                if ((name = name.substring(0, index)).length() > 0) {
                    this.serverAddress = InetAddress.getByName(name);
                    this.dsocket = new DatagramSocket();
                    this.toPort = port;
                } else {
                    this.dsocket = new DatagramSocket(port);
                }
            }
            this.dsocket.setSoTimeout(timeout);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConnectionNotFoundException("unable to create socket due to " + e);
        }
    }
}

