/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import com.acunia.device.uart.UARTDriver;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private static Hashtable idtable = new Hashtable();
    private String name;
    private int type;
    private CommDriver driver;
    private CommPort commport;
    private String owner;
    private Vector ownershiplisteners;
    private int ownershipcallback;

    public static Enumeration getPortIdentifiers() {
        return idtable.elements();
    }

    public static CommPortIdentifier getPortIdentifier(String portName) throws NoSuchPortException {
        CommPortIdentifier result = (CommPortIdentifier)idtable.get(portName);
        if (result == null) {
            throw new NoSuchPortException("No such CommPort as " + portName);
        }
        return result;
    }

    public static CommPortIdentifier getPortIdentifier(CommPort port) throws NoSuchPortException {
        CommPortIdentifier result = port.commPortIdentifier;
        if (result == null) {
            throw new NoSuchPortException();
        }
        return result;
    }

    public static void addPortName(String portName, int portType, CommDriver driver) {
        try {
            CommPortIdentifier newportid = new CommPortIdentifier(portName, portType, driver);
            idtable.put(portName, newportid);
        }
        catch (NoSuchPortException noSuchPortException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPortType() {
        return this.type;
    }

    public String getCurrentOwner() {
        return this.owner;
    }

    public synchronized boolean isCurrentlyOwned() {
        boolean bl = false;
        if (this.owner != null) {
            bl = true;
        }
        return bl;
    }

    public synchronized CommPort open(String appname, int timeout) throws PortInUseException {
        CommPortOwnershipListener lstnr;
        if (appname == null) {
            throw new NullPointerException("appname is null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("nonpositive timeout");
        }
        Vector snapshot = (Vector)this.ownershiplisteners.clone();
        Enumeration enumeration = snapshot.elements();
        if (this.owner != null && this.owner != appname) {
            long deadline = System.currentTimeMillis() + (long)timeout;
            long remaining = timeout;
            while (enumeration.hasMoreElements()) {
                lstnr = (CommPortOwnershipListener)enumeration.nextElement();
                ++this.ownershipcallback;
                lstnr.ownershipChange(2);
                --this.ownershipcallback;
            }
            while (remaining > 0L && this.owner != null) {
                try {
                    this.wait(remaining);
                    remaining = deadline - System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.owner != null) {
                PortInUseException piue = new PortInUseException();
                piue.currentOwner = this.owner;
                throw piue;
            }
        }
        if (this.commport == null) {
            this.commport = this.driver.getCommPort(this.name, this.type);
            if (this.commport == null) {
                throw new PortInUseException();
            }
            this.commport.commPortIdentifier = this;
        }
        enumeration = snapshot.elements();
        while (enumeration.hasMoreElements()) {
            lstnr = (CommPortOwnershipListener)enumeration.nextElement();
            ++this.ownershipcallback;
            lstnr.ownershipChange(1);
            --this.ownershipcallback;
        }
        this.owner = appname;
        if (this.commport.closed) {
            this.commport = this.driver.getCommPort(this.name, this.type);
            this.commport.commPortIdentifier = this;
        }
        return this.commport;
    }

    synchronized void handle_close() {
        Vector snapshot = (Vector)this.ownershiplisteners.clone();
        Enumeration enumeration = snapshot.elements();
        this.owner = null;
        if (this.ownershipcallback == 0) {
            while (enumeration.hasMoreElements()) {
                CommPortOwnershipListener lstnr = (CommPortOwnershipListener)enumeration.nextElement();
                ++this.ownershipcallback;
                lstnr.ownershipChange(3);
                --this.ownershipcallback;
            }
        }
        if (this.type == 1) {
            ((SerialPort)this.commport).removeEventListener();
        }
        this.notifyAll();
    }

    public CommPort open(FileDescriptor fd) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void addPortOwnershipListener(CommPortOwnershipListener listener) {
        this.ownershiplisteners.addElement(listener);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener listener) {
        this.ownershiplisteners.removeElement(listener);
    }

    private CommPortIdentifier(String portName, int portType, CommDriver driver) throws NoSuchPortException {
        this.name = portName;
        this.type = portType;
        this.driver = driver;
        this.ownershiplisteners = new Vector();
    }

    static {
        UARTDriver driver = UARTDriver.getInstance();
        driver.initialize();
    }
}

