/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.ZipConstants;
import java.util.zip.ZipFile;

public class ZipEntry
implements ZipConstants,
Cloneable {
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    String comment;
    String name;
    int method = -1;
    long time = -1L;
    long crc = -1L;
    long size = -1L;
    long compressedSize = -1L;
    byte[] extra;
    long pointer;
    ZipFile zipFile;

    public ZipEntry(ZipEntry ze) {
        this.name = ze.name;
        this.comment = ze.comment;
        this.method = ze.method;
        this.time = ze.time;
        this.crc = ze.crc;
        this.size = ze.size;
        this.compressedSize = ze.compressedSize;
        this.extra = ze.extra;
        this.pointer = ze.pointer;
        this.zipFile = ze.zipFile;
    }

    public ZipEntry(String zname) {
        if (zname.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.name = zname;
    }

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public void setComment(String cmnt) {
        if (cmnt != null && cmnt.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = cmnt;
    }

    public void setCrc(long CRC) {
        this.crc = CRC;
    }

    public void setExtra(byte[] xtra) {
        if (xtra != null && xtra.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = xtra;
    }

    public void setMethod(int m) {
        if (m != 0 && m != 8) {
            throw new IllegalArgumentException();
        }
        this.method = m;
    }

    public void setSize(long sz) {
        if (sz < 0L) {
            throw new IllegalArgumentException();
        }
        this.size = sz;
    }

    public void setTime(long t) {
        this.time = t;
    }

    public void setCompressedSize(long cpsize) {
        this.compressedSize = cpsize;
    }

    public Object clone() {
        try {
            ZipEntry ze = (ZipEntry)super.clone();
            ze.extra = (byte[])this.extra.clone();
            return ze;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }
}

