/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InflaterInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int len;
    protected Inflater inf;
    private boolean closed;

    protected void fill() throws IOException {
        this.len = this.in.read(this.buf, 0, this.buf.length);
    }

    public int available() throws IOException {
        return 1 - this.closed;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int ret = this.read(b, 0, 1);
        if (ret != -1) {
            ret = 0xFF & (char)b[0];
        }
        return ret;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (offset < 0 || this.len < 0 || length + offset > buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int rd = 0;
        while (length > 0) {
            int ret;
            try {
                ret = this.inf.inflate(buffer, offset, length);
            }
            catch (DataFormatException dfe) {
                throw new ZipException("stream is corrupted");
            }
            if (ret == 0) {
                if (this.inf.finished()) {
                    if (rd != 0) break;
                    --rd;
                    break;
                }
                if (this.inf.needsInput()) {
                    this.len = this.in.read(this.buf, 0, this.buf.length);
                    if (this.len == -1) {
                        if (rd != 0) break;
                        --rd;
                        break;
                    }
                    this.inf.setInput(this.buf, 0, this.len);
                } else {
                    if (!this.inf.needsDictionary()) break;
                    rd = -1;
                    break;
                }
            }
            length -= ret;
            offset += ret;
            rd += ret;
        }
        return rd;
    }

    public long skip(long n) throws IOException {
        long skipped = 0L;
        if (n > 0L) {
            int count = n > 1024L ? 1024 : (int)n;
            byte[] buffer = new byte[count];
            while (n > 0L) {
                int rd = this.read(buffer, 0, (long)count > n ? (int)n : count);
                if (rd == -1) break;
                skipped += (long)rd;
                n -= (long)rd;
            }
        }
        return skipped;
    }

    private final /* synthetic */ void this() {
        this.closed = false;
    }

    public InflaterInputStream(InputStream in) {
        this(in, new Inflater(), 512);
    }

    public InflaterInputStream(InputStream in, Inflater infl) {
        this(in, infl, 512);
    }

    public InflaterInputStream(InputStream in, Inflater infl, int bufsize) {
        super(in);
        this.this();
        if (infl == null) {
            throw new NullPointerException();
        }
        this.inf = infl;
        this.buf = new byte[bufsize];
    }
}

